/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.alarm;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.alarm.AlarmCountEvent;
import com.tridium.cloudLink.alarm.SingleAlarmCounts;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSource;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class AlarmCounter {
    private static final String STATION_ID = "station";
    private static final String TOTAL_KEY = "total";
    private final int[] singles = new int[BAckState.DEFAULT.getRange().getOrdinals().length];
    private final int[] totals = new int[BAckState.DEFAULT.getRange().getOrdinals().length];
    private static final String[] ackStates = new String[]{BAckState.acked.toString().toLowerCase(), BAckState.unacked.toString().toLowerCase(), BAckState.ackPending.toString().toLowerCase()};
    private BAlarmService alarmService;
    public static final Logger log = Logger.getLogger("cloudLink.channel.alarm");

    public AlarmCountEvent countAlarms() {
        AlarmCountEvent alarmCountEvent = new AlarmCountEvent();
        BAlarmService alarmService = this.getAlarmService();
        SingleAlarmCounts stationCounts = new SingleAlarmCounts(STATION_ID);
        Arrays.fill(this.totals, 0);
        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
            log.fine("Starting the alarm counter.");
            stationCounts.set(TOTAL_KEY, conn.getRecordCount());
            Cursor sources = conn.getOpenAlarmSources();
            while (sources.next()) {
                BAlarmSource source = (BAlarmSource)sources.get();
                String sourceId = AlarmCounter.getSourceId(source);
                BOrdList ordList = source.getSourceOrdList();
                Cursor openAlarmsForSource = conn.getOpenAlarmsForSource(ordList);
                Arrays.fill(this.singles, 0);
                while (openAlarmsForSource.next()) {
                    BAlarmRecord alarmRecord = (BAlarmRecord)openAlarmsForSource.get();
                    int n = alarmRecord.getAckState().getOrdinal();
                    this.singles[n] = this.singles[n] + 1;
                }
                SingleAlarmCounts countsForSource = new SingleAlarmCounts(sourceId);
                for (int state = 0; state < ackStates.length; ++state) {
                    countsForSource.set(ackStates[state], this.singles[state]);
                    int n = state;
                    this.totals[n] = this.totals[n] + this.singles[state];
                }
                alarmCountEvent.add(countsForSource);
            }
        }
        catch (IOException | AlarmException ex) {
            log.log(Level.INFO, "Cannot read alarms from Database for counting.", log.isLoggable(Level.FINE) ? ex : null);
        }
        for (int state = 0; state < ackStates.length; ++state) {
            stationCounts.set(ackStates[state], this.totals[state]);
        }
        alarmCountEvent.add(stationCounts);
        log.fine("Alarm counts: " + alarmCountEvent.getSources());
        log.fine("Finished counting alarms.");
        return alarmCountEvent;
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    private static String getSourceId(BAlarmSource source) {
        BOrdList ordList = source.getSourceOrdList();
        try {
            BOrd sourceOrd = BOrd.DEFAULT;
            if (ordList.size() > 0) {
                sourceOrd = ordList.get(ordList.size() - 1);
            }
            BObject sourceObj = BOrd.make((BOrd)BOrd.make((String)"local:|station:|slot:/"), (BOrd)sourceOrd).resolve().get();
            BControlPoint sourcePoint = null;
            if (sourceObj instanceof BAlarmSourceExt) {
                sourcePoint = ((BAlarmSourceExt)sourceObj.as(BAlarmSourceExt.class)).getParentPoint();
            } else if (sourceObj instanceof BIAlarmSource) {
                BComponent parent = sourceObj.asComplex().getParent().asComponent();
                if (parent instanceof BControlPoint) {
                    sourcePoint = (BControlPoint)parent.as(BControlPoint.class);
                } else {
                    log.finest(() -> String.format("BIAlarmSource parent is not a control point:%s [%s]", parent.getSlotPath(), parent.getType()));
                }
            }
            if (sourcePoint != null) {
                return TagUtil.getCloudIdString((BIObject)sourcePoint).orElse(ordList.encodeToString());
            }
            return TagUtil.getCloudIdString((BIObject)sourceObj).orElse(ordList.encodeToString());
        }
        catch (BajaRuntimeException ex) {
            log.log(Level.CONFIG, "Cannot resolve alarm to cloud point: " + (Object)((Object)ex), log.isLoggable(Level.FINE) ? ex : null);
            return ordList.encodeToString();
        }
    }
}

