/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink;

import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BNullChannelConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAbstractChannelConfigFactory
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractChannelConfigFactory.class);
    protected Map<String, Class<? extends BChannelConfig>> configTypes = new HashMap<String, Class<? extends BChannelConfig>>();
    private static final Logger log = Logger.getLogger("cloudLink.ChannelConfigFactory");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BAbstractChannelConfigFactory() {
        this.registerConfigs();
    }

    public abstract String getPlatformType();

    public String getKey() {
        return this.getPlatformType();
    }

    public BChannelConfig getChannelConfig(String channel) {
        Class<? extends BChannelConfig> make = this.configTypes.get(channel);
        if (make == null) {
            log.config(String.format("ChannelConfig for %s not registered for platform %s returning nullConfig", channel, this.getPlatformType()));
            return new BNullChannelConfig();
        }
        try {
            return make.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("Unable to create ChannelConfig for " + channel, ex);
        }
    }

    protected abstract void registerConfigs();
}

