/*
 * Decompiled with CFR 0.152.
 */
package biweekly.parameter;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.Messages;
import biweekly.ValidationWarning;
import biweekly.parameter.CalendarUserType;
import biweekly.parameter.Display;
import biweekly.parameter.Encoding;
import biweekly.parameter.EnumParameterValue;
import biweekly.parameter.Feature;
import biweekly.parameter.FreeBusyType;
import biweekly.parameter.ParticipationStatus;
import biweekly.parameter.Range;
import biweekly.parameter.Related;
import biweekly.parameter.RelationshipType;
import biweekly.parameter.Role;
import biweekly.util.ListMultimap;
import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import com.github.mangstadt.vinnie.validate.VObjectValidator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ICalParameters
extends ListMultimap<String, String> {
    public static final String ALTREP = "ALTREP";
    public static final String CHARSET = "CHARSET";
    public static final String CN = "CN";
    public static final String CUTYPE = "CUTYPE";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DIR = "DIR";
    public static final String DISPLAY = "DISPLAY";
    public static final String EMAIL = "EMAIL";
    public static final String ENCODING = "ENCODING";
    public static final String EXPECT = "EXPECT";
    public static final String FEATURE = "FEATURE";
    public static final String FMTTYPE = "FMTTYPE";
    public static final String FBTYPE = "FBTYPE";
    public static final String LABEL = "LABEL";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MEMBER = "MEMBER";
    public static final String PARTSTAT = "PARTSTAT";
    public static final String RANGE = "RANGE";
    public static final String RELATED = "RELATED";
    public static final String RELTYPE = "RELTYPE";
    public static final String ROLE = "ROLE";
    public static final String RSVP = "RSVP";
    public static final String SENT_BY = "SENT-BY";
    public static final String STATUS = "STATUS";
    public static final String TYPE = "TYPE";
    public static final String TZID = "TZID";
    public static final String VALUE = "VALUE";

    public ICalParameters() {
        super(0);
    }

    public ICalParameters(ICalParameters parameters) {
        super(parameters);
    }

    public ICalParameters(Map<String, List<String>> map) {
        super(map);
    }

    public String getAltRepresentation() {
        return (String)this.first(ALTREP);
    }

    public void setAltRepresentation(String uri) {
        this.replace(ALTREP, uri);
    }

    public String getCharset() {
        return (String)this.first(CHARSET);
    }

    public void setCharset(String charset) {
        this.replace(CHARSET, charset);
    }

    public String getCommonName() {
        return (String)this.first(CN);
    }

    public void setCommonName(String cn) {
        this.replace(CN, cn);
    }

    public CalendarUserType getCalendarUserType() {
        String value = (String)this.first(CUTYPE);
        return value == null ? null : CalendarUserType.get(value);
    }

    public void setCalendarUserType(CalendarUserType calendarUserType) {
        this.replace(CUTYPE, calendarUserType == null ? null : calendarUserType.getValue());
    }

    public List<String> getDelegatedFrom() {
        return this.get(DELEGATED_FROM);
    }

    public List<String> getDelegatedTo() {
        return this.get(DELEGATED_TO);
    }

    public String getDirectoryEntry() {
        return (String)this.first(DIR);
    }

    public void setDirectoryEntry(String uri) {
        this.replace(DIR, uri);
    }

    public List<Display> getDisplays() {
        return new EnumParameterList<Display>(DISPLAY){

            @Override
            protected Display _asObject(String value) {
                return Display.get(value);
            }
        };
    }

    public String getEmail() {
        return (String)this.first(EMAIL);
    }

    public void setEmail(String email) {
        this.replace(EMAIL, email);
    }

    public Encoding getEncoding() {
        String value = (String)this.first(ENCODING);
        return value == null ? null : Encoding.get(value);
    }

    public void setEncoding(Encoding encoding) {
        this.replace(ENCODING, encoding == null ? null : encoding.getValue());
    }

    public String getExpect() {
        return (String)this.first(EXPECT);
    }

    public void setExpect(String expect) {
        this.replace(EXPECT, expect);
    }

    public List<Feature> getFeatures() {
        return new EnumParameterList<Feature>(FEATURE){

            @Override
            protected Feature _asObject(String value) {
                return Feature.get(value);
            }
        };
    }

    public String getFormatType() {
        return (String)this.first(FMTTYPE);
    }

    public void setFormatType(String formatType) {
        this.replace(FMTTYPE, formatType);
    }

    public FreeBusyType getFreeBusyType() {
        String value = (String)this.first(FBTYPE);
        return value == null ? null : FreeBusyType.get(value);
    }

    public void setFreeBusyType(FreeBusyType freeBusyType) {
        this.replace(FBTYPE, freeBusyType == null ? null : freeBusyType.getValue());
    }

    public String getLabel() {
        return (String)this.first(LABEL);
    }

    public void setLabel(String label) {
        this.replace(LABEL, label);
    }

    public String getLanguage() {
        return (String)this.first(LANGUAGE);
    }

    public void setLanguage(String language) {
        this.replace(LANGUAGE, language);
    }

    public List<String> getMembers() {
        return this.get(MEMBER);
    }

    public String getParticipationStatus() {
        return (String)this.first(PARTSTAT);
    }

    public void setParticipationStatus(String participationStatus) {
        this.replace(PARTSTAT, participationStatus);
    }

    public Range getRange() {
        String value = (String)this.first(RANGE);
        return value == null ? null : Range.get(value);
    }

    public void setRange(Range range) {
        this.replace(RANGE, range == null ? null : range.getValue());
    }

    public Related getRelated() {
        String value = (String)this.first(RELATED);
        return value == null ? null : Related.get(value);
    }

    public void setRelated(Related related) {
        this.replace(RELATED, related == null ? null : related.getValue());
    }

    public RelationshipType getRelationshipType() {
        String value = (String)this.first(RELTYPE);
        return value == null ? null : RelationshipType.get(value);
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.replace(RELTYPE, relationshipType == null ? null : relationshipType.getValue());
    }

    public String getRole() {
        return (String)this.first(ROLE);
    }

    public void setRole(String role) {
        this.replace(ROLE, role);
    }

    public String getRsvp() {
        return (String)this.first(RSVP);
    }

    public void setRsvp(String rsvp) {
        this.replace(RSVP, rsvp);
    }

    public String getSentBy() {
        return (String)this.first(SENT_BY);
    }

    public void setSentBy(String uri) {
        this.replace(SENT_BY, uri);
    }

    public String getStatus() {
        return (String)this.first(STATUS);
    }

    public void setStatus(String status) {
        this.replace(STATUS, status);
    }

    public String getTimezoneId() {
        return (String)this.first(TZID);
    }

    public void setTimezoneId(String timezoneId) {
        this.replace(TZID, timezoneId);
    }

    public String getType() {
        return (String)this.first(TYPE);
    }

    public void setType(String type) {
        this.replace(TYPE, type);
    }

    public ICalDataType getValue() {
        String value = (String)this.first(VALUE);
        return value == null ? null : ICalDataType.get(value);
    }

    public void setValue(ICalDataType dataType) {
        this.replace(VALUE, dataType == null ? null : dataType.getName());
    }

    public List<ValidationWarning> validate(ICalVersion version) {
        ArrayList<ValidationWarning> warnings = new ArrayList<ValidationWarning>(0);
        SyntaxStyle syntax = version == ICalVersion.V1_0 ? SyntaxStyle.OLD : SyntaxStyle.NEW;
        this.checkForInvalidChars(syntax, warnings);
        this.validateRsvpParameter(warnings);
        this.validateCutypeParameter(warnings);
        this.validateEncodingParameter(warnings);
        this.validateFbtypeParameter(warnings);
        this.validatePartstatParameter(warnings);
        this.validateRangeParameter(warnings, version);
        this.validateRelatedParameter(warnings);
        this.validateReltypeParameter(warnings);
        this.validateRoleParameter(warnings);
        this.validateValueParameter(warnings);
        return warnings;
    }

    private void checkForInvalidChars(SyntaxStyle syntax, List<ValidationWarning> warnings) {
        for (Map.Entry entry : this) {
            String name = (String)entry.getKey();
            this.validateParameterName(name, syntax, warnings);
            List values = entry.getValue();
            for (String value : values) {
                this.validateParameterValue(name, value, syntax, warnings);
            }
        }
    }

    private void validateParameterName(String name, SyntaxStyle syntax, List<ValidationWarning> warnings) {
        ValidationWarning warning;
        if (VObjectValidator.validateParameterName(name, syntax, true)) {
            return;
        }
        if (syntax == SyntaxStyle.OLD) {
            AllowedCharacters notAllowed = VObjectValidator.allowedCharactersParameterName(syntax, true).flip();
            warning = new ValidationWarning(57, name, notAllowed.toString(true));
        } else {
            warning = new ValidationWarning(54, name);
        }
        warnings.add(warning);
    }

    private void validateParameterValue(String name, String value, SyntaxStyle syntax, List<ValidationWarning> warnings) {
        if (VObjectValidator.validateParameterValue(value, syntax, false, true)) {
            return;
        }
        AllowedCharacters notAllowed = VObjectValidator.allowedCharactersParameterValue(syntax, false, true).flip();
        int code = syntax == SyntaxStyle.OLD ? 58 : 53;
        warnings.add(new ValidationWarning(code, name, value, notAllowed.toString(true)));
    }

    private void validateRsvpParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(RSVP);
        if (value == null) {
            return;
        }
        value = value.toLowerCase();
        List<String> validValues = Arrays.asList("true", "false", "yes", "no");
        if (!validValues.contains(value)) {
            warnings.add(new ValidationWarning(1, RSVP, value, validValues));
        }
    }

    private void validateCutypeParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(CUTYPE);
        if (value == null || CalendarUserType.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, CUTYPE, value, CalendarUserType.all()));
    }

    private void validateEncodingParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(ENCODING);
        if (value == null || Encoding.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, ENCODING, value, Encoding.all()));
    }

    private void validateFbtypeParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(FBTYPE);
        if (value == null || FreeBusyType.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, FBTYPE, value, FreeBusyType.all()));
    }

    private void validatePartstatParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(PARTSTAT);
        if (value == null || ParticipationStatus.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, PARTSTAT, value, ParticipationStatus.all()));
    }

    private void validateRangeParameter(List<ValidationWarning> warnings, ICalVersion version) {
        String value = (String)this.first(RANGE);
        if (value == null) {
            return;
        }
        Range range = Range.find(value);
        if (range == null) {
            warnings.add(new ValidationWarning(1, RANGE, value, Range.all()));
        }
        if (range == Range.THIS_AND_PRIOR && version == ICalVersion.V2_0) {
            warnings.add(new ValidationWarning(47, RANGE, value));
        }
    }

    private void validateRelatedParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(RELATED);
        if (value == null || Related.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, RELATED, value, Related.all()));
    }

    private void validateReltypeParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(RELTYPE);
        if (value == null || RelationshipType.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, RELTYPE, value, RelationshipType.all()));
    }

    private void validateRoleParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(ROLE);
        if (value == null || Role.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, ROLE, value, Role.all()));
    }

    private void validateValueParameter(List<ValidationWarning> warnings) {
        String value = (String)this.first(VALUE);
        if (value == null || ICalDataType.find(value) != null) {
            return;
        }
        warnings.add(new ValidationWarning(1, VALUE, value, ICalDataType.all()));
    }

    @Override
    protected String sanitizeKey(String key) {
        return key == null ? null : key.toUpperCase();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (Map.Entry entry : this) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            int valueHash = 1;
            for (String v : value) {
                valueHash += v.toLowerCase().hashCode();
            }
            int entryHash = 1;
            entryHash += 31 * entryHash + (key == null ? 0 : key.toLowerCase().hashCode());
            entryHash += 31 * entryHash + valueHash;
            result += entryHash;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICalParameters other = (ICalParameters)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (Map.Entry entry : this) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            List otherValue = other.get(key);
            if (value.size() != otherValue.size()) {
                return false;
            }
            ArrayList<String> valueLower = new ArrayList<String>(value.size());
            for (String v : value) {
                valueLower.add(v.toLowerCase());
            }
            Collections.sort(valueLower);
            ArrayList<String> otherValueLower = new ArrayList<String>(otherValue.size());
            for (String v : otherValue) {
                otherValueLower.add(v.toLowerCase());
            }
            Collections.sort(otherValueLower);
            if (valueLower.equals(otherValueLower)) continue;
            return false;
        }
        return true;
    }

    public abstract class ICalParameterList<T>
    extends AbstractList<T> {
        protected final String parameterName;
        protected final List<String> parameterValues;

        protected ICalParameterList(String parameterName) {
            this.parameterName = parameterName;
            this.parameterValues = ICalParameters.this.get(parameterName);
        }

        @Override
        public void add(int index, T value) {
            String valueStr = this._asString(value);
            this.parameterValues.add(index, valueStr);
        }

        @Override
        public T remove(int index) {
            String removed = this.parameterValues.remove(index);
            return this.asObject(removed);
        }

        @Override
        public T get(int index) {
            String value = this.parameterValues.get(index);
            return this.asObject(value);
        }

        @Override
        public T set(int index, T value) {
            String valueStr = this._asString(value);
            String replaced = this.parameterValues.set(index, valueStr);
            return this.asObject(replaced);
        }

        @Override
        public int size() {
            return this.parameterValues.size();
        }

        private T asObject(String value) {
            try {
                return this._asObject(value);
            }
            catch (Exception e) {
                throw new IllegalStateException(Messages.INSTANCE.getExceptionMessage(26, this.parameterName), e);
            }
        }

        protected abstract String _asString(T var1);

        protected abstract T _asObject(String var1) throws Exception;
    }

    public abstract class EnumParameterList<T extends EnumParameterValue>
    extends ICalParameterList<T> {
        protected EnumParameterList(String parameterName) {
            super(parameterName);
        }

        @Override
        protected String _asString(T value) {
            return ((EnumParameterValue)value).getValue();
        }
    }
}

