/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RequestStatus;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.EnumSet;
import java.util.Set;

public class RequestStatusScribe
extends ICalPropertyScribe<RequestStatus> {
    public RequestStatusScribe() {
        super(RequestStatus.class, "REQUEST-STATUS", ICalDataType.TEXT);
    }

    @Override
    protected String _writeText(RequestStatus property, WriteContext context) {
        VObjectPropertyValues.SemiStructuredValueBuilder builder = new VObjectPropertyValues.SemiStructuredValueBuilder();
        builder.append(property.getStatusCode());
        builder.append(property.getDescription());
        builder.append(property.getExceptionText());
        boolean escapeCommas = context.getVersion() != ICalVersion.V1_0;
        return builder.build(escapeCommas, true);
    }

    @Override
    protected RequestStatus _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value);
        RequestStatus requestStatus = new RequestStatus(it.next());
        requestStatus.setDescription(it.next());
        requestStatus.setExceptionText(it.next());
        return requestStatus;
    }

    @Override
    protected void _writeXml(RequestStatus property, XCalElement element, WriteContext context) {
        String code = property.getStatusCode();
        element.append("code", code);
        String description = property.getDescription();
        element.append("description", description);
        String data = property.getExceptionText();
        if (data != null) {
            element.append("data", data);
        }
    }

    @Override
    protected RequestStatus _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String code = element.first("code");
        if (code == null) {
            throw RequestStatusScribe.missingXmlElements("code");
        }
        RequestStatus requestStatus = new RequestStatus(RequestStatusScribe.s(code));
        requestStatus.setDescription(RequestStatusScribe.s(element.first("description")));
        requestStatus.setExceptionText(RequestStatusScribe.s(element.first("data")));
        return requestStatus;
    }

    @Override
    protected JCalValue _writeJson(RequestStatus property, WriteContext context) {
        return JCalValue.structured(property.getStatusCode(), property.getDescription(), property.getExceptionText());
    }

    @Override
    protected RequestStatus _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        RequestStatus requestStatus = new RequestStatus(it.nextValue());
        requestStatus.setDescription(it.nextValue());
        requestStatus.setExceptionText(it.nextValue());
        return requestStatus;
    }

    private static String s(String str) {
        return str == null || str.isEmpty() ? null : str;
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

