/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.DataModelConversionException;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarning;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.RecurrenceParserV1;
import biweekly.io.scribe.property.RecurrenceWriterV1;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateStart;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.RecurrenceProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.ICalDate;
import biweekly.util.ListMultimap;
import biweekly.util.Recurrence;
import biweekly.util.XmlUtils;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public abstract class RecurrencePropertyScribe<T extends RecurrenceProperty>
extends ICalPropertyScribe<T> {
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";

    protected RecurrencePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.RECUR;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return "";
        }
        switch (context.getVersion()) {
            case V1_0: {
                return this.writeTextV1(property, context);
            }
        }
        return this.writeTextV2(property, context);
    }

    private String writeTextV1(T property, WriteContext context) {
        return new RecurrenceWriterV1((RecurrenceProperty)property, context).write();
    }

    private String writeTextV2(T property, WriteContext context) {
        ListMultimap<String, Object> components = this.buildComponents(property, context, false);
        return VObjectPropertyValues.writeMultimap(components.getMap());
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        if (value.isEmpty()) {
            return this.newInstance(new Recurrence.Builder((Frequency)null).build());
        }
        switch (context.getVersion()) {
            case V1_0: {
                return this.parseTextV1(value, dataType, parameters, context);
            }
        }
        return this.parseTextV2(value, dataType, parameters, context);
    }

    private T parseTextV1(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        RecurrenceParserV1 parser = new RecurrenceParserV1(context);
        List<String> rrules = RecurrenceParserV1.splitPropertyValue(value);
        if (rrules.size() == 1) {
            Recurrence recur = parser.parse(value);
            return this.newInstance(recur, context, parameters);
        }
        DataModelConversionException conversionException = new DataModelConversionException(null);
        for (String rrule : rrules) {
            Object property;
            ICalParameters parametersCopy = new ICalParameters(parameters);
            try {
                Recurrence recur = parser.parse(rrule);
                property = this.newInstance(recur, context, parameters);
            }
            catch (CannotParseException e) {
                context.getWarnings().add(new ParseWarning.Builder(context).message(e).build());
                property = new RawProperty(this.getPropertyName(context.getVersion()), dataType, rrule);
                ((ICalProperty)property).setParameters(parametersCopy);
            }
            conversionException.getProperties().add((ICalProperty)property);
        }
        throw conversionException;
    }

    private T parseTextV2(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        ListMultimap<String, String> rules = new ListMultimap<String, String>(VObjectPropertyValues.parseMultimap(value));
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        return this.newInstance(builder.build(), context, parameters);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        XCalElement recurElement = element.append(this.dataType(property, null));
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return;
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        for (Map.Entry<String, List<Object>> entry : components) {
            String name = entry.getKey().toLowerCase();
            for (Object value : entry.getValue()) {
                recurElement.append(name, value.toString());
            }
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        XCalElement value = element.child(dataType);
        if (value == null) {
            throw RecurrencePropertyScribe.missingXmlElements(dataType);
        }
        ListMultimap<String, String> rules = new ListMultimap<String, String>();
        for (Element child : XmlUtils.toElementList(value.getElement().getChildNodes())) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String name = child.getLocalName().toUpperCase();
            String text = child.getTextContent();
            rules.put(name, text);
        }
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        T property = this.newInstance(builder.build());
        ICalDate until = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (until != null) {
            context.addDate(until, (ICalProperty)property, parameters);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return JCalValue.object(new ListMultimap<String, Object>(0));
        }
        ListMultimap<String, Object> components = this.buildComponents(property, context, true);
        ListMultimap<String, Object> object = new ListMultimap<String, Object>(components.keySet().size());
        for (Map.Entry<String, List<Object>> entry : components) {
            String key = entry.getKey().toLowerCase();
            object.putAll(key, (Collection<Object>)entry.getValue());
        }
        return JCalValue.object(object);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        ListMultimap<String, String> object = value.asObject();
        ListMultimap<String, String> rules = new ListMultimap<String, String>(object.keySet().size());
        for (Map.Entry<String, List<String>> entry : object) {
            String key = entry.getKey().toUpperCase();
            rules.putAll(key, (Collection<String>)entry.getValue());
        }
        this.parseFreq(rules, builder, context);
        this.parseUntil(rules, builder, context);
        this.parseCount(rules, builder, context);
        this.parseInterval(rules, builder, context);
        this.parseBySecond(rules, builder, context);
        this.parseByMinute(rules, builder, context);
        this.parseByHour(rules, builder, context);
        this.parseByDay(rules, builder, context);
        this.parseByMonthDay(rules, builder, context);
        this.parseByYearDay(rules, builder, context);
        this.parseByWeekNo(rules, builder, context);
        this.parseByMonth(rules, builder, context);
        this.parseBySetPos(rules, builder, context);
        this.parseWkst(rules, builder, context);
        this.parseXRules(rules, builder);
        T property = this.newInstance(builder.build());
        ICalDate iCalDate = ((Recurrence)((ValuedProperty)property).getValue()).getUntil();
        if (iCalDate != null) {
            context.addDate(iCalDate, (ICalProperty)property, parameters);
        }
        return property;
    }

    protected abstract T newInstance(Recurrence var1);

    private T newInstance(Recurrence recur, ParseContext context, ICalParameters parameters) {
        T property = this.newInstance(recur);
        if (recur.getUntil() != null) {
            context.addDate(recur.getUntil(), (ICalProperty)property, parameters);
        }
        return property;
    }

    private void parseFreq(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, FREQ, new Handler<String>(){

            @Override
            public void handle(String value) {
                value = value.toUpperCase();
                try {
                    builder.frequency(Frequency.valueOf(value));
                }
                catch (IllegalArgumentException e) {
                    context.addWarning(7, RecurrencePropertyScribe.FREQ, value);
                }
            }
        });
    }

    private void parseUntil(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, UNTIL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.until(ICalPropertyScribe.date(value).parse());
                }
                catch (IllegalArgumentException e) {
                    context.addWarning(7, RecurrencePropertyScribe.UNTIL, value);
                }
            }
        });
    }

    private void parseCount(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, COUNT, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.count(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    context.addWarning(7, RecurrencePropertyScribe.COUNT, value);
                }
            }
        });
    }

    private void parseInterval(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, INTERVAL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.interval(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    context.addWarning(7, RecurrencePropertyScribe.INTERVAL, value);
                }
            }
        });
    }

    private void parseBySecond(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYSECOND, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySecond(value);
            }
        });
    }

    private void parseByMinute(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMINUTE, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMinute(value);
            }
        });
    }

    private void parseByHour(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYHOUR, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byHour(value);
            }
        });
    }

    private void parseByDay(ListMultimap<String, String> rules, Recurrence.Builder builder, ParseContext context) {
        Pattern p = Pattern.compile("^([-+]?\\d+)?(.*)$");
        for (String value : rules.removeAll(BYDAY)) {
            Matcher m = p.matcher(value);
            if (!m.find()) {
                context.addWarning(7, BYDAY, value);
                continue;
            }
            String dayStr = m.group(2);
            DayOfWeek day = DayOfWeek.valueOfAbbr(dayStr);
            if (day == null) {
                context.addWarning(7, BYDAY, value);
                continue;
            }
            String prefixStr = m.group(1);
            Integer prefix = prefixStr == null ? null : Integer.valueOf(prefixStr);
            builder.byDay(prefix, day);
        }
    }

    private void parseByMonthDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMONTHDAY, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonthDay(value);
            }
        });
    }

    private void parseByYearDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYYEARDAY, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byYearDay(value);
            }
        });
    }

    private void parseByWeekNo(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYWEEKNO, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byWeekNo(value);
            }
        });
    }

    private void parseByMonth(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYMONTH, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonth(value);
            }
        });
    }

    private void parseBySetPos(ListMultimap<String, String> rules, final Recurrence.Builder builder, ParseContext context) {
        this.parseIntegerList(BYSETPOS, rules, context, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySetPos(value);
            }
        });
    }

    private void parseWkst(ListMultimap<String, String> rules, final Recurrence.Builder builder, final ParseContext context) {
        this.parseFirst(rules, WKST, new Handler<String>(){

            @Override
            public void handle(String value) {
                DayOfWeek day = DayOfWeek.valueOfAbbr(value);
                if (day == null) {
                    context.addWarning(7, RecurrencePropertyScribe.WKST, value);
                    return;
                }
                builder.workweekStarts(day);
            }
        });
    }

    private void parseXRules(ListMultimap<String, String> rules, Recurrence.Builder builder) {
        for (Map.Entry<String, List<String>> entry : rules) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                builder.xrule(name, value);
            }
        }
    }

    private ListMultimap<String, Object> buildComponents(T property, WriteContext context, boolean extended) {
        ICalDate until;
        ListMultimap<String, Object> components = new ListMultimap<String, Object>();
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur.getFrequency() != null) {
            components.put(FREQ, recur.getFrequency().name());
        }
        if ((until = recur.getUntil()) != null) {
            components.put(UNTIL, this.writeUntil(until, context, extended));
        }
        if (recur.getCount() != null) {
            components.put(COUNT, recur.getCount());
        }
        if (recur.getInterval() != null) {
            components.put(INTERVAL, recur.getInterval());
        }
        components.putAll(BYSECOND, recur.getBySecond());
        components.putAll(BYMINUTE, recur.getByMinute());
        components.putAll(BYHOUR, recur.getByHour());
        for (ByDay byDay : recur.getByDay()) {
            Integer prefix = byDay.getNum();
            DayOfWeek day = byDay.getDay();
            String value = day.getAbbr();
            if (prefix != null) {
                value = prefix + value;
            }
            components.put(BYDAY, value);
        }
        components.putAll(BYMONTHDAY, recur.getByMonthDay());
        components.putAll(BYYEARDAY, recur.getByYearDay());
        components.putAll(BYWEEKNO, recur.getByWeekNo());
        components.putAll(BYMONTH, recur.getByMonth());
        components.putAll(BYSETPOS, recur.getBySetPos());
        if (recur.getWorkweekStarts() != null) {
            components.put(WKST, recur.getWorkweekStarts().getAbbr());
        }
        for (Map.Entry entry : recur.getXRules().entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            components.putAll(name, values);
        }
        return components;
    }

    private String writeUntil(ICalDate until, WriteContext context, boolean extended) {
        if (!until.hasTime()) {
            return RecurrencePropertyScribe.date(until).extended(extended).write();
        }
        if (RecurrencePropertyScribe.isInObservance(context)) {
            return RecurrencePropertyScribe.date(until).utc(true).extended(extended).write();
        }
        if (context.getVersion() == ICalVersion.V2_0_DEPRECATED) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        ICalComponent parent = context.getParent();
        if (parent == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        DateStart dtstart = parent.getProperty(DateStart.class);
        if (dtstart == null) {
            return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
        }
        TimezoneInfo tzinfo = context.getTimezoneInfo();
        boolean dtstartFloating = tzinfo.isFloating(dtstart);
        if (dtstartFloating) {
            return RecurrencePropertyScribe.date(until).extended(extended).tz(true, null).write();
        }
        return RecurrencePropertyScribe.date(until).extended(extended).utc(true).write();
    }

    private void parseFirst(ListMultimap<String, String> rules, String name, Handler<String> handler) {
        List<String> values = rules.removeAll(name);
        if (values.isEmpty()) {
            return;
        }
        String value = values.get(0);
        handler.handle(value);
    }

    private void parseIntegerList(String name, ListMultimap<String, String> rules, ParseContext context, Handler<Integer> handler) {
        List<String> values = rules.removeAll(name);
        for (String value : values) {
            try {
                handler.handle(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                context.addWarning(8, name, value);
            }
        }
    }

    private static interface Handler<T> {
        public void handle(T var1);
    }
}

