/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ListProperty;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.ArrayList;
import java.util.List;

public abstract class ListPropertyScribe<T extends ListProperty<V>, V>
extends ICalPropertyScribe<T> {
    protected ListPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, ICalDataType.TEXT);
    }

    protected ListPropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        List values = ((ListProperty)property).getValues();
        ArrayList<String> valuesStr = new ArrayList<String>(values.size());
        for (Object value : values) {
            String valueStr = this.writeValue(property, value, context);
            valuesStr.add(valueStr);
        }
        switch (context.getVersion()) {
            case V1_0: {
                return VObjectPropertyValues.writeSemiStructured(valuesStr, false, true);
            }
        }
        return VObjectPropertyValues.writeList(valuesStr);
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        List<String> values;
        switch (context.getVersion()) {
            case V1_0: {
                values = VObjectPropertyValues.parseSemiStructured(value);
                break;
            }
            default: {
                values = VObjectPropertyValues.parseList(value);
            }
        }
        return this.parse(values, dataType, parameters, context);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        for (Object value : ((ListProperty)property).getValues()) {
            String valueStr = this.writeValue(property, value, null);
            element.append(this.dataType(property, null), valueStr);
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        List<String> values = element.all(dataType);
        if (!values.isEmpty()) {
            return this.parse(values, dataType, parameters, context);
        }
        throw ListPropertyScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        List values = ((ListProperty)property).getValues();
        if (!values.isEmpty()) {
            return JCalValue.multi(((ListProperty)property).getValues());
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asMulti(), dataType, parameters, context);
    }

    private T parse(List<String> valueStrs, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        T property = this.newInstance(dataType, parameters);
        List values = ((ListProperty)property).getValues();
        for (String valueStr : valueStrs) {
            V value = this.readValue(property, valueStr, dataType, parameters, context);
            values.add(value);
        }
        return property;
    }

    protected abstract T newInstance(ICalDataType var1, ICalParameters var2);

    protected abstract String writeValue(T var1, V var2, WriteContext var3);

    protected abstract V readValue(T var1, String var2, ICalDataType var3, ICalParameters var4, ParseContext var5);
}

