/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oncall;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.oncall.BOnCallList;
import com.tridium.oncall.BOnCallRecipient;
import com.tridium.oncall.BOnCallService;
import com.tridium.oncall.util.OnCallToolkit;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="activateCallList", flags=20), @NiagaraAction(name="callListRemoved", parameterType="BInteger", defaultValue="BInteger.DEFAULT", flags=20), @NiagaraAction(name="matchClearAndEscalate", parameterType="BString", defaultValue="BString.DEFAULT", flags=20), @NiagaraAction(name="clearAndEscalate", parameterType="BString", defaultValue="BString.DEFAULT", flags=20)})
public final class BOnCallSchedule
extends BEnumSchedule {
    @Generated
    public static final Action activateCallList = BOnCallSchedule.newAction((int)20, null);
    @Generated
    public static final Action callListRemoved = BOnCallSchedule.newAction((int)20, (BValue)BInteger.DEFAULT, null);
    @Generated
    public static final Action matchClearAndEscalate = BOnCallSchedule.newAction((int)20, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action clearAndEscalate = BOnCallSchedule.newAction((int)20, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOnCallSchedule.class);
    private BStatusEnum lastOut = null;
    private BOnCallList currentList = null;

    @Generated
    public void activateCallList() {
        this.invoke(activateCallList, null, null);
    }

    @Generated
    public void callListRemoved(BInteger parameter) {
        this.invoke(callListRemoved, (BValue)parameter, null);
    }

    @Generated
    public void matchClearAndEscalate(BString parameter) {
        this.invoke(matchClearAndEscalate, (BValue)parameter, null);
    }

    @Generated
    public void clearAndEscalate(BString parameter) {
        this.invoke(clearAndEscalate, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOnCallSchedule() {
        this.setFlags((Slot)BEnumSchedule.facets, this.getFlags((Slot)BEnumSchedule.facets) | 4);
    }

    public void started() throws Exception {
        super.started();
        BOnCallService service = BOnCallService.getInstance();
        if (service == null) {
            throw new Exception("Could not find OnCallService");
        }
        this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
        this.activateCallList();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            if (prop == BEnumSchedule.out) {
                this.activateCallList();
            } else if (prop == BWeeklySchedule.schedule) {
                this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == activateCallList || action == callListRemoved || action == matchClearAndEscalate || action == clearAndEscalate) {
            return BOnCallService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOnCallRecipient;
    }

    public void doActivateCallList() throws Exception {
        BOnCallService service;
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Activating call list");
        }
        if ((service = BOnCallService.getInstance()) == null) {
            throw new Exception("Could not find OnCallService");
        }
        if (this.lastOut != null && !this.lastOut.isNull() && this.currentList != null && this.currentList.isMounted()) {
            if (this.lastOut.getEnum().getOrdinal() == this.getOut().getEnum().getOrdinal()) {
                this.checkEscalation(this.getOnCallRecipient());
                this.getOnCallRecipient().setOnCallList(this.currentList.getName());
                return;
            }
            this.currentList.setActive(service.isScheduleActiveElseWhere(this, this.lastOut));
            this.currentList.updateStatus();
            if (OnCallToolkit.log.isTraceOn()) {
                OnCallToolkit.log.trace("Activating call list: Old On Call List: " + this.currentList.getName() + " " + this.currentList.getStatus().toString());
            }
        }
        this.lastOut = (BStatusEnum)this.getOut().newCopy();
        if (!this.lastOut.isNull()) {
            this.currentList = service.lookupList(this.lastOut.getEnum().getOrdinal());
            if (this.currentList != null) {
                this.currentList.setActive(true);
                this.currentList.updateStatus();
                this.getOnCallRecipient().setOnCallList(this.currentList.getName());
                if (OnCallToolkit.log.isTraceOn()) {
                    OnCallToolkit.log.trace("Activating call list: New On Call List: " + this.currentList.getName() + " " + this.currentList.getStatus().toString());
                }
                this.doClearAndEscalate(BString.DEFAULT);
            } else {
                this.lastOut = null;
                this.currentList = null;
                this.getOnCallRecipient().setOnCallList("");
                this.doClearAndEscalate(BString.DEFAULT);
            }
        } else {
            this.lastOut = null;
            this.currentList = null;
            this.getOnCallRecipient().setOnCallList("");
            this.doClearAndEscalate(BString.DEFAULT);
        }
    }

    public void doCallListRemoved(BInteger ordinal) throws Exception {
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("On Call List Removed: " + this.getOnCallRecipient().getName() + ": " + ordinal);
        }
        BITable coll = (BITable)BOrd.make((String)("bql:select from schedule:AbstractSchedule where effectiveValue.value.ordinal=" + ordinal.encodeToString())).get((BObject)this);
        try (TableCursor cur = coll.cursor();){
            BComponent sch = null;
            while (cur.next()) {
                sch = (BComponent)cur.get();
                sch.getParent().asComponent().remove((BComplex)sch);
            }
        }
        BOnCallService service = BOnCallService.getInstance();
        if (service == null) {
            throw new Exception("Could not find OnCallService");
        }
        this.setFacets(BOnCallService.getInstance().getCallListEnumRangeFacets());
        this.activateCallList();
    }

    public void doMatchClearAndEscalate(BString onCallListName) throws Exception {
        if (onCallListName.getString().length() > 0 && this.currentList != null && this.currentList.isMounted() && !this.currentList.getName().equals(onCallListName.getString())) {
            return;
        }
        if (OnCallToolkit.log.isTraceOn()) {
            OnCallToolkit.log.trace("Match, clear and escalate alarm: " + onCallListName);
        }
        this.doClearAndEscalate(BString.DEFAULT);
    }

    public void doClearAndEscalate(BString extraAlarmClassName) throws Exception {
        String alarmPredicate = this.getOnCallRecipient().buildAlarmClassPredicate(extraAlarmClassName.getString());
        String alarmQuery = alarmPredicate + " and not isAcknowledged";
        BITable coll = (BITable)BOrd.make((String)alarmQuery).get((BObject)this);
        BAlarmService alarmSrv = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        Array recArray = new Array(BAlarmRecord.class);
        try (TableCursor c = coll.cursor();){
            while (c.next()) {
                recArray.add((Object)((BAlarmRecord)((BObject)c.get()).asValue().newCopy()));
            }
        }
        BConsoleRecipient[] consoleRecipients = null;
        BStationRecipient[] stationRecipients = null;
        BAlarmRecord[] records = (BAlarmRecord[])recArray.trim();
        try (AlarmDbConnection conn = alarmSrv.getAlarmDb().getDbConnection(null);){
            for (int i = 0; i < records.length; ++i) {
                int j;
                if (!this.getOnCallRecipient().accept(records[i])) continue;
                String[] keys = new String[]{"OnCallRecipient", "OnCallList", "OnCallStartTime", "OnCallUser", "OnCallContact", "OnCallListPriority"};
                BIDataValue[] values = new BIDataValue[]{BString.DEFAULT, BString.DEFAULT, BAbsTime.NULL, BString.DEFAULT, BString.DEFAULT, BInteger.make((int)-1)};
                BFacets newFacets = BFacets.make((String[])keys, (BIDataValue[])values);
                records[i].setAlarmData(BFacets.make((BFacets)records[i].getAlarmData(), (BFacets)newFacets));
                records[i].setLastUpdate(BAbsTime.now());
                conn.update(records[i]);
                if (OnCallToolkit.log.isTraceOn()) {
                    OnCallToolkit.log.trace("Clear and escalate alarm: " + records[i].getUuid().encodeToString());
                }
                if (consoleRecipients == null) {
                    consoleRecipients = this.getOnCallRecipient().getLinkedConsoleRecipients();
                }
                for (j = 0; j < consoleRecipients.length; ++j) {
                    consoleRecipients[j].routeAlarm(records[i]);
                }
                if (stationRecipients == null) {
                    stationRecipients = this.getOnCallRecipient().getLinkedStationRecipients();
                }
                for (j = 0; j < stationRecipients.length; ++j) {
                    stationRecipients[j].routeAlarm(records[i]);
                }
            }
        }
        this.checkEscalation(this.getOnCallRecipient());
    }

    void routeAlarm(BAlarmRecord record, BOnCallRecipient recipient) {
        if (this.currentList != null && this.currentList.isMounted()) {
            this.currentList.routeAlarm(record, recipient);
        }
    }

    void checkEscalation(BOnCallRecipient rec) {
        if (this.currentList != null && this.currentList.isMounted()) {
            this.currentList.checkEscalation(rec);
        }
    }

    public BOnCallRecipient getOnCallRecipient() {
        return (BOnCallRecipient)this.getParent();
    }
}

