/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanTitan;

import com.tridium.hdk8000.Hdk8000;
import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.ports.BUsbPort;
import com.tridium.platHwScan.ports.BWifiPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="Wifi", type="BWifiPort", defaultValue="new BWifiPort()", flags=1), @NiagaraProperty(name="LAN1", type="BEthernetPort", defaultValue="new BEthernetPort(\"en0\")", flags=1), @NiagaraProperty(name="LAN2", type="BEthernetPort", defaultValue="new BEthernetPort(\"en1\")", flags=1), @NiagaraProperty(name="COM1", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="COM2", type="BPort", defaultValue="new BPort(BPortTypeEnum.rs485, \"tridium:serial\", HwScanConst.COM)", flags=1), @NiagaraProperty(name="USB", type="BUsbPort", defaultValue="new BUsbPort()", flags=1), @NiagaraProperty(name="optionSlot1", type="BOptionSlot", defaultValue="new BOptionSlot(1)", flags=1), @NiagaraProperty(name="optionSlot2", type="BOptionSlot", defaultValue="new BOptionSlot(2)", flags=1), @NiagaraProperty(name="optionSlot3", type="BOptionSlot", defaultValue="new BOptionSlot(3)", flags=1), @NiagaraProperty(name="optionSlot4", type="BOptionSlot", defaultValue="new BOptionSlot(4)", flags=1)})
public class BTitanBoard
extends BBaseBoard {
    @Generated
    public static final Property Wifi = BTitanBoard.newProperty((int)1, (BValue)new BWifiPort(), null);
    @Generated
    public static final Property LAN1 = BTitanBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    @Generated
    public static final Property LAN2 = BTitanBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    @Generated
    public static final Property COM1 = BTitanBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property COM2 = BTitanBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    @Generated
    public static final Property USB = BTitanBoard.newProperty((int)1, (BValue)new BUsbPort(), null);
    @Generated
    public static final Property optionSlot1 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    @Generated
    public static final Property optionSlot2 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(2), null);
    @Generated
    public static final Property optionSlot3 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(3), null);
    @Generated
    public static final Property optionSlot4 = BTitanBoard.newProperty((int)1, (BValue)new BOptionSlot(4), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTitanBoard.class);
    private static final Lexicon LEX = Lexicon.make(BTitanBoard.class);
    private static final String BASE_BOARD_CODE = "TITAN";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 3;
    public static final int HARDWARE_REF_COUNT = 13;

    @Generated
    public BWifiPort getWifi() {
        return (BWifiPort)this.get(Wifi);
    }

    @Generated
    public void setWifi(BWifiPort v) {
        this.set(Wifi, (BValue)v, null);
    }

    @Generated
    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    @Generated
    public void setLAN1(BEthernetPort v) {
        this.set(LAN1, (BValue)v, null);
    }

    @Generated
    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    @Generated
    public void setLAN2(BEthernetPort v) {
        this.set(LAN2, (BValue)v, null);
    }

    @Generated
    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    @Generated
    public void setCOM1(BPort v) {
        this.set(COM1, (BValue)v, null);
    }

    @Generated
    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    @Generated
    public void setCOM2(BPort v) {
        this.set(COM2, (BValue)v, null);
    }

    @Generated
    public BUsbPort getUSB() {
        return (BUsbPort)this.get(USB);
    }

    @Generated
    public void setUSB(BUsbPort v) {
        this.set(USB, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    @Generated
    public void setOptionSlot1(BOptionSlot v) {
        this.set(optionSlot1, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot2() {
        return (BOptionSlot)this.get(optionSlot2);
    }

    @Generated
    public void setOptionSlot2(BOptionSlot v) {
        this.set(optionSlot2, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot3() {
        return (BOptionSlot)this.get(optionSlot3);
    }

    @Generated
    public void setOptionSlot3(BOptionSlot v) {
        this.set(optionSlot3, (BValue)v, null);
    }

    @Generated
    public BOptionSlot getOptionSlot4() {
        return (BOptionSlot)this.get(optionSlot4);
    }

    @Generated
    public void setOptionSlot4(BOptionSlot v) {
        this.set(optionSlot4, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        BComplex parent = this.getParent();
        if (parent instanceof BHardwareScanService) {
            BHardwareScanService scanService = (BHardwareScanService)parent;
            Action scan = scanService.getAction("scan");
            String flags = Flags.encodeToString((int)scanService.getFlags((Slot)scan));
            flags = flags.replace("h", "");
            scanService.setFlags((Slot)scan, Flags.decodeFromString((String)flags));
        }
        super.started();
    }

    public void autoConfig(Array<String> optionCardCodes, boolean simulation) {
        this.setSimulation(simulation);
        this.setProductModel(LEX.getText(Nre.getHostModel().toUpperCase(Locale.ENGLISH)));
        this.initializeStandardPorts();
        this.nextSerialPort = 3;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        for (int i = 1; i <= 4; ++i) {
            BOptionSlot slot = (BOptionSlot)this.get("optionSlot" + i);
            if (optionCardCodes.size() >= i * 2 - 1) {
                this.configureOptionSlot(slot, (String)optionCardCodes.get(i * 2 - 2), (String)optionCardCodes.get(i * 2 - 1));
                continue;
            }
            this.configureOptionSlot(slot, "FF", "FF");
        }
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        Vector<BHardwareRef> v = new Vector<BHardwareRef>();
        block11: for (int i = 1; i <= 13; ++i) {
            switch (i) {
                case 1: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.electricalGround")));
                    continue block11;
                }
                case 2: 
                case 3: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.powerConnector")));
                    continue block11;
                }
                case 4: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM1()));
                    continue block11;
                }
                case 5: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM2()));
                    continue block11;
                }
                case 6: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getUSB()));
                    continue block11;
                }
                case 7: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), LEX.getText("HardwareRef.wifi"), this.getWifi().getPortType(), this.getWifi().getStatus()));
                    continue block11;
                }
                case 8: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN2()));
                    continue block11;
                }
                case 9: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN1()));
                    continue block11;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    BOptionSlot slot = (BOptionSlot)this.get("optionSlot" + (i - 9));
                    v.addElement(this.makeSlotRef(i, slot));
                    if (slot.isEmpty()) continue block11;
                    BOptionCard optionCard = (BOptionCard)slot.getContents();
                    optionCard.lease(1);
                    BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                    for (int j = 0; j < cardPorts.length; ++j) {
                        v.addElement(this.makePortRef(i, j + 1, cardPorts[j]));
                    }
                    continue block11;
                }
            }
        }
        return v;
    }

    public String getImagesDirectory() {
        return LEX.getText(IMAGES_DIR);
    }

    public String getView(BObject v) {
        return LEX.getText(VIEW);
    }

    private void configureOptionSlot(BOptionSlot slot, String functionCode1, String functionCode2) {
        boolean configError;
        slot.removeAll();
        boolean bl = configError = functionCode1.equals("XX") && functionCode2.equals("XX");
        if (!functionCode1.equalsIgnoreCase("FF") || !functionCode2.equalsIgnoreCase("FF")) {
            BOptionCard cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2));
            if (cardTemplate == null) {
                Hdk8000 allowedList = new Hdk8000();
                String moduleDescriptionStr = allowedList.getProductString("0x" + functionCode1, "0x" + functionCode2);
                BPort port = new BPort();
                if (configError || moduleDescriptionStr.equals("Unknown")) {
                    cardTemplate = new BOptionCard("Invalid Configuration", functionCode1 + " " + functionCode2);
                    cardTemplate.setConnectors(0);
                    cardTemplate.setPortCount(0);
                    cardTemplate.setSideViewImage("INVALID_TTN.png");
                    cardTemplate.setUsesCom(false);
                    cardTemplate.setUnknownCardType(false);
                    cardTemplate.setOptionCodes("00 00");
                    port.setPortType(BPortTypeEnum.unknown);
                    port.setHasConnector(false);
                    port.setPrefix("COM");
                    port.setStatus(BHwScanStatusEnum.none);
                    port.add("portIndex", (BValue)BInteger.make((int)1), 5);
                    cardTemplate.add("Port1", (BValue)port);
                } else {
                    cardTemplate = new BOptionCard(moduleDescriptionStr, functionCode1 + " " + functionCode2);
                    cardTemplate.setConnectors(1);
                    cardTemplate.setPortCount(1);
                    cardTemplate.setSideViewImage("GENERIC_TTN.png");
                    cardTemplate.setUsesCom(true);
                    cardTemplate.setUnknownCardType(false);
                    port.setPortType(BPortTypeEnum.noPort);
                    port.setHasConnector(true);
                    port.setRequiredFeatures("tridium:serial");
                    port.setPrefix("COM");
                    port.setStatus(BHwScanStatusEnum.available);
                    port.checkLicense();
                    port.add("portIndex", (BValue)BInteger.make((int)1), 5);
                    cardTemplate.add("Port1", (BValue)port);
                }
            }
            BOptionCard optionCard = (BOptionCard)cardTemplate.newCopy(true);
            slot.addCard(optionCard);
            BPort[] ports = optionCard.getPorts();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i] == null) continue;
                BPort port = ports[i];
                optionCard.rename(optionCard.getProperty(port.getName()), this.makePortName(i + 1, port.getPrefix()), null);
                if (this.simulation || configError) continue;
                port.initOwnerAndStatus();
            }
        }
        if (slot.isEmpty()) {
            slot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    private void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase(Locale.ENGLISH) + "1")), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase(Locale.ENGLISH) + "2")), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase(Locale.ENGLISH) + "1")), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase(Locale.ENGLISH) + "2")), null);
        this.setDisplayName(Wifi, BFormat.make((String)"Wi-Fi".toUpperCase(Locale.ENGLISH)), null);
        this.setDisplayName(USB, BFormat.make((String)"USB".toUpperCase(Locale.ENGLISH)), null);
        if (!this.simulation) {
            try {
                this.getCOM1().initOwnerAndStatus();
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, "Cannot initialize COM1", exception);
            }
            try {
                this.getCOM2().initOwnerAndStatus();
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, "Cannot initialize COM2", exception);
            }
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
            this.getWifi().initStatus();
            this.getUSB().initStatus();
        }
    }
}

