/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.report.ui;

import com.lynxspring.report.ui.BRootGridEditor;
import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.editor.BGridEditorPane;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BRootGridEditorPane
extends BTransferWidget {
    public static final Type TYPE = Sys.loadType(BRootGridEditorPane.class);
    static final BModule module = Sys.getModuleForClass(BGridEditorPane.class);
    static final Lexicon lex = Lexicon.make((String)"report");
    static final BFont font = Theme.widget().getTextFont();
    static final BFont bold = Theme.widget().getBoldText();
    static final BImage warningIcon = BImage.make((String)"module://icons/x16/warning.png");
    static final BImage stopIcon = BImage.make((String)"module://icons/x16/stop.png");
    String defName = lex.getText("compGridEditor.defaultColumnName");
    BFormat defFormat = BFormat.make((String)"%.%");
    BOrd defOrd = BOrd.make((String)"slot:");
    double colWidth;
    double headerHeight;
    double templateHeight;
    int selectedCol = -1;
    int selectedRow = -3;
    boolean mouseDown = false;
    int dragZone = -1;
    int dragCol = -1;
    int dragColOrig = -1;
    BRootGridEditor.Model model;
    Command delete;

    public Type getType() {
        return TYPE;
    }

    public int getColumnAt(double d) {
        int i = this.model.getColumnCount();
        if (i == 0) {
            return -1;
        }
        if (d < 0.0) {
            return 0;
        }
        int j = (int)(d / this.colWidth);
        if (j >= i) {
            j = i - 1;
        }
        return j;
    }

    public boolean isColumnRow(double d) {
        return d < this.headerHeight;
    }

    public boolean isTemplateRow(double d) {
        return d >= this.headerHeight && d < this.headerHeight + this.templateHeight;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void doLayout(BWidget[] abwidget) {
        double d = this.getWidth();
        int i = this.model.getColumnCount();
        this.colWidth = i == 0 ? 0.0 : (double)((int)(d / (double)this.model.getColumnCount()));
        this.headerHeight = bold.getHeight() + font.getHeight() * 2.0 + 10.0;
        this.templateHeight = font.getHeight() + 20.0;
    }

    public void paint(Graphics g) {
        double d = this.getWidth();
        double d1 = this.getHeight();
        int i = this.model.getColumnCount();
        if (i == 0) {
            this.paintNoColumns(g);
        }
        for (int k = 0; k < i; ++k) {
            g.push();
            double d3 = this.colWidth;
            if (k == i - 1) {
                d3 += d - (double)i * this.colWidth;
            }
            g.translate((double)k * this.colWidth, 0.0);
            g.clip(0.0, 0.0, d3, this.headerHeight);
            this.paintColumn(g, k, d3);
            g.pop();
        }
        g.push();
        g.translate(0.0, this.headerHeight);
        g.clip(0.0, 0.0, d, this.templateHeight);
        this.paintTemplate(g);
        g.pop();
        g.setBrush(Theme.widget().getWindowBackground());
        g.fillRect(0.0, this.headerHeight + this.templateHeight, d, 0.0);
        this.paintNoRows(g);
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, d - 1.0, d1 - 1.0);
        if (this.dragZone != -1) {
            g.setBrush(Theme.widget().getDropOkBackground());
            double d2 = 0.0;
            double d5 = 0.0;
            if (this.dragZone == 0) {
                d2 = 0.0;
                d5 = this.headerHeight;
            } else if (this.dragZone == 1) {
                d2 = this.headerHeight - 1.0;
                d5 = this.templateHeight + 1.0;
            }
            g.strokeRect(1.0, d2 + 1.0, d - 3.0, d5 - 3.0);
            g.strokeRect(2.0, d2 + 2.0, d - 5.0, d5 - 5.0);
            g.strokeRect(3.0, d2 + 3.0, d - 7.0, d5 - 7.0);
        }
    }

    private final void paintNoColumns(Graphics g) {
        double d = this.getWidth();
        double d1 = this.headerHeight;
        String s = lex.getText("compGridEditor.noColumns");
        double d2 = Math.max(16.0, bold.getHeight());
        double d3 = (d - bold.width(s) - 20.0) / 2.0;
        double d4 = (d1 - d2) / 2.0 + bold.getAscent();
        double d5 = d3 - 20.0;
        double d6 = (d1 - d2) / 2.0;
        g.setBrush(Theme.widget().getControlAuxiliary());
        g.fillRect(0.0, 0.0, d, d1);
        g.setBrush(BColor.black);
        g.setFont(bold);
        g.drawImage(warningIcon, d5, d6);
        g.drawString(s, d3, d4);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, d1 - 1.0, d, d1 - 1.0);
    }

    private final void paintNoRows(Graphics g) {
        double d = this.getWidth();
        double d1 = this.headerHeight + this.templateHeight;
        double d2 = this.getHeight() - d1;
        String s = Lexicon.make(BRootGridEditorPane.class).getText("rootGridEditor.noRows");
        double d3 = Math.max(16.0, bold.getHeight());
        double d4 = (d - bold.width(s) - 20.0) / 2.0;
        double d5 = (d2 - d3) / 2.0 + bold.getAscent();
        double d6 = d4 - 20.0;
        double d7 = (d2 - d3) / 2.0;
        g.setBrush(Theme.widget().getControlBackground());
        g.fillRect(0.0, d1, d, d2);
        g.setBrush(BColor.black);
        g.setFont(bold);
        g.drawImage(stopIcon, d6, d7);
        g.drawString(s, d4, d5);
    }

    private final void paintColumn(Graphics g, int i, double d) {
        double d2 = this.headerHeight;
        boolean flag = i == this.selectedCol;
        boolean flag1 = i == this.dragCol;
        BBrush bbrush = Theme.widget().getControlAuxiliary();
        if (flag) {
            bbrush = Theme.widget().getSelectionBackground();
        }
        if (flag1) {
            bbrush = Theme.widget().getDropOkBackground();
        }
        BBrush bbrush1 = BColor.black.toBrush();
        if (flag) {
            bbrush1 = Theme.widget().getSelectionForeground();
        }
        if (flag1) {
            bbrush1 = Theme.widget().getDropOkForeground();
        }
        g.setBrush(bbrush);
        g.fillRect(0.0, 0.0, d, d2);
        BCompGridColumn bcompgridcolumn = this.model.getColumn(i);
        String s = bcompgridcolumn.getDisplayName();
        String s1 = bcompgridcolumn.getFormat().getFormat();
        String s2 = bcompgridcolumn.getOrd().toString();
        double d3 = (d - bold.width(s)) / 2.0;
        double d4 = bold.getAscent() + 5.0;
        g.setBrush(bbrush1);
        g.setFont(bold);
        g.drawString(s, d3, d4);
        d3 = (d - font.width(s2)) / 2.0;
        g.setFont(font);
        g.drawString(s2, d3, d4 += font.getHeight());
        d3 = (d - font.width(s1)) / 2.0;
        g.setFont(font);
        g.drawString(s1, d3, d4 += font.getHeight());
        g.setBrush(BColor.black);
        g.strokeLine(0.0, d2 - 1.0, d - 1.0, d2 - 1.0);
        g.strokeLine(d - 1.0, 0.0, d - 1.0, d2);
    }

    private final void paintTemplate(Graphics g) {
        double d = this.getWidth();
        double d1 = this.templateHeight;
        if (this.model.getTemplate() == null) {
            String s = lex.getText("compGridEditor.noTemplate");
            double d2 = Math.max(16.0, bold.getHeight());
            double d4 = (d - bold.width(s) - 20.0) / 2.0;
            double d6 = (d1 - d2) / 2.0 + bold.getAscent();
            double d7 = d4 - 20.0;
            double d8 = (d1 - d2) / 2.0;
            g.setBrush(BBrush.make((String)"#ffffc0"));
            g.fillRect(0.0, 0.0, d, d1);
            g.setBrush(BColor.black);
            g.setFont(bold);
            g.drawImage(warningIcon, d7, d8);
            g.drawString(s, d4, d6);
        } else {
            boolean flag;
            boolean bl = flag = this.selectedRow == -2;
            if (flag) {
                g.setBrush(Theme.widget().getSelectionBackground());
                g.fillRect(0.0, 0.0, d, d1);
            }
            String s1 = SlotPath.unescape((String)("station:|" + this.model.getTemplate().getSlotPath().toString()));
            double d3 = 5.0;
            double d5 = 10.0 + font.getAscent();
            if (flag) {
                g.setBrush(Theme.widget().getSelectionForeground());
            } else {
                g.setBrush(BColor.black);
            }
            g.setFont(font);
            g.drawString(s1, d3, d5);
        }
        g.setBrush(BColor.black);
        g.strokeLine(0.0, d1 - 1.0, d, d1 - 1.0);
    }

    public void doVscroll(BScrollEvent bscrollevent) {
        this.repaint();
    }

    public void keyReleased(BKeyEvent bkeyevent) {
        if (bkeyevent.getKeyCode() == 27) {
            if (this.dragCol != -1 && this.dragCol != this.dragColOrig) {
                this.model.moveColumn(this.dragCol, this.dragColOrig);
                this.selectColumn(this.dragColOrig);
                this.setMouseCursor(MouseCursor.normal);
                this.dragCol = -1;
                this.mouseDown = false;
                this.repaint();
            }
        } else {
            super.keyReleased(bkeyevent);
        }
    }

    public void mousePressed(BMouseEvent bmouseevent) {
        this.requestFocus();
        this.mouseDown = true;
        double d = bmouseevent.getX();
        double d1 = bmouseevent.getY();
        int i = this.getColumnAt(d);
        if (!this.isColumnRow(d1)) {
            i = -1;
        }
        this.selectColumn(i);
        this.repaint();
    }

    public void mouseReleased(BMouseEvent bmouseevent) {
        this.setMouseCursor(MouseCursor.normal);
        if (!this.mouseDown) {
            return;
        }
        double d2 = bmouseevent.getX();
        double d3 = bmouseevent.getY();
        if (this.dragCol != -1) {
            this.dragCol = -1;
            this.repaint();
            return;
        }
        boolean flag = bmouseevent.getClickCount() == 2;
        boolean flag1 = bmouseevent.isPopupTrigger();
        int i = this.getColumnAt(d2);
        if (flag1) {
            if (this.isColumnRow(d3)) {
                this.makeColumnPopup(i).open((BWidget)this, d2, d3);
            }
        } else if (flag) {
            if (this.isColumnRow(d3)) {
                if (i != -1) {
                    this.editColumn(i);
                }
            } else if (this.isTemplateRow(d3)) {
                this.editTemplate();
            }
        }
    }

    public void mouseDragged(BMouseEvent bmouseevent) {
        if (!this.mouseDown) {
            return;
        }
        double d = bmouseevent.getX();
        double d1 = bmouseevent.getY();
        if (!this.isColumnRow(d1)) {
            return;
        }
        int i = this.getColumnAt(d);
        if (this.dragCol == -1) {
            this.dragCol = i;
            this.dragColOrig = i;
            this.repaint();
            this.setMouseCursor(MouseCursor.move);
        } else if (this.dragCol != i) {
            this.model.moveColumn(this.dragCol, i);
            this.dragCol = i;
            this.selectColumn(this.dragCol);
        }
    }

    public BMenu makeColumnPopup(int i) {
        BMenu bmenu = new BMenu();
        bmenu.add(null, (Command)new AddColumn((BWidget)this, this, i));
        bmenu.add(null, this.delete);
        return bmenu;
    }

    public void editColumn(int i) {
        BCompGridColumn bcompgridcolumn = this.model.getColumn(i);
        if ((bcompgridcolumn = this.editColumn(bcompgridcolumn)) != null) {
            this.model.setColumn(i, bcompgridcolumn);
        }
    }

    public BCompGridColumn editColumn(BCompGridColumn bcompgridcolumn) {
        try {
            BTextField btextfield = new BTextField(bcompgridcolumn.getDisplayName(), 40);
            BWbFieldEditor bwbfieldeditor = BWbFieldEditor.makeFor((BObject)bcompgridcolumn.getFormat());
            BWbFieldEditor bwbfieldeditor1 = BWbFieldEditor.makeFor((BObject)bcompgridcolumn.getOrd());
            bwbfieldeditor.loadValue((BObject)bcompgridcolumn.getFormat(), this.model.cx);
            bwbfieldeditor1.loadValue((BObject)bcompgridcolumn.getOrd(), this.model.cx);
            BGridPane bgridpane = new BGridPane(2);
            bgridpane.add(null, (BValue)new BLabel(BRootGridEditorPane.lex("name")));
            bgridpane.add(null, (BValue)btextfield);
            bgridpane.add(null, (BValue)new BLabel(BRootGridEditorPane.lex("format")));
            bgridpane.add(null, (BValue)bwbfieldeditor);
            bgridpane.add(null, (BValue)new BLabel(BRootGridEditorPane.lex("ord")));
            bgridpane.add(null, (BValue)bwbfieldeditor1);
            BBorderPane bborderpane = new BBorderPane((BWidget)bgridpane);
            if (BDialog.open((BWidget)this, (String)BRootGridEditorPane.lex("editColumn"), (Object)bborderpane, (int)3) != 1) {
                return null;
            }
            String s = btextfield.getText();
            BFormat bformat = (BFormat)bwbfieldeditor.saveValue();
            BOrd bord = (BOrd)bwbfieldeditor1.saveValue();
            bcompgridcolumn.setDisplayName(s);
            bcompgridcolumn.setFormat(bformat);
            bcompgridcolumn.setOrd(bord);
            return bcompgridcolumn;
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (Object)e);
            return null;
        }
    }

    public void editTemplate() {
        BComponent bcomponent = this.model.getTemplate();
        BOrd bord = bcomponent != null ? bcomponent.getNavOrd().relativizeToSession() : BOrd.NULL;
        BWbFieldEditor bwbfieldeditor = BWbFieldEditor.makeFor((BObject)bord);
        bwbfieldeditor.loadValue((BObject)bord, this.model.cx);
        BGridPane bgridpane = new BGridPane(2);
        bgridpane.add(null, (BValue)new BLabel(BRootGridEditorPane.lex("ord")));
        bgridpane.add(null, (BValue)bwbfieldeditor);
        BBorderPane bborderpane = new BBorderPane((BWidget)bgridpane);
        if (1 == BDialog.open((BWidget)this, (String)BRootGridEditorPane.lex("editTemplate"), (Object)bborderpane, (int)3)) {
            try {
                BOrd bord1 = (BOrd)bwbfieldeditor.saveValue();
                BComponent bcomponent1 = bord1.resolve(this.model.base).get().asComponent();
                this.model.setTemplate(bcomponent1);
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (Object)exception);
            }
        }
    }

    private final void selectColumn(int i) {
        this.selectedCol = i;
        this.selectedRow = -1;
        this.delete.setEnabled(this.selectedCol != -1);
    }

    private final BCompGridColumn makeNewColumn() {
        BCompGridColumn bcompgridcolumn = new BCompGridColumn();
        bcompgridcolumn.setDisplayName(this.defName);
        bcompgridcolumn.setFormat(this.defFormat);
        bcompgridcolumn.setOrd(this.defOrd);
        return bcompgridcolumn;
    }

    public TransferEnvelope getTransferData() throws Exception {
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transfercontext) throws Exception {
        return null;
    }

    public CommandArtifact removeTransferData(TransferContext transfercontext) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        return null;
    }

    public CommandArtifact doRename() throws Exception {
        return null;
    }

    public int dragOver(TransferContext transfercontext) {
        Mark mark = (Mark)transfercontext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return 0;
        }
        double d = transfercontext.getY();
        if (this.isColumnRow(d)) {
            this.dragZone = 0;
        } else if (this.isTemplateRow(d)) {
            this.dragZone = 1;
        } else {
            return 0;
        }
        if (this.model.getTemplate() == null && this.dragZone != 1) {
            this.dragZone = -1;
            this.repaint();
            return 0;
        }
        this.repaint();
        return 16;
    }

    public void dragExit(TransferContext transfercontext) {
        this.dragZone = -1;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transfercontext) throws Exception {
        int i = this.dragZone;
        this.dragZone = -1;
        this.repaint();
        if (i == 0) {
            return this.insertColumns(transfercontext);
        }
        if (i == 1) {
            return this.insertTemplate(transfercontext);
        }
        return null;
    }

    private final CommandArtifact insertColumns(TransferContext transfercontext) throws Exception {
        BComponent bcomponent = this.model.getTemplate();
        if (bcomponent == null) {
            return null;
        }
        Mark mark = (Mark)transfercontext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        BCompGridColumn[] abcompgridcolumn = new BCompGridColumn[mark.size()];
        for (int i = 0; i < mark.size(); ++i) {
            BComponent bcomponent1 = mark.getValue(i).asComponent();
            String s = bcomponent1.getNavOrd().relativizeToSession().toString();
            String s1 = bcomponent.getNavOrd().relativizeToSession().toString();
            if (s.length() < s1.length() || !s.startsWith(s1)) {
                throw new LocalizableException("report", "compGridEditor.notUnderTemplate");
            }
            if (s.equals(s1)) {
                abcompgridcolumn[i] = new BCompGridColumn();
                abcompgridcolumn[i].setDisplayName(lex.getText("compGridEditor.name"));
                abcompgridcolumn[i].setFormat(BFormat.make((String)"%displayName%"));
                abcompgridcolumn[i].setOrd(BOrd.make((String)"slot:"));
                continue;
            }
            abcompgridcolumn[i] = new BCompGridColumn();
            abcompgridcolumn[i].setDisplayName(bcomponent1.getDisplayName(this.model.cx));
            abcompgridcolumn[i].setFormat(this.defFormat);
            abcompgridcolumn[i].setOrd(BOrd.make((String)("slot:" + s.substring(s1.length() + 1))));
        }
        this.selectColumn(this.model.getColumnCount() + (abcompgridcolumn.length - 1));
        this.model.addColumns(abcompgridcolumn);
        return null;
    }

    private final CommandArtifact insertTemplate(TransferContext transfercontext) {
        Mark mark = (Mark)transfercontext.getEnvelope().getData(TransferFormat.mark);
        if (!TransferUtil.isComponent((Mark)mark)) {
            return null;
        }
        this.model.setTemplate(mark.getValue(0).asComponent());
        return null;
    }

    static String lex(String s) {
        return lex.getText("compGridEditor." + s);
    }

    public BRootGridEditorPane(BRootGridEditor.Model model1) {
        this.model = model1;
        this.delete = new Delete((BWidget)this);
        this.delete.setEnabled(false);
    }

    class Delete
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            if (BRootGridEditorPane.this.selectedCol != -1) {
                int sel = BRootGridEditorPane.this.selectedCol;
                if (sel == BRootGridEditorPane.this.model.getColumnCount() - 1) {
                    BRootGridEditorPane.this.selectColumn(sel - 1);
                }
                BRootGridEditorPane.this.model.removeColumn(sel);
            }
            return null;
        }

        public Delete(BWidget bwidget) {
            super(bwidget, module, "compGridEditor.commands.delete");
        }
    }

    static class AddColumn
    extends Command {
        BRootGridEditorPane editor;
        int col;

        public CommandArtifact doInvoke() throws Exception {
            BCompGridColumn gcol = this.editor.makeNewColumn();
            if ((gcol = this.editor.editColumn(gcol)) == null) {
                return null;
            }
            if (this.col < 0) {
                this.editor.selectColumn(this.editor.model.getColumnCount());
                this.editor.model.addColumn(gcol);
            } else {
                this.editor.selectColumn(this.editor.selectedCol + 1);
                this.editor.model.addColumn(this.col, gcol);
            }
            return null;
        }

        public AddColumn(BWidget bwidget, BRootGridEditorPane pane, int i) {
            super(bwidget, module, "compGridEditor.commands.addColumn");
            this.editor = pane;
            this.col = i;
        }
    }
}

