/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.report.ui;

import com.lynxspring.report.BRootComponentGrid;
import com.lynxspring.report.ui.BRootGridEditorPane;
import com.tridium.report.grid.BCompGridColumn;
import com.tridium.report.grid.BComponentGrid;
import java.util.ArrayList;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.toolbar.BIToolBar;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BRootGridEditor
extends BWbView {
    public static final Type TYPE = Sys.loadType(BRootGridEditor.class);
    static Lexicon lex = Lexicon.make((String)"report");
    Model model;
    BRootGridEditorPane editor;

    public Type getType() {
        return TYPE;
    }

    public BIMenu[] getViewMenus() {
        BMenu bmenu = new BMenu(lex.getText("ComponentGridEditor.displayName"));
        bmenu.add(null, (Command)new BRootGridEditorPane.AddColumn((BWidget)this, this.editor, -1));
        bmenu.add(null, this.editor.delete);
        return new BMenu[]{bmenu};
    }

    public BIToolBar getViewToolBar() {
        BToolBar btoolbar = new BToolBar();
        btoolbar.add(null, (Command)new BRootGridEditorPane.AddColumn((BWidget)this, this.editor, -1));
        btoolbar.add(null, this.editor.delete);
        return btoolbar;
    }

    protected void doLoadValue(BObject bobject, Context context) {
        this.model = new Model();
        this.model.base = bobject;
        this.model.cx = context;
        this.editor = new BRootGridEditorPane(this.model);
        BComponentGrid bcomponentgrid = (BComponentGrid)bobject;
        BOrd bord = bcomponentgrid.getTemplate();
        if (!bord.isNull()) {
            try {
                this.model.setTemplate(bord.resolve(this.model.base).get().asComponent());
                BCompGridColumn[] abcompgridcolumn = bcomponentgrid.getColumns();
                for (int i = 0; i < abcompgridcolumn.length; ++i) {
                    this.model.addColumn((BCompGridColumn)abcompgridcolumn[i].newCopy());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setContent((BWidget)new BBorderPane((BWidget)this.editor, BBorder.inset, BInsets.DEFAULT));
        this.setTransferWidget(this.editor);
    }

    protected BObject doSaveValue(BObject obj, Context cx) throws Exception {
        BRootComponentGrid grid = (BRootComponentGrid)obj;
        Context cx1 = Transaction.start((BComponent)grid, (Context)cx);
        BComponent comp = this.model.getTemplate();
        grid.setTemplate(comp != null ? comp.getNavOrd().relativizeToSession() : BOrd.NULL);
        if (grid.getRootOrd().isNull()) {
            grid.setRootOrd(grid.getTemplate().getParent());
            grid.setChildTypes(this.model.getTemplate().getType().getTypeSpec());
        }
        BCompGridColumn[] col = grid.getColumns();
        for (int i = 0; i < col.length; ++i) {
            grid.remove(col[i].getPropertyInParent(), cx1);
        }
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            grid.add(null, (BValue)this.model.getColumn(k), cx1);
        }
        Transaction.end((BComponent)grid, (Context)cx1);
        return grid;
    }

    class Model {
        private BComponent template = null;
        private ArrayList cols = new ArrayList();
        BObject base;
        Context cx;

        public int getColumnCount() {
            return this.cols.size();
        }

        public BCompGridColumn getColumn(int i) {
            return (BCompGridColumn)this.cols.get(i);
        }

        public void addColumn(BCompGridColumn bcompgridcolumn) {
            this.cols.add(bcompgridcolumn);
            this.update();
        }

        public void addColumns(BCompGridColumn[] abcompgridcolumn) {
            for (int i = 0; i < abcompgridcolumn.length; ++i) {
                this.cols.add(abcompgridcolumn[i]);
            }
            this.update();
        }

        public void addColumn(int i, BCompGridColumn bcompgridcolumn) {
            if (i > this.cols.size() - 1) {
                this.addColumn(bcompgridcolumn);
            } else {
                this.cols.add(i + 1, bcompgridcolumn);
                this.update();
            }
        }

        public void setColumn(int i, BCompGridColumn bcompgridcolumn) {
            this.cols.set(i, bcompgridcolumn);
            this.update();
        }

        public void moveColumn(int i, int j) {
            Object obj = this.cols.remove(i);
            if (j >= this.cols.size()) {
                this.cols.add(obj);
            } else {
                this.cols.add(j, obj);
            }
            this.update();
        }

        public void removeColumn(int i) {
            if (this.cols.size() > 0) {
                this.cols.remove(i);
                this.update();
            }
        }

        public BComponent getTemplate() {
            return this.template;
        }

        public void setTemplate(BComponent bcomponent) {
            this.template = bcomponent;
            this.update();
        }

        public void update() {
            BRootGridEditor.this.editor.relayout();
            BRootGridEditor.this.setModified();
        }

        Model() {
        }
    }
}

