/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.report.ui;

import com.lynxspring.report.BBqlGridWithDepth;
import com.tridium.report.grid.ui.BGridTable;
import com.tridium.report.grid.ui.GridUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.report.grid.BGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class BLynxGridTable
extends BGridTable {
    public static final Type TYPE = Sys.loadType(BLynxGridTable.class);
    GridModel gridModel;
    BGrid grid;
    private BGridTable.Model model;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject obj, Context context) {
        this.grid = (BGrid)obj;
        this.registerForComponentEvents((BComponent)this.grid);
        this.loadTable();
    }

    private void loadTable() {
        if (this.grid == null) {
            return;
        }
        this.gridModel = this.grid.resolve((BObject)this.grid, null);
        if (this.gridModel.getRowCount() == 0 || this.gridModel.getColumnCount() == 0) {
            String s = this.grid.get("emptyMessage").toString();
            BBorderPane bborderpane = new BBorderPane((BWidget)new BLabel(s), BBorder.solid);
            bborderpane.setFill(Theme.widget().getWindowBackground());
            this.setContent((BWidget)new BBorderPane((BWidget)bborderpane, BBorder.inset, BInsets.DEFAULT));
        } else {
            this.model = new BGridTable.Model((BGridTable)this, this.gridModel, null);
            BTable btable = new BTable((TableModel)this.model);
            btable.setController((TableController)new GridController());
            this.setContent((BWidget)new BBorderPane((BWidget)btable, BBorder.inset, BInsets.DEFAULT));
            BComponent[] abcomponent = this.gridModel.getComponents();
            if (abcomponent.length > 0) {
                this.registerForComponentEvents(abcomponent, 0);
            }
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (event.getSourceComponent() == this.grid && event.getSlotName().equals("updated")) {
            this.loadTable();
        }
        super.handleComponentEvent(event);
    }

    class GridController
    extends TableController {
        GridController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int col) {
            BOrd bord = BLynxGridTable.this.getHyperlink();
            if (bord.isNull()) {
                return;
            }
            BWbShell shell = BLynxGridTable.this.getWbShell();
            if (shell == null) {
                return;
            }
            BObject obj = BLynxGridTable.this.gridModel.getObjectAt(row, 0);
            if (!obj.isComponent()) {
                return;
            }
            BComponent comp = obj.asComponent();
            if (BLynxGridTable.this.grid instanceof BBqlGridWithDepth) {
                for (int i = 0; i < ((BBqlGridWithDepth)BLynxGridTable.this.grid).getLinkLevel(); ++i) {
                    comp = comp != null ? (comp.getParent() != null ? comp.getParent().asComponent() : null) : null;
                }
            }
            if (comp != null) {
                shell.hyperlink(BOrd.make((String)("station:|" + comp.getSlotPath())));
            }
        }

        protected void cellMoved(BMouseEvent event, int row, int col) {
            BWbShell shell = BLynxGridTable.this.getWbShell();
            if (shell != null) {
                shell.showStatus(GridUtil.getSummary((GridModel)BLynxGridTable.this.gridModel, (int)row, (int)col, (BOrd)BLynxGridTable.this.getHyperlink(), (boolean)false, (Context)BLynxGridTable.this.getCurrentContext()));
            }
        }

        protected void cellExited(BMouseEvent event, int row, int col) {
            BWbShell shell = BLynxGridTable.this.getWbShell();
            if (shell != null) {
                shell.showStatus("");
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int col) {
            BObject obj = BLynxGridTable.this.gridModel.getObjectAt(row, col);
            if (!(obj instanceof BComponent)) {
                return;
            }
            BMenu menu = NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)obj.asComponent());
            if (menu.isEnabled()) {
                menu.open((BWidget)this.getTable(), event.getX(), event.getY());
            }
        }
    }
}

