/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.point;

import com.tridium.rdb.BResultSetTable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.Column;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.point.BRdbmsPointFolder;
import javax.baja.rdb.point.BRdbmsProxyExt;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.nullStatus", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="updateFrequency", type="BRelTime", defaultValue="BRelTime.HOUR", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0))")}), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="sql", type="BFormat", defaultValue="BFormat.make(\"\")", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE)")}), @NiagaraProperty(name="keyColumn1", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"rdb:RdbmsColumnNamePickerFE\")")}), @NiagaraProperty(name="keyColumn2", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"rdb:RdbmsColumnNamePickerFE\")")})})
@NiagaraAction(name="execute", flags=16)
public class BRdbmsPointQuery
extends BRdbmsPointFolder {
    @Generated
    public static final Property status = BRdbmsPointQuery.newProperty((int)3, (BValue)BStatus.nullStatus, null);
    @Generated
    public static final Property faultCause = BRdbmsPointQuery.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property enabled = BRdbmsPointQuery.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property updateFrequency = BRdbmsPointQuery.newProperty((int)0, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    @Generated
    public static final Property lastUpdate = BRdbmsPointQuery.newProperty((int)3, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property sql = BRdbmsPointQuery.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property keyColumn1 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    @Generated
    public static final Property keyColumn2 = BRdbmsPointQuery.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"rdb:RdbmsColumnNamePickerFE"));
    @Generated
    public static final Action execute = BRdbmsPointQuery.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsPointQuery.class);
    private Clock.Ticket updateTicket;
    private static final BIcon icon = BIcon.std((String)"widgets/table.png");
    private Column[] resultColumns;
    HashMap<BRdbmsProxyExt, BRdbmsProxyExt> pollGroup = new HashMap();

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getUpdateFrequency() {
        return (BRelTime)this.get(updateFrequency);
    }

    @Generated
    public void setUpdateFrequency(BRelTime v) {
        this.set(updateFrequency, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BFormat getSql() {
        return (BFormat)this.get(sql);
    }

    @Generated
    public void setSql(BFormat v) {
        this.set(sql, (BValue)v, null);
    }

    @Generated
    public String getKeyColumn1() {
        return this.getString(keyColumn1);
    }

    @Generated
    public void setKeyColumn1(String v) {
        this.setString(keyColumn1, v, null);
    }

    @Generated
    public String getKeyColumn2() {
        return this.getString(keyColumn2);
    }

    @Generated
    public void setKeyColumn2(String v) {
        this.setString(keyColumn2, v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(sql)) {
            this.execute();
        }
        if (prop.equals(updateFrequency) || prop.equals(enabled) || prop.getName().startsWith("keyColumn")) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isSubscribed()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
                this.invoke(execute, null);
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BRdbms rdbms;
        if (action == execute && (rdbms = (BRdbms)this.getDevice()) != null && rdbms.isRunning()) {
            return rdbms.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public BResultSetTable<? extends BComponent> getData() {
        String sql;
        try {
            sql = this.getSql().format((Object)this);
            sql = sql.replace('\n', ' ');
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Invalid formatting");
            this.getLog().log(Level.SEVERE, "Invalid formatting.", e);
            return null;
        }
        BOrd ord = BOrd.make((BOrd)this.getDevice().getAbsoluteOrd(), (String)("sql:" + sql));
        try {
            this.getLog().fine("Executing query: " + sql);
            return (BResultSetTable)ord.get((BObject)this.getDevice(), null);
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("Unable to execute query.");
            this.getLog().log(Level.SEVERE, "Unable to execute query.", e);
            return null;
        }
    }

    public void doExecute() {
        if (!this.isRunning()) {
            return;
        }
        Logger log = this.getLog();
        log.fine("Executing query " + this.getName());
        BRdbms rdbms = (BRdbms)this.getDevice();
        BStatus status = rdbms.getStatus();
        if (!status.isValid()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot execute query: database status is " + status);
            }
            this.setStatus(rdbms.getStatus());
            return;
        }
        BResultSetTable<? extends BComponent> table = this.getData();
        if (table == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cannot execute query: result set table is null");
            }
            return;
        }
        this.setStatus(rdbms.getStatus());
        this.setFaultCause(rdbms.getFaultCause());
        this.setLastUpdate(BAbsTime.now());
        int controlPoints = this.executeChildren(table);
        this.resultColumns = table.getColumns().list();
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public String getColumnName(Object columnIndex, Context unused) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns[((BInteger)columnIndex).getInt()].getName();
        }
        return null;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public int getColumnCount(Object unused1, Context unused2) {
        if (this.resultColumns != null && this.resultColumns.length > 0) {
            return this.resultColumns.length;
        }
        return 0;
    }

    public void subscribed() {
        if (this.getEnabled()) {
            if (this.updateTicket == null && this.isRunning()) {
                if (this.getLastUpdate().add(this.getUpdateFrequency()).isBefore(BAbsTime.now())) {
                    this.invoke(execute, null);
                }
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateFrequency(), (Action)execute, null);
            }
        } else if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
        super.unsubscribed();
    }

    Logger getLog() {
        BRdbms device = (BRdbms)this.getDevice();
        if (device != null) {
            return device.getLogger();
        }
        return null;
    }

    public void addToPollGroup(BRdbmsProxyExt rdbmsProxyExt) {
        this.pollGroup.put(rdbmsProxyExt, rdbmsProxyExt);
        this.subscribed();
    }

    public void removeFromPollGroup(BRdbmsProxyExt rdbmsProxyExt) {
        this.pollGroup.remove((Object)rdbmsProxyExt);
        if (this.pollGroup.size() == 0) {
            this.unsubscribed();
        }
    }
}

