/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.history.RdbmsHistoryUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.TableCursor;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="userName", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="lastTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=65), @NiagaraProperty(name="exportInvalidValues", type="boolean", defaultValue="true")})
public abstract class BRdbmsHistoryExport
extends BHistoryExport {
    @Generated
    public static final Property userName = BRdbmsHistoryExport.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property password = BRdbmsHistoryExport.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property lastTimestamp = BRdbmsHistoryExport.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property exportInvalidValues = BRdbmsHistoryExport.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryExport.class);
    private BRdbmsHistoryDeviceExt devicelet;
    private BRdbms db;
    private BRdbmsDeprecatedDialect dialect;
    private Connection dmlConnection;
    private boolean dmlConnectionIsPrivileged;
    private Statement dmlStatement;
    private BIHistory history;
    private BHistoryConfig config;
    private BHistoryRecord template;
    private Boolean isNewSchema = null;
    private boolean metadataTableExists = false;
    private Map<String, Object> historyMetaRecord = null;
    private BAbsTime exportRangeStartTime = null;
    private static final Logger LOG = Logger.getLogger("rdb");
    private static final BFacets SHOW_MILLIS = BFacets.make((String)"showMilliseconds", (boolean)true);
    private static final int DEFAULT_EXPORT_BATCH_SIZE = 1000;
    private static final Integer EXPORT_BATCH_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.rdb.historyExport.batchSize", 1000));
    private static final String HISTORY_ID = "HISTORY_ID";
    private static final String METARECORD_TABLE_NAME = "TABLE_NAME";
    private static final String METARECORD_ID = "ID";

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastTimestamp() {
        return (BAbsTime)this.get(lastTimestamp);
    }

    @Generated
    public void setLastTimestamp(BAbsTime v) {
        this.set(lastTimestamp, (BValue)v, null);
    }

    @Generated
    public boolean getExportInvalidValues() {
        return this.getBoolean(exportInvalidValues);
    }

    @Generated
    public void setExportInvalidValues(boolean v) {
        this.setBoolean(exportInvalidValues, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doExecute() {
        block55: {
            long t0;
            block50: {
                block49: {
                    this.devicelet = (BRdbmsHistoryDeviceExt)this.getDeviceExt();
                    this.db = (BRdbms)this.devicelet.getDevice();
                    if (!this.db.getEnabled()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("HistoryExport " + this.getHistoryId() + ": database disabled, on thread " + Thread.currentThread().getName());
                        }
                        this.setState(BDescriptorState.idle);
                        this.updateStatus();
                        return;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("HistoryExport " + this.getHistoryId() + ": begin export on thread " + Thread.currentThread().getName());
                    }
                    t0 = System.currentTimeMillis();
                    this.executeInProgress();
                    this.dialect = BRdbmsDeprecatedDialect.make(this.db);
                    this.dmlConnection = AccessController.doPrivileged(() -> BRdbmsHistoryDeviceExt.getConnectionForDescriptor(this.db, this, false, null));
                    this.dmlConnectionIsPrivileged = this.db.isPrivilegedConnection(this.dmlConnection);
                    this.dmlStatement = this.dmlConnection.createStatement();
                    BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                    BHistoryId hid = this.getHistoryId();
                    try (HistorySpaceConnection conn = localDb.getConnection(null);){
                        this.history = conn.getHistory(hid);
                    }
                    if (this.history == null) {
                        throw new HistoryNotFoundException();
                    }
                    this.config = this.history.getConfig();
                    this.template = this.config.makeRecord();
                    if (this.devicelet.getUseHistoryConfigTimeZone()) {
                        if (this.devicelet.getUseLastTimestamp()) {
                            this.dialect.setTimeZone(this.config.getTimeZone());
                        } else {
                            throw new BajaRuntimeException("Export failed: useHistoryConfigTimeZone=true and useLastTimestamp=false.");
                        }
                    }
                    if (this.isExportNecessary()) {
                        this.exportRecords();
                    } else {
                        LOG.fine("No history records found for export.");
                    }
                    this.executeOk();
                    this.metadataTableExists = false;
                    this.historyMetaRecord = null;
                    this.exportRangeStartTime = null;
                    try {
                        if (this.dmlStatement != null) {
                            this.dmlStatement.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!LOG.isLoggable(Level.SEVERE)) break block49;
                        LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close statement 'nonPrivilegedConnectionStatement': " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
                    }
                }
                try {
                    if (this.dmlConnection != null) {
                        this.dmlConnection.close();
                    }
                }
                catch (SQLException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block50;
                    LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close connection 'nonPrivilegedConnection': " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                long ms = System.currentTimeMillis() - t0;
                LOG.fine("end export (" + ms + "ms)");
            }
            break block55;
            catch (Exception e) {
                block52: {
                    block51: {
                        try {
                            Throwable cause = e;
                            if (e instanceof PrivilegedActionException && e.getCause() != null) {
                                cause = e.getCause();
                            }
                            if (LOG.isLoggable(Level.SEVERE)) {
                                LOG.log(Level.SEVERE, "History Export failed for " + this.devicelet.getName(), LOG.isLoggable(Level.SEVERE) ? cause : null);
                            }
                            this.executeFail(cause);
                            this.metadataTableExists = false;
                            this.historyMetaRecord = null;
                            this.exportRangeStartTime = null;
                        }
                        catch (Throwable throwable) {
                            block54: {
                                block53: {
                                    this.metadataTableExists = false;
                                    this.historyMetaRecord = null;
                                    this.exportRangeStartTime = null;
                                    try {
                                        if (this.dmlStatement != null) {
                                            this.dmlStatement.close();
                                        }
                                    }
                                    catch (SQLException e2) {
                                        if (!LOG.isLoggable(Level.SEVERE)) break block53;
                                        LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close statement 'nonPrivilegedConnectionStatement': " + e2.getMessage(), LOG.isLoggable(Level.FINE) ? e2 : null);
                                    }
                                }
                                try {
                                    if (this.dmlConnection != null) {
                                        this.dmlConnection.close();
                                    }
                                }
                                catch (SQLException e3) {
                                    if (!LOG.isLoggable(Level.SEVERE)) break block54;
                                    LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close connection 'nonPrivilegedConnection': " + e3.getMessage(), LOG.isLoggable(Level.FINE) ? e3 : null);
                                }
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                long ms2 = System.currentTimeMillis() - t0;
                                LOG.fine("end export (" + ms2 + "ms)");
                            }
                            throw throwable;
                        }
                        try {
                            if (this.dmlStatement != null) {
                                this.dmlStatement.close();
                            }
                        }
                        catch (SQLException e4) {
                            if (!LOG.isLoggable(Level.SEVERE)) break block51;
                            LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close statement 'nonPrivilegedConnectionStatement': " + e4.getMessage(), LOG.isLoggable(Level.FINE) ? e4 : null);
                        }
                    }
                    try {
                        if (this.dmlConnection != null) {
                            this.dmlConnection.close();
                        }
                    }
                    catch (SQLException e5) {
                        if (!LOG.isLoggable(Level.SEVERE)) break block52;
                        LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": Unable to close connection 'nonPrivilegedConnection': " + e5.getMessage(), LOG.isLoggable(Level.FINE) ? e5 : null);
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    long ms = System.currentTimeMillis() - t0;
                    LOG.fine("end export (" + ms + "ms)");
                }
            }
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BRdbms db = (BRdbms)this.getDevice();
        if (db != null) {
            db.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    private boolean isExportNecessary() {
        boolean exportNecessary;
        block27: {
            exportNecessary = true;
            try {
                Optional<Map<String, Object>> metaRecord;
                this.metadataTableExists = this.dialect.tableExists(this.db, this.dmlConnection, this.getMetaTableName());
                if (!this.metadataTableExists || !(metaRecord = this.getMetaRecord()).isPresent()) break block27;
                String historyTableName = (String)metaRecord.get().get(METARECORD_TABLE_NAME);
                this.exportRangeStartTime = this.lookupMaxTimestamp(historyTableName);
                if (this.exportRangeStartTime == null) break block27;
                this.exportRangeStartTime = BAbsTime.make((long)(this.exportRangeStartTime.getMillis() + this.dialect.getTimestampAccuracy()));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("HistoryExport " + this.getHistoryId() + ": maxTimestamp " + this.exportRangeStartTime.toString((Context)SHOW_MILLIS));
                }
                BHistoryDatabase localHistoryDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                try (HistorySpaceConnection historyConn = localHistoryDb.getConnection(HistoryQuery.makeExcludeArchiveDataContext(null));
                     TableCursor recordsCursor = historyConn.timeQuery(this.history, this.exportRangeStartTime, null).cursor();){
                    exportNecessary = recordsCursor.next();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block27;
                LOG.log(Level.SEVERE, "HistoryExport " + this.getHistoryId() + ": " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
            }
        }
        return exportNecessary;
    }

    private void exportRecords() throws Exception {
        String metaTableName = this.getMetaTableName();
        if (!this.metadataTableExists) {
            this.isNewSchema = true;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("HistoryExport " + this.getHistoryId() + ": table '" + metaTableName + "' does not exist.");
            }
            this.createMetaTable();
        } else {
            this.isNewSchema = RdbmsHistoryUtil.isNewSchema(this.dmlConnection, metaTableName);
        }
        Optional<Map<String, Object>> metaRecord = this.getMetaRecord();
        String tableName = null;
        boolean historyIdColumnAddedToExistingTable = false;
        if (metaRecord.isPresent()) {
            Map<String, Object> meta = metaRecord.get();
            tableName = (String)meta.get(METARECORD_TABLE_NAME);
            Number tableId = (Number)meta.get(METARECORD_ID);
            if (this.columnExists(metaTableName, "VALUEFACETS")) {
                String dbValueFacets = (String)meta.get("VALUEFACETS");
                BValue valuefacets = this.config.get("valueFacets");
                if (valuefacets instanceof BFacets) {
                    String configValueFacets = valuefacets.asSimple().encodeToString();
                    if (dbValueFacets != null && !dbValueFacets.equals(configValueFacets)) {
                        String updateFacetsSql = this.dialect.makeUpdateSql(metaTableName, new Property[]{this.config.getProperty("valueFacets")}, new String[0], this.dialect.mangleIdentifier(BHistoryConfig.id.getName()));
                        try (PreparedStatement stmt = this.dmlConnection.prepareStatement(updateFacetsSql);){
                            stmt.setString(1, configValueFacets);
                            stmt.setString(2, this.config.getId().toString());
                            stmt.execute();
                        }
                    }
                }
            }
            if (!this.dialect.tableExists(this.db, this.dmlConnection, tableName)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("HistoryExport " + this.getHistoryId() + ": table '" + tableName + "' does not exist.");
                }
                this.createTable(tableName, tableId);
            } else if (this.db.getExportMode().getOrdinal() == 1 && !this.columnExists(tableName, HISTORY_ID)) {
                this.addHistoryIdColumnAndIndexToTable(tableName, tableId);
                historyIdColumnAddedToExistingTable = true;
            }
        } else {
            this.insertMetaRecord();
            metaRecord = this.getMetaRecord();
            if (!metaRecord.isPresent()) {
                throw new BajaRuntimeException("Could not create metadata record for history " + this.config.getId().getDeviceName() + " ::: " + this.config.getId().getHistoryName());
            }
            tableName = (String)metaRecord.get().get(METARECORD_TABLE_NAME);
            Number tableId = (Number)metaRecord.get().get(METARECORD_ID);
            if (!this.dialect.tableExists(this.db, this.dmlConnection, tableName)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("HistoryExport " + this.getHistoryId() + ": table '" + tableName + "' does not exist.");
                }
                this.createTable(tableName, tableId);
            } else if (this.db.getExportMode().getOrdinal() == 1 && !this.columnExists(tableName, HISTORY_ID)) {
                this.addHistoryIdColumnAndIndexToTable(tableName, tableId);
                historyIdColumnAddedToExistingTable = true;
            }
        }
        BAbsTime oldStamp = this.getLastTimestamp();
        BAbsTime newStamp = this.insertRecords(oldStamp, tableName, historyIdColumnAddedToExistingTable);
        this.setLastTimestamp(newStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(String tableName, Number tableId) throws SQLException {
        Connection privilegedConnection;
        Property[] propTemplate = this.template.getPropertiesArray();
        Array extraFields = new Array(String.class);
        Array extraFieldTypes = new Array(Type.class);
        Array extraFacets = new Array(BFacets.class);
        if (this.db.getExportMode().getOrdinal() == 1) {
            extraFields.add((Object)HISTORY_ID);
            extraFieldTypes.add((Object)BString.TYPE);
            extraFacets.add((Object)BFacets.NULL);
        }
        if (this.template instanceof BTrendRecord) {
            extraFields.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
            extraFieldTypes.addAll((Object[])new Type[]{BString.TYPE, BString.TYPE});
            extraFacets.addAll((Object[])new BFacets[]{BFacets.NULL, BFacets.NULL});
        }
        String sql = this.dialect.makeCreateTableSql(tableName, propTemplate, (String[])extraFields.trim(), (Type[])extraFieldTypes.trim(), (BFacets[])extraFacets.trim());
        try {
            privilegedConnection = AccessController.doPrivileged(() -> this.dmlConnectionIsPrivileged ? this.dmlConnection : BRdbmsHistoryDeviceExt.getConnectionForDescriptor(this.db, this, true, null));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
        try (Statement privilegedConnectionStatement = privilegedConnection.createStatement();){
            privilegedConnectionStatement.executeUpdate(sql);
            if (this.dialect.hasSequences()) {
                privilegedConnectionStatement.executeUpdate("CREATE SEQUENCE " + tableName + "_Q");
            }
            if (!this.devicelet.getUseLastTimestamp() || this.devicelet.getAlwaysCreateIndexForNewTables()) {
                Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(String.valueOf(tableId));
                RdbmsHistoryUtil.createIndex(privilegedConnection, this.dialect, tableName, indexNameAndColumns);
            }
        }
        finally {
            if (privilegedConnection != this.dmlConnection) {
                privilegedConnection.close();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HistoryExport " + this.getHistoryId() + ": created table '" + tableName + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryIdColumnAndIndexToTable(String tableName, Number tableId) throws SQLException {
        Connection privilegedConnection;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HistoryExport " + this.getHistoryId() + ": Adding HISTORY_ID column to table '" + tableName + "'");
        }
        String addColumnStatement = this.dialect.makeAddColumnSql(tableName, HISTORY_ID, BSqlType.sqlVarchar, 500, "");
        try {
            privilegedConnection = AccessController.doPrivileged(() -> this.dmlConnectionIsPrivileged ? this.dmlConnection : BRdbmsHistoryDeviceExt.getConnectionForDescriptor(this.db, this, true, null));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
        try (Statement privilegedConnectionStatement = privilegedConnection.createStatement();){
            privilegedConnectionStatement.executeUpdate(addColumnStatement);
            if (!this.devicelet.getUseLastTimestamp() || this.devicelet.getAlwaysCreateIndexForNewTables()) {
                Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(String.valueOf(tableId));
                RdbmsHistoryUtil.createIndex(privilegedConnection, this.dialect, tableName, indexNameAndColumns);
            }
        }
        finally {
            if (privilegedConnection != this.dmlConnection) {
                privilegedConnection.close();
            }
        }
    }

    private boolean columnExists(String tableName, String columnName) throws SQLException {
        DatabaseMetaData metadata = this.dmlConnection.getMetaData();
        try (ResultSet rs = metadata.getColumns(null, null, tableName, columnName);){
            boolean bl = rs.next();
            return bl;
        }
    }

    private BAbsTime insertRecords(BAbsTime lastExportTime, String tableName, boolean fallbackToLastTimestampPropertyValueIfNoMaxTimestampInDatabase) throws SQLException {
        if (this.exportRangeStartTime == null && fallbackToLastTimestampPropertyValueIfNoMaxTimestampInDatabase) {
            this.exportRangeStartTime = BAbsTime.make((long)(lastExportTime.getMillis() + this.dialect.getTimestampAccuracy()));
        }
        BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        try (HistorySpaceConnection historyConn = localDb.getConnection(HistoryQuery.makeExcludeArchiveDataContext(null));
             TableCursor records = historyConn.timeQuery(this.history, this.exportRangeStartTime, null).cursor();){
            boolean addUtcOffsetEntry;
            Array extraFields = new Array(String.class);
            if (this.db.getExportMode().getOrdinal() == 1) {
                extraFields.add((Object)HISTORY_ID);
            }
            if (this.template instanceof BTrendRecord) {
                extraFields.addAll((Object[])new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"});
            }
            if (addUtcOffsetEntry = false) {
                extraFields.add((Object)"UTC_OFFSET");
            }
            int extraFieldsSize = extraFields.size();
            BObject[] extraValues = new BObject[extraFieldsSize];
            BFacets[] extraFacets = new BFacets[extraFieldsSize];
            Property[] propTemplate = this.template.getPropertiesArray();
            String sql = this.dialect.makeInsertSql(tableName, propTemplate, (String[])extraFields.trim());
            int totalCount = 0;
            int count = 0;
            try (PreparedStatement ps = this.dmlConnection.prepareStatement(sql);){
                while (records.next()) {
                    BHistoryRecord rec = (BHistoryRecord)records.get();
                    BAbsTime ts = rec.getTimestamp();
                    if (lastExportTime.compareTo((Object)ts) < 0) {
                        lastExportTime = ts;
                    }
                    switch (this.db.getExportMode().getOrdinal()) {
                        case 0: {
                            if (!(this.template instanceof BTrendRecord)) break;
                            BTrendRecord t = (BTrendRecord)rec;
                            extraValues[0] = BString.make((String)t.getTrendFlags().toString());
                            extraValues[1] = BString.make((String)t.getStatus().toString());
                            break;
                        }
                        case 1: {
                            if (extraValues.length > 0) {
                                extraValues[0] = BString.make((String)this.history.getId().toString());
                            }
                            if (!(this.template instanceof BTrendRecord)) break;
                            BTrendRecord t = (BTrendRecord)rec;
                            extraValues[1] = BString.make((String)t.getTrendFlags().toString());
                            extraValues[2] = BString.make((String)t.getStatus().toString());
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    if (addUtcOffsetEntry) {
                        RdbmsDialect context = (RdbmsDialect)this.db.getRdbmsContext();
                        BTimeZone timezone = context.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
                        BLong utcOffset = BLong.make((long)timezone.getJavaTimeZone().getOffset(ts.getMillis()));
                        extraValues[extraValues.length - 1] = utcOffset;
                    }
                    if (this.getExportInvalidValues() || !this.hasInvalidValues(rec, propTemplate, extraValues)) {
                        this.dialect.insertRecord(ps, (BComplex)rec, propTemplate, extraValues, extraFacets);
                        ++count;
                        ++totalCount;
                    }
                    if (count < EXPORT_BATCH_SIZE) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("HistoryExport " + this.getHistoryId() + ": sending batch at " + totalCount + " records");
                    }
                    ps.executeBatch();
                    ps.clearBatch();
                    count = 0;
                }
                if (count > 0) {
                    ps.executeBatch();
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("HistoryExport " + this.getHistoryId() + ": inserted " + totalCount + " records");
            }
        }
        return lastExportTime;
    }

    private boolean hasInvalidValues(BHistoryRecord rec, Property[] propTemplate, BObject[] extraValues) {
        for (Property property : propTemplate) {
            if (rec.get(property).getType().is(BDouble.TYPE) && !Double.isFinite(((BDouble)rec.get(property)).getDouble())) {
                return true;
            }
            if (!rec.get(property).getType().is(BFloat.TYPE) || Float.isFinite(((BFloat)rec.get(property)).getFloat())) continue;
            return true;
        }
        for (Property property : extraValues) {
            if (property.getType().is(BDouble.TYPE) && !Double.isFinite(((BDouble)property.asValue()).getDouble())) {
                return true;
            }
            if (!property.getType().is(BFloat.TYPE) || Float.isFinite(((BFloat)property.asValue()).getFloat())) continue;
            return true;
        }
        return false;
    }

    private BAbsTime lookupMaxTimestamp(String tableName) throws SQLException {
        if (this.devicelet.getUseLastTimestamp()) {
            BAbsTime time = this.getLastTimestamp();
            if (!time.equals((Object)BAbsTime.NULL)) {
                return time;
            }
        } else {
            String sql = "SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP FROM " + tableName;
            switch (this.db.getExportMode().getOrdinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    sql = sql + " WHERE HISTORY_ID = '" + RdbmsHistoryUtil.fixQuotes(this.history.getId().toString()) + '\'';
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Timestamp ts = null;
            try (ResultSet rs = this.dmlStatement.executeQuery(sql);){
                if (rs.next()) {
                    if (this.dialect.supportsTimestamp()) {
                        Calendar cal = this.db.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp) ? Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone()) : (this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? Calendar.getInstance(this.config.getTimeZone().getJavaTimeZone()) : Calendar.getInstance());
                        ts = rs.getTimestamp("MAX_TIMESTAMP", cal);
                        if (ts == null) {
                            BAbsTime bAbsTime = null;
                            return bAbsTime;
                        }
                    } else {
                        String str = rs.getString("MAX_TIMESTAMP");
                        if (str == null) {
                            BAbsTime bAbsTime = null;
                            return bAbsTime;
                        }
                        ts = new Timestamp(Long.parseLong(str));
                    }
                    long millis = ts.getTime();
                    BAbsTime bAbsTime = BAbsTime.make((long)millis);
                    return bAbsTime;
                }
            }
        }
        return null;
    }

    private BTimeZone getExportTimeZone() throws SQLException {
        Optional<Map<String, Object>> metaRecord = this.getMetaRecord();
        BTimeZone timezone = BTimeZone.NULL;
        if (metaRecord.isPresent() && this.isNewSchema.booleanValue()) {
            Map<String, Object> meta = metaRecord.get();
            try {
                String timeZoneId = (String)meta.get("DB_TIMEZONE");
                timeZoneId = timeZoneId.substring(0, timeZoneId.indexOf("(")).trim();
                timezone = BTimeZone.getTimeZone((String)timeZoneId);
            }
            catch (Exception ex) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to retrieve timezone for export of " + this.toPathString(), LOG.isLoggable(Level.FINE) ? ex : null);
                }
            }
        } else {
            timezone = this.devicelet.getUseHistoryConfigTimeZone() && this.devicelet.getUseLastTimestamp() ? this.config.getTimeZone() : BTimeZone.getLocal();
        }
        return timezone;
    }

    private String getMetaTableName() {
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                return "HISTORY_CONFIG";
            }
            case 1: {
                return "HISTORY_TYPE_MAP";
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetaTable() throws SQLException {
        Connection privilegedConnection;
        String name = this.getMetaTableName();
        Property[] metaTemplate = this.makeMetaTemplate();
        String sql = this.dialect.makeCreateTableSql(name, metaTemplate, new String[]{METARECORD_TABLE_NAME, "DB_TIMEZONE"}, new Type[]{BString.TYPE, BString.TYPE}, new BFacets[]{BFacets.NULL, BFacets.NULL});
        try {
            privilegedConnection = AccessController.doPrivileged(() -> this.dmlConnectionIsPrivileged ? this.dmlConnection : BRdbmsHistoryDeviceExt.getConnectionForDescriptor(this.db, this, true, null));
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException(cause);
        }
        try (Statement privilegedConnectionStatement = privilegedConnection.createStatement();){
            privilegedConnectionStatement.executeUpdate(sql);
            if (this.dialect.hasSequences()) {
                privilegedConnectionStatement.executeUpdate("CREATE SEQUENCE " + name + "_Q");
            }
        }
        finally {
            if (privilegedConnection != this.dmlConnection) {
                privilegedConnection.close();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("HistoryExport " + this.getHistoryId() + ": created table '" + name + "'.");
        }
    }

    private void insertMetaRecord() throws SQLException {
        try {
            String[] stringArray;
            Property[] metaTemplate = this.makeMetaTemplate();
            String string = this.getMetaTableName();
            if (this.isNewSchema.booleanValue()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = METARECORD_TABLE_NAME;
                stringArray = stringArray2;
                stringArray2[1] = "DB_TIMEZONE";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = METARECORD_TABLE_NAME;
            }
            try (PreparedStatement ps = this.dmlConnection.prepareStatement(this.dialect.makeInsertSql(string, metaTemplate, stringArray));){
                BFacets[] bFacetsArray;
                String tableName = this.inventTableName();
                BString tableNameStr = BString.make((String)tableName);
                RdbmsDialect context = (RdbmsDialect)this.db.getRdbmsContext();
                BTimeZone dbTimeZone = context.useUtcTimestamps() ? BTimeZone.UTC : (this.devicelet.getUseHistoryConfigTimeZone() ? this.config.getTimeZone() : BTimeZone.getLocal());
                BString timeZoneStr = BString.make((String)dbTimeZone.toString());
                BObject[] tablePlusTz = new BObject[]{tableNameStr, timeZoneStr};
                BObject[] table = new BObject[]{tableNameStr};
                BObject[] bObjectArray = this.isNewSchema != false ? tablePlusTz : table;
                if (this.isNewSchema.booleanValue()) {
                    BFacets[] bFacetsArray2 = new BFacets[2];
                    bFacetsArray2[0] = BFacets.NULL;
                    bFacetsArray = bFacetsArray2;
                    bFacetsArray2[1] = BFacets.NULL;
                } else {
                    BFacets[] bFacetsArray3 = new BFacets[1];
                    bFacetsArray = bFacetsArray3;
                    bFacetsArray3[0] = BFacets.NULL;
                }
                this.dialect.insertRecord(ps, (BComplex)this.config, metaTemplate, bObjectArray, bFacetsArray);
                ps.executeBatch();
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private Optional<Map<String, Object>> getMetaRecord() throws SQLException {
        if (this.historyMetaRecord != null) {
            return Optional.of(this.historyMetaRecord);
        }
        String metaTableName = this.getMetaTableName();
        boolean exportingById = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId);
        String sql = exportingById || this.isNewSchema != null && this.isNewSchema != false ? "SELECT * FROM " + metaTableName + " WHERE ID_ = '" + RdbmsHistoryUtil.fixQuotes(this.config.getId().toString()) + "'" : "SELECT * FROM " + metaTableName + " WHERE RECORDTYPE = '" + RdbmsHistoryUtil.fixQuotes(this.config.getRecordType().toString()) + "'";
        Optional<Map<String, Object>> metaRecord = Optional.empty();
        try (ResultSet resultSet = this.dmlStatement.executeQuery(sql);){
            if (resultSet.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (int i = 1; i < resultSet.getMetaData().getColumnCount(); ++i) {
                    String columnName = resultSet.getMetaData().getColumnName(i);
                    Object columnValue = resultSet.getObject(i);
                    result.put(columnName, columnValue);
                }
                metaRecord = Optional.of(result);
            }
        }
        if (this.isNewSchema != null && metaRecord.isPresent()) {
            this.historyMetaRecord = metaRecord.get();
        }
        return metaRecord;
    }

    private String inventTableName() throws SQLException {
        String tableName;
        int seq;
        int max = this.dialect.getMaxTableName();
        if (this.dialect.hasSequences() && max > (seq = this.dialect.getMaxSequenceName()) - 2) {
            max = seq - 2;
        }
        switch (this.db.getExportMode().getOrdinal()) {
            case 0: {
                String devName = SlotPath.unescape((String)this.config.getId().getDeviceName()).toUpperCase();
                String histName = SlotPath.unescape((String)this.config.getId().getHistoryName()).toUpperCase();
                tableName = TextUtil.truncate((String)(this.dialect.mangleIdentifier(devName) + "_" + this.dialect.mangleIdentifier(histName)), (int)max);
                break;
            }
            case 1: {
                tableName = TextUtil.truncate((String)this.dialect.mangleIdentifier(this.config.getRecordType().toString()), (int)max);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId) && this.metaRecordExists(tableName)) {
            String nn;
            String fullName = tableName;
            int n = 1;
            while (this.metaRecordExists(tableName = TextUtil.truncate((String)fullName, (int)(max - (nn = Integer.toString(n++)).length())) + nn)) {
            }
        }
        return tableName;
    }

    private boolean metaRecordExists(String tableName) throws SQLException {
        boolean metaRecordExists;
        String selectMetaTableName = "SELECT * FROM " + this.getMetaTableName() + " WHERE TABLE_NAME = '" + tableName + "'";
        try (ResultSet rs = this.dmlStatement.executeQuery(selectMetaTableName);){
            metaRecordExists = rs.next();
        }
        return metaRecordExists;
    }

    private Property[] makeMetaTemplate() throws SQLException {
        if (this.config.getProperty("valueFacets") == null) {
            this.config.add("valueFacets", (BValue)BFacets.NULL);
        }
        Array arr = new Array(Property.class);
        SlotCursor historyConfigProperties = this.config.getProperties();
        boolean exportingByType = this.db.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryType);
        while (historyConfigProperties.next()) {
            Property property = historyConfigProperties.property();
            String name = property.getName();
            if (exportingByType) {
                if (this.isNewSchema.booleanValue()) {
                    if (name.equals(BHistoryConfig.id.getName()) || name.equals(BHistoryConfig.timeZone.getName()) || name.equals(BHistoryConfig.recordType.getName())) {
                        arr.add((Object)property);
                        continue;
                    }
                } else if (name.equals(BHistoryConfig.recordType.getName())) {
                    arr.add((Object)property);
                    continue;
                }
            } else if (name.equals(BHistoryConfig.id.getName()) || name.equals(BHistoryConfig.historyName.getName()) || name.equals(BHistoryConfig.source.getName()) || name.equals(BHistoryConfig.sourceHandle.getName()) || name.equals(BHistoryConfig.timeZone.getName()) || name.equals(BHistoryConfig.interval.getName()) || name.equals(BHistoryConfig.systemTags.getName())) {
                arr.add((Object)property);
                continue;
            }
            if (!property.isDynamic() || !name.equals("valueFacets")) continue;
            String metaTableName = this.getMetaTableName();
            String facetsColumn = this.dialect.mangleIdentifier(name);
            if (this.dialect.tableExists(this.db, this.dmlConnection, metaTableName) && !this.columnExists(metaTableName, facetsColumn)) continue;
            arr.add((Object)property);
        }
        return (Property[])arr.trim();
    }
}

