/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDiscoverTablesJob;
import com.tridium.rdb.history.BRdbmsMigrateIndexesJob;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryExport;
import javax.baja.rdb.history.BRdbmsHistoryImport;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="useLastTimestamp", type="boolean", defaultValue="false"), @NiagaraProperty(name="useHistoryConfigTimeZone", type="boolean", defaultValue="false"), @NiagaraProperty(name="alwaysCreateIndexForNewTables", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="submitRdbTableDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="updateLastTimestamp", flags=132), @NiagaraAction(name="clearLastTimestamp", flags=132), @NiagaraAction(name="migrateToOptimizedTableIndexes", returnType="BOrd", flags=128)})
public abstract class BRdbmsHistoryDeviceExt
extends BHistoryDeviceExt {
    @Generated
    public static final Property useLastTimestamp = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property useHistoryConfigTimeZone = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property alwaysCreateIndexForNewTables = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action submitRdbTableDiscoveryJob = BRdbmsHistoryDeviceExt.newAction((int)4, null);
    @Generated
    public static final Action updateLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    @Generated
    public static final Action clearLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    @Generated
    public static final Action migrateToOptimizedTableIndexes = BRdbmsHistoryDeviceExt.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryDeviceExt.class);
    private static final Logger LOG = Logger.getLogger("rdb");

    @Generated
    public boolean getUseLastTimestamp() {
        return this.getBoolean(useLastTimestamp);
    }

    @Generated
    public void setUseLastTimestamp(boolean v) {
        this.setBoolean(useLastTimestamp, v, null);
    }

    @Generated
    public boolean getUseHistoryConfigTimeZone() {
        return this.getBoolean(useHistoryConfigTimeZone);
    }

    @Generated
    public void setUseHistoryConfigTimeZone(boolean v) {
        this.setBoolean(useHistoryConfigTimeZone, v, null);
    }

    @Generated
    public boolean getAlwaysCreateIndexForNewTables() {
        return this.getBoolean(alwaysCreateIndexForNewTables);
    }

    @Generated
    public void setAlwaysCreateIndexForNewTables(boolean v) {
        this.setBoolean(alwaysCreateIndexForNewTables, v, null);
    }

    @Generated
    public BOrd submitRdbTableDiscoveryJob() {
        return (BOrd)this.invoke(submitRdbTableDiscoveryJob, null, null);
    }

    @Generated
    public void updateLastTimestamp() {
        this.invoke(updateLastTimestamp, null, null);
    }

    @Generated
    public void clearLastTimestamp() {
        this.invoke(clearLastTimestamp, null, null);
    }

    @Generated
    public BOrd migrateToOptimizedTableIndexes() {
        return (BOrd)this.invoke(migrateToOptimizedTableIndexes, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getImportDescriptorType() {
        return BRdbmsHistoryImport.TYPE;
    }

    public boolean supportsGenericArchiveFolder() {
        return true;
    }

    public BOrd doSubmitRdbTableDiscoveryJob(Context cx) {
        if (this.getDevice().isFatalFault() || this.getDevice().isDown() || this.getDevice().isDisabled()) {
            return null;
        }
        return new BRdbmsDiscoverTablesJob(this).submit(cx);
    }

    public void doUpdateLastTimestamp() {
        BRdbmsHistoryExport[] exports;
        LOG.fine("Beginning timestamp update...");
        long t0 = System.currentTimeMillis();
        BRdbms db = (BRdbms)this.getDevice();
        if (db.getExportMode().getOrdinal() == 0) {
            throw new BajaRuntimeException("updateLastTimestamp does not work when the export mode is set to BY_HISTORY_ID.");
        }
        Map<String, BAbsTime> timestampMap = this.makeTimestampMap(db);
        BRdbmsHistoryExport[] bRdbmsHistoryExportArray = exports = (BRdbmsHistoryExport[])this.getChildren(BRdbmsHistoryExport.class);
        int n = bRdbmsHistoryExportArray.length;
        for (int i = 0; i < n; ++i) {
            BRdbmsHistoryExport export;
            BHistoryId id = (export = bRdbmsHistoryExportArray[i]).getHistoryId();
            BAbsTime timestamp = timestampMap.get(id.toString());
            export.setLastTimestamp(timestamp == null ? BAbsTime.NULL : timestamp);
        }
        long ms = System.currentTimeMillis() - t0;
        LOG.fine("Updated " + exports.length + " timestamps (" + ms + "ms)");
    }

    private Map<String, BAbsTime> makeTimestampMap(BRdbms db) {
        try {
            HashMap<String, BAbsTime> map = new HashMap<String, BAbsTime>();
            try (Connection nonPrivilegedConnection = AccessController.doPrivileged(() -> db.getNonPrivilegedConnection(null));
                 Statement tablesStatement = nonPrivilegedConnection.createStatement();){
                ResultSet tables = tablesStatement.executeQuery("SELECT DISTINCT TABLE_NAME FROM HISTORY_TYPE_MAP");
                while (tables.next()) {
                    Statement maxTimestampStatement = nonPrivilegedConnection.createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet rs = maxTimestampStatement.executeQuery("SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP, HISTORY_ID FROM " + tables.getString("TABLE_NAME") + " GROUP BY HISTORY_ID");
                        while (rs.next()) {
                            BAbsTime timestamp = BAbsTime.make((long)rs.getTimestamp("MAX_TIMESTAMP").getTime());
                            map.put(rs.getString("HISTORY_ID"), timestamp);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (maxTimestampStatement == null) continue;
                        if (throwable != null) {
                            try {
                                maxTimestampStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        maxTimestampStatement.close();
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof PrivilegedActionException && e.getCause() != null) {
                cause = e.getCause();
            }
            throw new BajaRuntimeException(cause);
        }
    }

    public void doClearLastTimestamp() {
        BRdbmsHistoryExport[] exports;
        for (BRdbmsHistoryExport export : exports = (BRdbmsHistoryExport[])this.getChildren(BRdbmsHistoryExport.class)) {
            export.setLastTimestamp(BAbsTime.NULL);
        }
        LOG.fine("Cleared " + exports.length + " timestamps.");
    }

    public BOrd doMigrateToOptimizedTableIndexes(Context cx) throws Exception {
        return new BRdbmsMigrateIndexesJob(this).submit(cx);
    }

    @Deprecated
    public String getUserName(BRdbms database, BRdbmsHistoryExport descriptor) {
        String str = descriptor.getUserName();
        if (str != null && !str.isEmpty()) {
            return str;
        }
        str = database.getUserName();
        if (str != null && !str.isEmpty()) {
            return str;
        }
        return "";
    }

    @Deprecated
    public BPassword getPassword(BRdbms database, BRdbmsHistoryExport descriptor) {
        BPassword password = descriptor.getPassword();
        if (password != null && !password.equals((Object)BPassword.DEFAULT)) {
            return password;
        }
        password = database.getPassword();
        if (password != null && !password.equals((Object)BPassword.DEFAULT)) {
            return password;
        }
        return BPassword.DEFAULT;
    }

    public static Connection getConnectionForDescriptor(BRdbms database, BRdbmsHistoryExport descriptor, boolean requestPrivileged, Context cx) throws SQLException {
        BPassword descriptorPassword;
        String descriptorUserName = descriptor.getUserName();
        if (descriptorUserName != null && !descriptorUserName.isEmpty() && (descriptorPassword = descriptor.getPassword()) != null && !descriptorPassword.equals((Object)BPassword.DEFAULT)) {
            return database.getConnection(descriptorUserName, descriptorPassword);
        }
        if (requestPrivileged) {
            return database.getPrivilegedConnection(cx);
        }
        return database.getNonPrivilegedConnection(cx);
    }
}

