/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.util.BRdbmsUpdateJob;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BUnicodeUpdateJob
extends BRdbmsUpdateJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BUnicodeUpdateJob.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BUnicodeUpdateJob() {
    }

    protected BUnicodeUpdateJob(BRdbmsUpdater updater) {
        super(updater);
    }

    @Override
    protected void updateTable(String tableName) throws SQLException {
        this.log().message("Updating table " + tableName);
        DatabaseMetaData metadata = this.getNonPrivilegedConnection().getMetaData();
        HashMap<String, String> indexToColumnMap = new HashMap<String, String>();
        try (ResultSet rs = metadata.getIndexInfo(null, null, tableName, false, false);){
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null || !indexName.startsWith("IDX_")) continue;
                indexToColumnMap.put(indexName, rs.getString("COLUMN_NAME"));
            }
        }
        HashSet<Pair> columnsToAlter = new HashSet<Pair>();
        try (ResultSet rs = metadata.getColumns(null, null, tableName, null);){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String string = rs.getString("TYPE_NAME").toUpperCase();
                int columnWidth = rs.getInt("COLUMN_SIZE");
                if (!string.startsWith("VARCHAR")) continue;
                columnsToAlter.add(new Pair((Object)columnName, (Object)columnWidth));
            }
        }
        if (!this.getNonPrivilegedConnection().getAutoCommit()) {
            this.getNonPrivilegedConnection().commit();
        }
        if (!columnsToAlter.isEmpty()) {
            var6_6 = null;
            try (Statement statement = this.getPrivilegedConnection().createStatement();){
                this.log().message("Dropping indexes on columns");
                for (String string : indexToColumnMap.keySet()) {
                    String sql = this.getRdbmsDialect().makeDropIndexSql(string, tableName);
                    statement.execute(sql);
                    this.log().message("Dropped index " + string + "on table " + tableName);
                }
                this.log().message("Indexes on table " + tableName + " dropped");
                this.log().message("Updating VARCHAR columns to Unicode");
                for (Pair pair : columnsToAlter) {
                    String sql = this.getRdbmsDialect().makeAlterColumnTypeSql(tableName, (String)pair.getFirst(), BSqlType.sqlNVarchar, (Integer)pair.getSecond());
                    statement.execute(sql);
                }
                this.log().message("Columns updated");
                this.log().message("Reconstructing indexes on " + tableName);
                for (Map.Entry entry : indexToColumnMap.entrySet()) {
                    String sql = "CREATE INDEX " + (String)entry.getKey() + " ON " + tableName + "(" + (String)entry.getValue() + ")";
                    statement.execute(sql);
                    this.log().message("Index " + (String)entry.getKey() + " created on " + tableName + "." + (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
        this.log().message("Indexes reconstructed");
        this.log().success("Updates to table " + tableName + " complete");
    }
}

