/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BRdbmsUpdateJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsUpdateJob.class);
    private static final Logger LOG = Logger.getLogger("rdb");
    protected BRdbmsUpdater updater;
    protected Context cx;
    private BRdbms database;
    private Connection privilegedConnection;
    private Connection nonPrivilegedConnection;
    private BRdbmsDeprecatedDialect dialect;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BRdbmsUpdateJob() {
    }

    protected BRdbmsUpdateJob(BRdbmsUpdater updater) {
        this.updater = updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(Context cx) throws Exception {
        BRdbms[] databases = this.resolveDatabases(cx);
        for (int i = 0; i < databases.length; ++i) {
            BRdbms rdbms = databases[i];
            if (rdbms.getStatus().isValid()) {
                try {
                    this.updateStarting(rdbms, cx);
                    this.log().message("Updating tables for database: " + rdbms.getDisplayName(cx));
                    this.updateTables();
                    this.progress((int)((double)(i + 1) * 1.0 / (double)databases.length * 100.0));
                    this.log().success("Table updates for database: " + rdbms.getDisplayName(cx) + " complete");
                    continue;
                }
                finally {
                    this.updateEnding();
                }
            }
            this.log().message("Skipping update for " + rdbms.getDisplayName(cx) + ". Status is " + rdbms.getStatus());
        }
    }

    private void updateStarting(BRdbms database, Context cx) {
        this.database = database;
        this.cx = cx;
        BRdbmsUpdateJob.disableDatabaseDescriptors(this.database);
        this.updateStarted();
    }

    protected void updateStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void updateEnding() {
        block77: {
            block76: {
                block68: {
                    this.updateCompleted();
                    this.log().message("Committing transaction..");
                    if (this.nonPrivilegedConnection != null && !this.nonPrivilegedConnection.getAutoCommit()) {
                        this.nonPrivilegedConnection.commit();
                    }
                    this.log().message("Transaction committed..");
                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection && !this.privilegedConnection.getAutoCommit()) {
                        this.privilegedConnection.commit();
                    }
                    if (this.nonPrivilegedConnection == null) break block68;
                    try {
                        this.nonPrivilegedConnection.close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e : null);
                    }
                }
                if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                    try {
                        this.privilegedConnection.close();
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e : null);
                    }
                }
                break block76;
                catch (Exception e) {
                    block69: {
                        try {
                            this.failed(e);
                            if (this.nonPrivilegedConnection == null) break block69;
                        }
                        catch (Throwable throwable) {
                            if (this.nonPrivilegedConnection != null) {
                                try {
                                    this.nonPrivilegedConnection.close();
                                }
                                catch (Exception e2) {
                                    LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e2 : null);
                                }
                            }
                            if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                                try {
                                    this.privilegedConnection.close();
                                }
                                catch (Exception e3) {
                                    LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e3 : null);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            this.nonPrivilegedConnection.close();
                        }
                        catch (Exception e4) {
                            LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e4 : null);
                        }
                    }
                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                        try {
                            this.privilegedConnection.close();
                        }
                        catch (Exception e5) {
                            LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e5 : null);
                        }
                    }
                }
            }
            this.dialect = null;
            this.privilegedConnection = null;
            this.nonPrivilegedConnection = null;
            BRdbmsUpdateJob.enableDatabaseDescriptors(this.database);
            break block77;
            catch (Exception e) {
                block72: {
                    block70: {
                        try {
                            this.failed(e);
                        }
                        catch (Throwable throwable) {
                            block75: {
                                block73: {
                                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection && !this.privilegedConnection.getAutoCommit()) {
                                        this.privilegedConnection.commit();
                                    }
                                    if (this.nonPrivilegedConnection == null) break block73;
                                    try {
                                        this.nonPrivilegedConnection.close();
                                    }
                                    catch (Exception e6) {
                                        LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e6 : null);
                                    }
                                }
                                if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                                    try {
                                        this.privilegedConnection.close();
                                    }
                                    catch (Exception e7) {
                                        LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e7 : null);
                                    }
                                }
                                break block75;
                                catch (Exception e8) {
                                    block74: {
                                        try {
                                            this.failed(e8);
                                            if (this.nonPrivilegedConnection == null) break block74;
                                        }
                                        catch (Throwable throwable2) {
                                            if (this.nonPrivilegedConnection != null) {
                                                try {
                                                    this.nonPrivilegedConnection.close();
                                                }
                                                catch (Exception e9) {
                                                    LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e9 : null);
                                                }
                                            }
                                            if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                                                try {
                                                    this.privilegedConnection.close();
                                                }
                                                catch (Exception e10) {
                                                    LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e10 : null);
                                                }
                                            }
                                            throw throwable2;
                                        }
                                        try {
                                            this.nonPrivilegedConnection.close();
                                        }
                                        catch (Exception e11) {
                                            LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e11 : null);
                                        }
                                    }
                                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                                        try {
                                            this.privilegedConnection.close();
                                        }
                                        catch (Exception e12) {
                                            LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e12 : null);
                                        }
                                    }
                                }
                            }
                            this.dialect = null;
                            this.privilegedConnection = null;
                            this.nonPrivilegedConnection = null;
                            BRdbmsUpdateJob.enableDatabaseDescriptors(this.database);
                            throw throwable;
                        }
                        if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection && !this.privilegedConnection.getAutoCommit()) {
                            this.privilegedConnection.commit();
                        }
                        if (this.nonPrivilegedConnection == null) break block70;
                        try {
                            this.nonPrivilegedConnection.close();
                        }
                        catch (Exception e13) {
                            LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e13 : null);
                        }
                    }
                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                        try {
                            this.privilegedConnection.close();
                        }
                        catch (Exception e14) {
                            LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e14 : null);
                        }
                    }
                    break block72;
                    catch (Exception e15) {
                        block71: {
                            try {
                                this.failed(e15);
                                if (this.nonPrivilegedConnection == null) break block71;
                            }
                            catch (Throwable throwable) {
                                if (this.nonPrivilegedConnection != null) {
                                    try {
                                        this.nonPrivilegedConnection.close();
                                    }
                                    catch (Exception e16) {
                                        LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e16 : null);
                                    }
                                }
                                if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                                    try {
                                        this.privilegedConnection.close();
                                    }
                                    catch (Exception e17) {
                                        LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e17 : null);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                this.nonPrivilegedConnection.close();
                            }
                            catch (Exception e18) {
                                LOG.log(Level.FINE, "Unable to close non-privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e18 : null);
                            }
                        }
                        if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection) {
                            try {
                                this.privilegedConnection.close();
                            }
                            catch (Exception e19) {
                                LOG.log(Level.FINE, "Unable to close privileged JDBC Connection in BRdbmsUpdateJob", LOG.isLoggable(Level.FINE) ? e19 : null);
                            }
                        }
                    }
                }
                this.dialect = null;
                this.privilegedConnection = null;
                this.nonPrivilegedConnection = null;
                BRdbmsUpdateJob.enableDatabaseDescriptors(this.database);
            }
        }
    }

    protected void updateCompleted() {
    }

    private BRdbms[] resolveDatabases(Context cx) {
        BObject[] targetObjects;
        BOrdList dbOrds = this.updater.getDatabaseOrds();
        BatchResolve br = new BatchResolve(dbOrds.toArray()).resolve((BObject)this, cx);
        Array databases = new Array(BRdbms.class);
        for (BObject targetObj : targetObjects = br.getTargetObjects()) {
            databases.add((Object)((BRdbms)targetObj));
        }
        return (BRdbms[])databases.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTables() {
        if (!this.database.getStatus().isValid()) {
            this.log().message("Skipping update for database: " + this.database.getDisplayName(this.cx) + ". Status is " + this.database.getStatus());
            return;
        }
        try {
            for (String table : this.getTableNamesToUpdate()) {
                this.updateTable(table);
            }
        }
        catch (Exception e) {
            this.failed(e);
            try {
                this.log().message("Rolling back changes");
                if (this.nonPrivilegedConnection != null && this.nonPrivilegedConnection != this.privilegedConnection && !this.nonPrivilegedConnection.getAutoCommit()) {
                    this.nonPrivilegedConnection.rollback();
                }
            }
            catch (SQLException nonPrivilegedConnectionRollbackEx) {
                this.log().failed("Failed to rollback changes on nonPrivilegedConnection", (Throwable)nonPrivilegedConnectionRollbackEx);
            }
            finally {
                try {
                    if (this.privilegedConnection != null && this.privilegedConnection != this.nonPrivilegedConnection && !this.privilegedConnection.getAutoCommit()) {
                        this.privilegedConnection.rollback();
                    }
                }
                catch (SQLException privilegedConnectionRollbackEx) {
                    this.log().failed("Failed to rollback changes on privilegedConnection", (Throwable)privilegedConnectionRollbackEx);
                }
            }
        }
    }

    protected abstract String[] getTableNamesToUpdate() throws Exception;

    protected abstract void updateTable(String var1) throws Exception;

    protected static void enableDatabaseDescriptors(BRdbms database) {
        BRdbmsUpdateJob.setDescriptorsEnabledState(database, true);
    }

    protected static void disableDatabaseDescriptors(BRdbms database) {
        BRdbmsUpdateJob.setDescriptorsEnabledState(database, false);
    }

    private static void setDescriptorsEnabledState(BRdbms database, boolean enabled) {
        BDeviceExt[] exts;
        for (BDeviceExt ext : exts = database.getDeviceExts()) {
            BDescriptor[] descriptors;
            if (!(ext instanceof BDescriptorDeviceExt)) continue;
            BDescriptorDeviceExt descriptionDeviceExt = (BDescriptorDeviceExt)ext;
            for (BDescriptor descriptor : descriptors = descriptionDeviceExt.getDescriptors()) {
                descriptor.setEnabled(enabled);
            }
        }
    }

    protected final BRdbms getDatabase() {
        return this.database;
    }

    protected final BRdbmsDeprecatedDialect getRdbmsDialect() {
        if (this.database == null) {
            throw new IllegalStateException("Can not make BRdbmsDialect: Database is null");
        }
        if (this.dialect == null) {
            this.dialect = BRdbmsDeprecatedDialect.make(this.database);
        }
        return this.dialect;
    }

    protected final Connection getPrivilegedConnection() throws SQLException {
        if (this.database == null) {
            throw new IllegalStateException("Can not obtain privileged Connection: Database is null");
        }
        if (this.privilegedConnection == null) {
            try {
                if (this.nonPrivilegedConnection != null && this.database.isPrivilegedConnection(this.nonPrivilegedConnection)) {
                    this.privilegedConnection = this.nonPrivilegedConnection;
                } else {
                    this.privilegedConnection = AccessController.doPrivileged(() -> this.database.getPrivilegedConnection(Context.NULL));
                    this.privilegedConnection.setAutoCommit(false);
                }
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(cause);
            }
        }
        return this.privilegedConnection;
    }

    protected final Connection getNonPrivilegedConnection() throws SQLException {
        if (this.database == null) {
            throw new IllegalStateException("Can not obtain non-privileged Connection: Database is null");
        }
        if (this.nonPrivilegedConnection == null) {
            try {
                if (this.privilegedConnection != null && !this.database.isPrivilegeSeparationEnabled(null)) {
                    this.nonPrivilegedConnection = this.privilegedConnection;
                } else {
                    this.nonPrivilegedConnection = AccessController.doPrivileged(() -> this.database.getNonPrivilegedConnection(Context.NULL));
                    this.nonPrivilegedConnection.setAutoCommit(false);
                }
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(cause);
            }
        }
        return this.nonPrivilegedConnection;
    }
}

