/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.jdbc.NiagaraPoolableConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class NiagaraPooledDataSource
extends BasicDataSource {
    private static final Logger LOG = Logger.getLogger("rdb");
    private final BAbstractConnectionPool managingConnectionPoolInstance;

    public NiagaraPooledDataSource(BAbstractConnectionPool managingConnectionPoolInstance) {
        this.managingConnectionPoolInstance = managingConnectionPoolInstance;
    }

    @Override
    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        NiagaraPoolableConnectionFactory connectionFactory;
        try {
            connectionFactory = new NiagaraPoolableConnectionFactory(driverConnectionFactory);
            connectionFactory.setValidationQuery(this.getValidationQuery());
            connectionFactory.setValidationQueryTimeout(this.getValidationQueryTimeoutDuration());
            connectionFactory.setConnectionInitSql(this.getConnectionInitSqls());
            connectionFactory.setDefaultReadOnly(this.getDefaultReadOnly());
            connectionFactory.setDefaultAutoCommit(this.getDefaultAutoCommit());
            connectionFactory.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
            connectionFactory.setDefaultCatalog(this.getDefaultCatalog());
            connectionFactory.setDefaultSchema(this.getDefaultSchema());
            connectionFactory.setCacheState(this.getCacheState());
            connectionFactory.setPoolStatements(this.isPoolPreparedStatements());
            connectionFactory.setClearStatementPoolOnReturn(this.isClearStatementPoolOnReturn());
            connectionFactory.setMaxOpenPreparedStatements(this.getMaxOpenPreparedStatements());
            connectionFactory.setMaxConn(this.getMaxConnDuration());
            connectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            connectionFactory.setAutoCommitOnReturn(this.getAutoCommitOnReturn());
            connectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeoutDuration());
            connectionFactory.setFastFailValidation(this.getFastFailValidation());
            connectionFactory.setDisconnectionSqlCodes(this.getDisconnectionSqlCodes());
            NiagaraPooledDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create NiagaraPoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }

    private class NiagaraPoolableConnectionFactory
    extends PoolableConnectionFactory {
        private NiagaraPoolableConnectionFactory(ConnectionFactory connFactory) {
            super(connFactory, null);
        }

        @Override
        public PooledObject<PoolableConnection> makeObject() throws SQLException {
            Connection jdbcConnection = this.getConnectionFactory().createConnection();
            if (jdbcConnection == null) {
                throw new IllegalStateException("Connection factory returned null from createConnection");
            }
            try {
                this.initializeConnection(jdbcConnection);
            }
            catch (SQLException sqlException) {
                block6: {
                    try {
                        jdbcConnection.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.log(Level.FINE, "Unable to close JDBC connection in ConnectionPool: " + NiagaraPooledDataSource.this.managingConnectionPoolInstance.getName(), LOG.isLoggable(Level.FINE) ? e : null);
                    }
                }
                throw sqlException;
            }
            if (this.getPoolStatements()) {
                jdbcConnection = new PoolingConnection(jdbcConnection);
                GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
                config.setMaxTotalPerKey(-1);
                config.setBlockWhenExhausted(false);
                config.setMaxWait(Duration.ZERO);
                config.setMaxIdlePerKey(1);
                config.setMaxTotal(this.getMaxOpenPreparedStatements());
                config.setJmxEnabled(false);
                PoolingConnection poolingConn = (PoolingConnection)jdbcConnection;
                GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>(poolingConn, config);
                poolingConn.setStatementPool(stmtPool);
                poolingConn.setClearStatementPoolOnReturn(true);
                poolingConn.setCacheState(this.getCacheState());
            }
            NiagaraPoolableConnection niagaraPoolableConnection = new NiagaraPoolableConnection(jdbcConnection, this.getPool(), NiagaraPooledDataSource.this.managingConnectionPoolInstance);
            niagaraPoolableConnection.setCacheState(this.getCacheState());
            return new DefaultPooledObject<PoolableConnection>(niagaraPoolableConnection);
        }
    }
}

