/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.history;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.history.RdbmsHistoryUtil;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRdbmsMigrateIndexesJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsMigrateIndexesJob.class);
    private static final Logger LOG = Logger.getLogger("rdb");
    private BRdbmsHistoryDeviceExt deviceExt;
    private BRdbms rdbms;
    private BRdbmsDeprecatedDialect dialect;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRdbmsMigrateIndexesJob() {
    }

    public BRdbmsMigrateIndexesJob(BRdbmsHistoryDeviceExt deviceExt) {
        this.deviceExt = deviceExt;
        this.rdbms = (BRdbms)deviceExt.getDevice();
        this.dialect = BRdbmsDeprecatedDialect.make(this.rdbms);
    }

    public BOrd submit(Context cx) {
        BComponent jobService = (BComponent)BJobService.getService();
        BJob[] jobs = (BJob[])jobService.getChildren(BRdbmsMigrateIndexesJob.class);
        if (jobs != null) {
            for (int i = jobs.length - 1; i >= 0; --i) {
                BRdbmsMigrateIndexesJob indexJob = (BRdbmsMigrateIndexesJob)jobs[i];
                if (!indexJob.isAlive() || !indexJob.deviceExt.equals((Object)this.deviceExt)) continue;
                throw new LocalizableRuntimeException("rdb", "rdbmsMigrateIndexesJob.jobAlreadyRunning");
            }
        }
        return super.submit(cx);
    }

    public void run(Context cx) throws Exception {
        if (this.rdbms == null) {
            throw new IllegalStateException("Must submit through the RdbmsHistoryDeviceExt migrate action");
        }
        try (Connection privilegedDatabaseConnection = null;
             Connection nonPrivilegedDatabaseConnection = AccessController.doPrivileged(() -> this.rdbms.getNonPrivilegedConnection(null));){
            this.log().start("rdb", "rdbmsMigrateIndexesJob.jobStart", new String[]{this.deviceExt.toDisplayPathString(cx)});
            String metaTableName = RdbmsHistoryUtil.getMetaTableName(this.rdbms);
            List<RdbmsHistoryUtil.TableNameIdHistory> tableNameAndIds = RdbmsHistoryUtil.getTableNamesFromMetaRecord(nonPrivilegedDatabaseConnection, metaTableName, this.rdbms.getExportMode());
            String size = String.valueOf(tableNameAndIds.size());
            this.log().message("rdb", "rdbmsMigrateIndexesJob.totalTablesForMigration", size);
            int count = 0;
            int failCount = 0;
            for (RdbmsHistoryUtil.TableNameIdHistory tableNameAndId : tableNameAndIds) {
                block30: {
                    if (this.getJobState() == BJobState.canceling) {
                        throw new JobCancelException();
                    }
                    ++count;
                    try {
                        Set<String> indexesToDrop = this.findIndexesToDrop(nonPrivilegedDatabaseConnection, tableNameAndId.tableName);
                        if (!indexesToDrop.isEmpty() || !this.deviceExt.getUseLastTimestamp() || this.deviceExt.getAlwaysCreateIndexForNewTables()) {
                            Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(tableNameAndId.tableId);
                            if (privilegedDatabaseConnection == null || privilegedDatabaseConnection.isClosed()) {
                                privilegedDatabaseConnection = this.rdbms.isPrivilegedConnection(nonPrivilegedDatabaseConnection) ? nonPrivilegedDatabaseConnection : AccessController.doPrivileged(() -> this.rdbms.getPrivilegedConnection(null));
                            }
                            for (String oldIndex : indexesToDrop) {
                                RdbmsHistoryUtil.dropIndex(privilegedDatabaseConnection, this.dialect, tableNameAndId.tableName, oldIndex);
                            }
                            if (RdbmsHistoryUtil.indexAlreadyExists(nonPrivilegedDatabaseConnection, tableNameAndId.tableName, (String)indexNameAndColumns.getFirst())) {
                                this.log().message("rdb", "rdbmsMigrateIndexesJob.tableIndexAlreadyMigrated", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                            } else {
                                RdbmsHistoryUtil.createIndex(privilegedDatabaseConnection, this.dialect, tableNameAndId.tableName, indexNameAndColumns);
                                this.log().message("rdb", "rdbmsMigrateIndexesJob.tableIndexMigrated", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                            }
                        } else {
                            this.log().message("rdb", "rdbmsMigrateIndexesJob.tableNotEligible", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                        }
                    }
                    catch (Exception e) {
                        ++failCount;
                        this.log().failed("rdb", "rdbmsMigrateIndexesJob.failedTableMigration", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                        if (!LOG.isLoggable(Level.WARNING)) break block30;
                        LOG.log(Level.WARNING, "Exception while migrating the index for " + tableNameAndId.historyIdOrRecType, e);
                    }
                }
                this.progress((int)((double)count / (double)tableNameAndIds.size() * 100.0));
            }
            if (failCount > 0) {
                this.log().failed("rdb", "rdbmsMigrateIndexesJob.jobFailed", new String[]{String.valueOf(failCount), size});
                throw new LocalizableRuntimeException("rdb", "rdbmsMigrateIndexesJob.jobFailed", new Object[]{String.valueOf(failCount), size});
            }
        }
    }

    private Set<String> findIndexesToDrop(Connection databaseConnection, String tableName) throws SQLException {
        return !this.rdbms.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId) ? RdbmsHistoryUtil.getOldIndexName(databaseConnection, tableName) : Collections.emptySet();
    }
}

