/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.BEncryptableTransportRdbms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"rdb:RdbmsNetwork"})})
public final class BRdbmsSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsSecurityDashboardProviderAgent.class);
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private SecurityDashboardItemBuilder builder;
    private BRdbmsNetwork network;
    private static final String SECTION_HEADER = "securityDashboard.rdbmsNetwork.sectionHeader";
    private static final String TLS_ENABLED_SUMMARY = "securityDashboard.rdbmsNetwork.tls.enabled.summary";
    private static final String TLS_DISABLED_SUMMARY = "securityDashboard.rdbmsNetwork.tls.disabled.summary";
    private static final String TLS_DESCRIPTION = "securityDashboard.rdbmsNetwork.tls.description";
    private static final String TLS_PROTOCOL_DEPRECATED_SUMMARY = "securityDashboard.rdbmsNetwork.tlsProtocol.deprecated.summary";
    private static final String TLS_PROTOCOL_RECOMMENDED_SUMMARY = "securityDashboard.rdbmsNetwork.tlsProtocol.recommended.summary";
    private static final String TLS_PROTOCOL_DESC = "securityDashboard.rdbmsNetwork.tlsProtocol.description";
    private static final String NON_PRIVILEGED_ENABLED_SUMMARY = "securityDashboard.rdbmsNetwork.nonPrivilegedConnection.enabled.summary";
    private static final String NON_PRIVILEGED_DISABLED_SUMMARY = "securityDashboard.rdbmsNetwork.nonPrivilegedConnection.disabled.summary";
    private static final String NON_PRIVILEGED_DESCRIPTION = "securityDashboard.rdbmsNetwork.nonPrivilegedConnection.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.network = (BRdbmsNetwork)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.network.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        return Collections.unmodifiableList(this.doGetSecurityDashboardItems(cx));
    }

    private List<SecurityDashboardItem> doGetSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List children = this.network.getBDeviceList();
        ArrayList<String> dbEnabledNames = new ArrayList<String>();
        ArrayList<String> dbDisabledNames = new ArrayList<String>();
        ArrayList<String> dbsUsingDeprecatedTls = new ArrayList<String>();
        ArrayList<String> dbsUsingRecommendedTls = new ArrayList<String>();
        ArrayList<String> nonPrivilegedEnabledNames = new ArrayList<String>();
        ArrayList<String> nonPrivilegedDisabledNames = new ArrayList<String>();
        for (BDevice child : children) {
            BValue enabled;
            BValue nonPrivilegedConnectionPool;
            BRdbms device = (BRdbms)child;
            if (device.getUseEncryptedConnection()) {
                dbEnabledNames.add(device.getDisplayName(cx));
                if (device instanceof BEncryptableTransportRdbms) {
                    if (BSslTlsEnum.tlsv1_2.compareTo((Object)((BEncryptableTransportRdbms)device).getTlsMinProtocol()) <= 0) {
                        dbsUsingRecommendedTls.add(device.getDisplayName(cx));
                    } else {
                        dbsUsingDeprecatedTls.add(device.getDisplayName(cx));
                    }
                }
            } else {
                dbDisabledNames.add(device.getDisplayName(cx));
            }
            if (!((nonPrivilegedConnectionPool = device.get("nonPrivilegedConnectionPool")) instanceof BComplex) || !((enabled = ((BComplex)nonPrivilegedConnectionPool).get("enabled")) instanceof BBoolean)) continue;
            if (BBoolean.TRUE == enabled) {
                nonPrivilegedEnabledNames.add(device.getDisplayName(cx));
                continue;
            }
            nonPrivilegedDisabledNames.add(device.getDisplayName(cx));
        }
        if (!dbEnabledNames.isEmpty()) {
            items.add(this.builder.makeOk().withSummary(TLS_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbEnabledNames)}).withDescription(TLS_DESCRIPTION, new Object[0]));
        }
        if (!dbDisabledNames.isEmpty()) {
            items.add(this.builder.makeAlert().withSummary(TLS_DISABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbDisabledNames)}).withDescription(TLS_DESCRIPTION, new Object[0]));
        }
        if (!dbsUsingDeprecatedTls.isEmpty()) {
            items.add(this.builder.makeAlert().withSummary(TLS_PROTOCOL_DEPRECATED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbsUsingDeprecatedTls)}).withDescription(TLS_PROTOCOL_DESC, new Object[0]));
        }
        if (!dbsUsingRecommendedTls.isEmpty()) {
            items.add(this.builder.makeOk().withSummary(TLS_PROTOCOL_RECOMMENDED_SUMMARY, new Object[]{String.join((CharSequence)", ", dbsUsingRecommendedTls)}).withDescription(TLS_PROTOCOL_DESC, new Object[0]));
        }
        if (!nonPrivilegedEnabledNames.isEmpty()) {
            items.add(this.builder.makeOk().withSummary(NON_PRIVILEGED_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", nonPrivilegedEnabledNames)}).withDescription(NON_PRIVILEGED_DESCRIPTION, new Object[0]));
        }
        if (!nonPrivilegedDisabledNames.isEmpty()) {
            items.add(this.builder.makeWarning().withSummary(NON_PRIVILEGED_DISABLED_SUMMARY, new Object[]{String.join((CharSequence)", ", nonPrivilegedDisabledNames)}).withDescription(NON_PRIVILEGED_DESCRIPTION, new Object[0]));
        }
        return items;
    }
}

