/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.BRdbmsDiscoveredTable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRdbmsDiscoverTablesJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsDiscoverTablesJob.class);
    private static final BIcon icon = BIcon.std((String)"find.png");
    private static final String[] typeFilter = new String[]{"TABLE"};
    BRdbmsHistoryDeviceExt histDevExt;
    boolean discoverCanceled;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRdbmsDiscoverTablesJob(BRdbmsHistoryDeviceExt histDevExt) {
        this.histDevExt = histDevExt;
    }

    public BRdbmsDiscoverTablesJob() {
    }

    public void doCancel(Context cx) {
        this.discoverCanceled = true;
        super.doCancel(cx);
    }

    public void run(Context cx) throws Exception {
        if (this.histDevExt == null) {
            throw new IllegalStateException("Must submit through RdbmsHistoryDeviceExt.submitRdbTableDiscoveryJob()");
        }
        if (this.discoverCanceled) {
            throw new JobCancelException();
        }
        this.progress(0);
        this.log().start("Rdb Table Discovery");
        this.removeAll();
        BRdbms db = (BRdbms)this.histDevExt.getDevice();
        BRdbmsDeprecatedDialect dialect = BRdbmsDeprecatedDialect.make(db);
        try (Connection conn = AccessController.doPrivileged(() -> db.getNonPrivilegedConnection(null));){
            DatabaseMetaData metaData = conn.getMetaData();
            this.log().message("  Finding catalogs/schemas...");
            List<String> searchList = dialect.getCatalogs(metaData);
            if (this.discoverCanceled) {
                throw new JobCancelException();
            }
            this.progress(10);
            int numCatalogs = searchList.size();
            this.log().message("  Found " + numCatalogs + " total catalogs.");
            this.log().message("  Finding tables in each catalog...");
            ArrayList<String> tableNameList = new ArrayList<String>();
            ArrayList<String> catalogNameList = new ArrayList<String>();
            ArrayList<String> schemaNameList = new ArrayList<String>();
            for (int i = 0; i < numCatalogs; ++i) {
                this.progress((int)((float)i / (float)numCatalogs * 20.0f) + 10);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String catalog = searchList.get(i);
                try (ResultSet resultSet = dialect.getTables(metaData, catalog, typeFilter);){
                    while (resultSet.next()) {
                        if (this.discoverCanceled) {
                            throw new JobCancelException();
                        }
                        String tableCatalog = resultSet.getString("TABLE_CAT");
                        if (catalog.isEmpty() && tableCatalog != null) continue;
                        tableNameList.add(resultSet.getString("TABLE_NAME"));
                        catalogNameList.add(tableCatalog);
                        schemaNameList.add(resultSet.getString("TABLE_SCHEM"));
                    }
                    continue;
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding tables for database catalog \"" + catalog + "\"", (Throwable)e);
                }
            }
            this.progress(30);
            int numTables = tableNameList.size();
            this.log().message("  Found " + numTables + " total tables.");
            this.log().message("  Finding columns for each table...");
            for (int i = 0; i < numTables; ++i) {
                this.progress((int)((float)i / (float)numTables * 70.0f) + 30);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String tableName = (String)tableNameList.get(i);
                if (tableName == null) continue;
                BRdbmsDiscoveredTable discovery = new BRdbmsDiscoveredTable(tableName);
                String catalog = (String)catalogNameList.get(i);
                boolean nonNullCatalog = catalog instanceof String;
                discovery.setCatalogName(nonNullCatalog ? catalog : "");
                String schema = (String)schemaNameList.get(i);
                boolean nonNullSchema = schema instanceof String;
                discovery.setSchemaName(nonNullSchema ? schema : "");
                ArrayList<String> columnList = new ArrayList<String>();
                try (ResultSet rs = metaData.getColumns(nonNullCatalog ? catalog : null, nonNullSchema ? schema : null, tableName, null);){
                    while (rs.next()) {
                        if (this.discoverCanceled) {
                            throw new JobCancelException();
                        }
                        columnList.add(rs.getString("COLUMN_NAME"));
                    }
                }
                catch (SQLException e) {
                    this.log().failed("    Encountered problem finding columns for table " + tableName + " (catalog=" + (nonNullCatalog ? catalog : "null") + ", schema=" + (nonNullSchema ? schema : "null") + ')', (Throwable)e);
                    continue;
                }
                int numColumns = columnList.size();
                if (numColumns > 0) {
                    String[] colEnumTags = (String[])columnList.stream().distinct().map(SlotPath::escape).toArray(String[]::new);
                    try {
                        BEnumRange range = BEnumRange.make((String[])colEnumTags);
                        discovery.setTimestampColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                        discovery.setValueColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                        discovery.setStatusColumn(BDynamicEnum.make((int)0, (BEnumRange)range));
                    }
                    catch (Exception e) {
                        this.log().failed("    Error creating range from columns for table " + tableName, (Throwable)e);
                    }
                }
                this.add("s" + i, (BValue)discovery, 1);
            }
            this.progress(100);
            this.log().message("  Finished finding columns for each table.");
            this.log().success("Rdb Table Discovery complete (" + numTables + " tables found).");
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

