/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.ui;

import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import com.lynxspring.onyxxwallmodule.ui.BOnyxxWallModMacDialog;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import com.tridium.workbench.propsheet.BPropertySheet;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.BTitlePane;

@NiagaraType(agent={@AgentOn(types={"onyxxwallmodule:OnyxxWallModService"}, defaultAgent=AgentOn.Preference.NORMAL)})
public class BOnyxxWallModuleProperty
extends BPropertySheet {
    public static final Type TYPE = Sys.loadType(BOnyxxWallModuleProperty.class);
    BOnyxxWallModService target;
    BFieldEditorSheet sheet;

    public Type getType() {
        return TYPE;
    }

    public void build() {
        super.build();
        BWidget cn = this.getContent();
        BTitlePane tp = (BTitlePane)cn;
        BEdgePane edge = (BEdgePane)tp.getContent();
        tp.setTitle("Onyxx Wall Module Service");
        BWidget w = edge.getBottom();
        if (w instanceof BGridPane) {
            BGridPane origButs = (BGridPane)w;
            BGridPane buttons = new BGridPane(4);
            buttons.setColumnAlign(BHalign.fill);
            buttons.setUniformColumnWidth(true);
            BWidget[] existing = origButs.getChildWidgets();
            origButs.removeAll();
            BButton b = new BButton((Command)new AddWallMod((BWidget)this), true, false);
            buttons.add((String)null, (BValue)b);
            BButton b2 = new BButton((Command)new RefreshWallModMacs((BWidget)this), true, false);
            buttons.add((String)null, (BValue)b2);
            buttons.add((String)null, (BValue)existing[0]);
            buttons.add((String)null, (BValue)existing[1]);
            edge.setBottom((BWidget)buttons);
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        this.target = (BOnyxxWallModService)value;
        super.doLoadValue(value, cx);
    }

    class RefreshWallModMacs
    extends Command {
        BWidget par_owner;

        RefreshWallModMacs(BWidget owner) {
            super(owner, "Refresh MAC");
            this.par_owner = null;
            this.par_owner = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            String wmSrv = "station:|slot:/Services/WallModuleService";
            BOnyxxWallModService os = (BOnyxxWallModService)BOrd.make((String)wmSrv).resolve((BObject)BOnyxxWallModuleProperty.this.target).get();
            os.invoke(BOnyxxWallModService.refreshUnassignedMAC, null);
            BDialog.info((BWidget)this.par_owner, (Object)"Refresh unassigned MAC complete.");
            CommandArtifact artifact = null;
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }
    }

    class AddWallMod
    extends Command {
        BString selectedDevId;
        BWidget par_owner;

        AddWallMod(BWidget owner) {
            super(owner, "Add Wall Module");
            this.selectedDevId = BString.DEFAULT;
            this.par_owner = null;
            this.par_owner = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            CommandArtifact artifact = null;
            String wmSrv = "station:|slot:/Services/WallModuleService";
            BOnyxxWallModService os = (BOnyxxWallModService)BOrd.make((String)wmSrv).resolve((BObject)BOnyxxWallModuleProperty.this.target).get();
            BString unassigned = (BString)os.invoke(BOnyxxWallModService.refreshUnassignedMAC, null);
            if (unassigned.getString() == "") {
                String initVal = "<Wall Module MAC>";
                String nme = BOnyxxWallModMacDialog.prompt(this.par_owner, "Enter or select un-assigned Wall Module MAC: ", initVal, 6, os.getUnassignedMAC());
                if (nme != null) {
                    boolean flag = nme.matches(".*[a-zA-Z]+.*");
                    if (nme.length() == 6 && !flag) {
                        this.selectedDevId = BString.make((String)nme);
                        artifact = this.doAddWallMod();
                    } else {
                        BDialog.info((BWidget)this.par_owner, (Object)"Wall Module MAC entry is invalid. [6 character numeric only]");
                    }
                }
            } else {
                os.invoke(BOnyxxWallModService.addWallModule, (BValue)unassigned);
            }
            return artifact;
        }

        public Command doMerge(Command c) {
            return this;
        }

        public CommandArtifact doAddWallMod() throws Exception {
            String wmSrv = "station:|slot:/Services/WallModuleService";
            BOnyxxWallModService os = (BOnyxxWallModService)BOrd.make((String)wmSrv).resolve((BObject)BOnyxxWallModuleProperty.this.target).get();
            os.invoke(BOnyxxWallModService.addWallModule, (BValue)this.selectedDevId);
            return null;
        }
    }
}

