/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.ui;

import com.lynxspring.onyxxwallmodule.property.wallmodule.BWallModHumidity;
import com.lynxspring.onyxxwallmodule.property.wallmodule.BWallModRoomTemp;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"onyxxwallmodule:OnyxxWallModService"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BOnyxxWallModuleManager
extends BWbComponentView {
    BOnyxxWallModService wmService;
    private BTable table;
    private BIRandomAccessTable<? extends BIObject> itable;
    private CollectionTableModel collectionModel;
    private static final String[] ATTRS = new String[]{"toPathString", "name", "status", "enable", "devicePath", "versioning.wallModuleVersion", "Monitoring.roomTemp", "Monitoring.humidity"};
    private static final int[] DISPLAY = new int[]{1, 2, 3, 4, 5, 6, 7};
    private static Lexicon lex = Lexicon.make((String)"onyxxwallmodule");
    public static final Action updateCommands = BOnyxxWallModuleManager.newAction((int)1, (BFacets)null);
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BJob job;
    private boolean jobComplete;
    private boolean registerComplete = false;
    public static final Type TYPE = Sys.loadType(BOnyxxWallModuleManager.class);

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public BOnyxxWallModuleManager() {
        BEdgePane content = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.topPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        content.setTop((BWidget)this.topPane);
        this.topPane.setVisible(false);
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        content.setCenter((BWidget)BTitlePane.makePane((String)"Onyxx Wall Modules", (BTable)this.table, (String)""));
        this.setContent((BWidget)content);
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"Path");
        this.nameMap.put(1, (Object)"Name");
        this.nameMap.put(2, (Object)"Status");
        this.nameMap.put(3, (Object)"Enable");
        this.nameMap.put(4, (Object)"Device");
        this.nameMap.put(5, (Object)"Version");
        this.nameMap.put(6, (Object)"RoomTemp");
        this.nameMap.put(7, (Object)"Humidity");
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.wmService = (BOnyxxWallModService)value;
        this.updateTable();
        this.table.fireTableModified((BWidgetEvent)null);
    }

    private void updateTable() {
        BOrd bqlOrd = BOrd.make((BOrd)this.wmService.getNavOrd(), (String)this.query()).normalize();
        this.itable = Tables.slurp((BITable)((BITable)bqlOrd.resolve().get()));
        boolean prevSorted = false;
        int sortCol = -1;
        boolean sortAsc = true;
        if (this.table.getModel() instanceof WallModTableModel) {
            prevSorted = true;
            sortCol = ((WallModTableModel)this.table.getModel()).sortCol;
            sortAsc = ((WallModTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        WallModTableModel hideModel = new WallModTableModel((TableModel)renameModel, DISPLAY);
        hideModel.setColumnShowable(0, false);
        if (prevSorted && sortCol != -1) {
            hideModel.sortByColumn(sortCol, sortAsc);
        }
        if (!this.registerComplete) {
            this.registerComplete = true;
            int rowCount = this.itable.size();
            for (int i = 0; i < rowCount; ++i) {
                BOnyxxWallModule c = this.getWallModForRow(i);
                c.lease(3);
                this.registerForComponentEvents((BComponent)c, 0);
                this.registerForComponentEvents((BComponent)c.getMonitoring().getRoomTemp(), 0);
                this.registerForComponentEvents((BComponent)c.getMonitoring().getHumidity(), 0);
            }
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
    }

    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        if (event.getSourceComponent() instanceof BOnyxxWallModule) {
            if ((event.getSlotName().matches("status") || event.getSlotName().matches("enable")) && event.toString(null).startsWith("property_changed")) {
                try {
                    this.doLoadValue((BObject)this.wmService, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (event.getSourceComponent() instanceof BWallModRoomTemp || event.getSourceComponent() instanceof BWallModHumidity) {
            if (event.getSlotName().matches("out") && event.toString(null).startsWith("property_changed")) {
                try {
                    this.doLoadValue((BObject)this.wmService, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (event.getSourceComponent() instanceof BOnyxxWallModService && (event.getSlotName().matches("enable") || event.getSlotName().matches("refreshManager")) && event.toString(null).startsWith("property_changed")) {
            try {
                this.doLoadValue((BObject)this.wmService, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String query() {
        StringBuffer s = new StringBuffer(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from onyxxwallmodule:OnyxxWallModule");
        return s.toString();
    }

    public void doUpdateCommands() {
    }

    public BOnyxxWallModule getWallModForRow(int rowIndex) {
        String path = this.collectionModel.getValueAt(rowIndex, 1).toString();
        BOrd targetOrd = BOrd.make((BOrd)this.wmService.getNavOrd(), (String)("slot:" + path)).normalize();
        return (BOnyxxWallModule)targetOrd.resolve().get();
    }

    public Type getType() {
        return TYPE;
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            ColumnList columns = BOnyxxWallModuleManager.this.itable.getColumns();
            BOrd targetOrd = null;
            String path = BOnyxxWallModuleManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            if (targetOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(targetOrd);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            ColumnList columns = BOnyxxWallModuleManager.this.itable.getColumns();
            String path = BOnyxxWallModuleManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            menu.add((String)null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeViewsMenu((BWidget)this.getTable(), (BObject)target)));
            menu.add((String)null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)target)));
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIDataTable<? extends BIObject> lastTable = null;
        int stateOrdCol = -1;

        private CellRenderer() {
        }

        BStatus getStatusFromString(String s) {
            BStatus ret = BStatus.ok;
            if (s.contains("fault")) {
                ret = BStatus.fault;
            } else if (s.contains("disabled")) {
                ret = BStatus.disabled;
            } else if (s.contains("down")) {
                ret = BStatus.down;
            }
            return ret;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BStatus stateOrd = this.getStatusFromString(((WrapperTableModel)BOnyxxWallModuleManager.this.table.getModel()).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
            return stateOrd == BStatus.ok ? super.getForeground(cell) : BColor.white.toBrush();
        }

        protected void paintCellBackground(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.selected) {
                super.paintCellBackground(g, cell);
            } else {
                try {
                    ColumnList columns = BOnyxxWallModuleManager.this.itable.getColumns();
                    if (BOnyxxWallModuleManager.this.itable != this.lastTable || this.stateOrdCol == -1) {
                        this.stateOrdCol = columns.indexOf("status");
                    }
                    BColor bg = null;
                    BColor fg = null;
                    TableModel tModel = BOnyxxWallModuleManager.this.table.getModel();
                    if (!(tModel instanceof WrapperTableModel)) {
                        super.paintCellBackground(g, cell);
                        return;
                    }
                    BStatus stateOrd = this.getStatusFromString(((WrapperTableModel)tModel).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
                    if (stateOrd != BStatus.ok) {
                        if (stateOrd == BStatus.fault) {
                            bg = (BColor)BStatus.faultBg;
                            fg = (BColor)BStatus.faultFg;
                        } else if (stateOrd == BStatus.disabled) {
                            bg = (BColor)BStatus.disabledBg;
                            fg = (BColor)BStatus.disabledFg;
                        } else {
                            bg = (BColor)BStatus.downBg;
                            fg = (BColor)BStatus.downFg;
                        }
                    }
                    if (bg != null) {
                        g.setBrush(bg);
                        g.fillRect(0.0, 0.0, cell.width, cell.height);
                        g.setBrush(fg);
                    } else {
                        g.setBrush(Theme.table().getTextBrush());
                    }
                    g.setFont(Theme.table().getCellFont());
                }
                catch (ClassCastException | NullPointerException var8) {
                    super.paintCellBackground(g, cell);
                }
            }
        }
    }

    public class WallModTableModel
    extends DynamicTableModel {
        public int sortCol;
        public boolean sortAsc;

        public WallModTableModel(TableModel root, int[] showColumns) {
            super(root, showColumns);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public WallModTableModel(TableModel root) {
            super(root);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.sortCol = col;
            this.sortAsc = ascending;
            super.sortByColumn(col, ascending);
        }

        public Object getValueAt(int row, int col) {
            Object value = super.getValueAt(row, col);
            if (value instanceof String) {
                value = SlotPath.unescape((String)((String)value));
            }
            return value;
        }
    }
}

