/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.util;

import com.tridium.exporttags.util.ExportTagException;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;

public final class OrdVariableProcessor {
    private Array<IVarHandler> procArray = new Array(IVarHandler.class);

    public OrdVariableProcessor() {
    }

    public OrdVariableProcessor(IVarHandler handler) {
        this.add(handler);
    }

    public OrdVariableProcessor(IVarHandler[] handlers) {
        for (int i = 0; i < handlers.length; ++i) {
            this.add(handlers[i]);
        }
    }

    public void add(IVarHandler h) {
        this.procArray.add((Object)h);
    }

    public BOrd process(BOrd ord) throws Exception {
        if (ord.isNull()) {
            return ord;
        }
        String[] vars = ord.getVariables();
        if (vars.length == 0) {
            return ord;
        }
        IVarHandler[] procs = (IVarHandler[])this.procArray.trim();
        BFacets varMap = BFacets.DEFAULT;
        for (int i = 0; i < vars.length; ++i) {
            for (int j = 0; j < procs.length; ++j) {
                if (!procs[j].accept(vars[i])) continue;
                varMap = BFacets.make((BFacets)varMap, (BFacets)procs[j].get());
            }
        }
        if (varMap != BFacets.DEFAULT) {
            ord = ord.substitute(varMap);
        }
        if (ord.getVariables().length > 0) {
            throw new ExportTagException("unprocessedOrdVars", ord.toString());
        }
        return ord;
    }

    public static final class Replace
    implements IVarHandler {
        private String[] keys;
        private String[] vals;
        private String selKey = "";
        private String selVal = "";

        public Replace(String key, String val) {
            this.keys = new String[]{key};
            this.vals = new String[]{val};
        }

        public Replace(String[] keys, String[] vals) {
            this.keys = keys;
            this.vals = vals;
        }

        @Override
        public boolean accept(String var) {
            if (var == null) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!var.equals(this.keys[i])) continue;
                this.selKey = this.keys[i];
                this.selVal = this.vals[i];
                return true;
            }
            return false;
        }

        @Override
        public BFacets get() {
            return BFacets.make((String)this.selKey, (String)this.selVal);
        }
    }

    public static interface IVarHandler {
        public BFacets get();

        public boolean accept(String var1);
    }
}

