/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.exporttags.util.BSimplePairList;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.ExportTagUtil;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameList;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="supervisorStation", type="BNameList", defaultValue="BNameList.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:MultiStationNamePickerFE\"")}), @NiagaraProperty(name="stationSlotPath", type="BOrd", defaultValue="BOrd.make(\"slot:\")", facets={@Facet(value="makeStationSlotPathFacets()")})})
public abstract class BNiagaraExportTag
extends BComponent
implements BIStatus {
    @Generated
    public static final Property status = BNiagaraExportTag.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property enabled = BNiagaraExportTag.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property supervisorStation = BNiagaraExportTag.newProperty((int)0, (BValue)BNameList.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:MultiStationNamePickerFE"));
    @Generated
    public static final Property stationSlotPath = BNiagaraExportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BNiagaraExportTag.makeStationSlotPathFacets());
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraExportTag.class);
    private Array<TargetInfo> targets;
    private BComponent targetParent;
    public static final String targetNameList = "targetSlotInfoList";
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"sync.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private static final Type[] deviceFolderIncludeTypes = new Type[]{BFolder.TYPE};
    private static final Type[] networkFolderIncludeTypes = new Type[]{BFolder.TYPE, BDevice.TYPE, BDeviceExt.TYPE};

    protected static final BFacets makeStationSlotPathFacets() {
        return BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"exportTags:StationCompSelFE"));
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BNameList getSupervisorStation() {
        return (BNameList)this.get(supervisorStation);
    }

    @Generated
    public void setSupervisorStation(BNameList v) {
        this.set(supervisorStation, (BValue)v, null);
    }

    @Generated
    public BOrd getStationSlotPath() {
        return (BOrd)this.get(stationSlotPath);
    }

    @Generated
    public void setStationSlotPath(BOrd v) {
        this.set(stationSlotPath, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a, (Context)b);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.updateStatus();
    }

    private void fwChanged(Property prop, Context cx) {
        if (this.isRunning() && prop == enabled) {
            this.updateStatus();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (this.isMounted() && slot.getName().equals(stationSlotPath.getName())) {
            return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)this.getHandleOrd().toString()));
        }
        return super.getSlotFacets(slot);
    }

    private void updateStatus() {
        this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (!this.getEnabled() ? 1 : 0) != 0));
    }

    private BComponent resolveStationSlotPath(BINiagaraStation station, BJob job, Context cx) throws Exception {
        BComponent stationComp = (BComponent)station;
        BOrd stationSlotPathOrd = this.getStationSlotPath();
        Type folderType = this.getFolderType();
        if (folderType != null) {
            String formatStr = BFormat.format((String)stationSlotPathOrd.toString(), (Object)((Object)this));
            if (formatStr.toLowerCase().indexOf("%err:") > -1) {
                throw new ExportTagException("expTag.couldNotFormatStationSlotPath", new String[]{formatStr, this.toPathString()});
            }
            stationSlotPathOrd = BOrd.make((String)ExportTagUtil.filterInvalidSlashesFromPath(formatStr));
            ExportTagUtil.createFolderPath(stationComp, this, stationSlotPathOrd, folderType, cx);
        } else {
            stationSlotPathOrd = BOrd.make((String)ExportTagUtil.filterInvalidSlashesFromPath(stationSlotPathOrd.toString()));
        }
        OrdQuery[] queries = stationSlotPathOrd.parse();
        if (queries.length != 1) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{stationSlotPathOrd.toString(), this.toPathString()});
        }
        if (!(queries[0] instanceof SlotPath)) {
            throw new ExportTagException("expTag.shouldUseSlot", new String[]{stationSlotPathOrd.toString(), this.toPathString()});
        }
        BComponent resolvedComp = (BComponent)stationSlotPathOrd.get((BObject)stationComp);
        job.log().message(TYPE.getModule().getModuleName(), "expTag.resolvedStationSlotPath", new String[]{stationSlotPathOrd.toString(), this.toPathString()});
        return resolvedComp;
    }

    protected Type getFolderType() {
        return null;
    }

    final long preJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        this.targets = new Array(TargetInfo.class);
        try {
            this.targetParent = this.resolveStationSlotPath(station, job, cx);
        }
        catch (ExportTagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExportTagException("expTag.noStationSlotPath", new String[]{this.getStationSlotPath().toString(), this.toPathString()}, (Throwable)e);
        }
        long t1 = Clock.ticks();
        this.doPreJoin(station, job, sub, mask, cx);
        return Clock.ticks() - t1;
    }

    protected void doPreJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
    }

    final long join(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        long t1 = Clock.ticks();
        this.doJoin(station, job, sub, mask, cx);
        return Clock.ticks() - t1;
    }

    protected abstract void doJoin(BINiagaraStation var1, BJob var2, Subscriber var3, BCategoryMask var4, Context var5) throws Exception;

    final long postJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        long t1 = Clock.ticks();
        this.doPostJoin(station, job, sub, mask, cx);
        return Clock.ticks() - t1;
    }

    protected void doPostJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
    }

    protected final BComponent getTargetParent() {
        return this.targetParent;
    }

    protected final void addTarget(String name, BComplex clx, Context cx) {
        if (this.targetParent.get(name) == null) {
            this.targetParent.add(name, (BValue)clx, cx);
        }
        this.registerTarget(clx);
    }

    protected final void addTarget(String name, BComplex clx, int flags, Context cx) {
        if (this.targetParent.get(name) == null) {
            this.targetParent.add(name, (BValue)clx, flags, cx);
        } else {
            int oldFlags;
            Property prop = clx.getPropertyInParent();
            if (prop != null && (oldFlags = this.targetParent.getFlags((Slot)prop)) != flags) {
                this.targetParent.setFlags((Slot)prop, flags);
            }
        }
        this.registerTarget(clx);
    }

    protected final void addTarget(BComponent newTargetParent, String name, BComplex clx, Context cx) {
        if (newTargetParent.get(name) == null) {
            newTargetParent.add(name, (BValue)clx, cx);
        }
        this.registerTarget(newTargetParent, clx);
    }

    protected final void addTarget(BComponent newTargetParent, String name, BComplex clx, int flags, Context cx) {
        if (newTargetParent.get(name) == null) {
            newTargetParent.add(name, (BValue)clx, flags, cx);
        } else {
            int oldFlags;
            Property prop = clx.getPropertyInParent();
            if (prop != null && (oldFlags = this.targetParent.getFlags((Slot)prop)) != flags) {
                this.targetParent.setFlags((Slot)prop, flags);
            }
        }
        this.registerTarget(newTargetParent, clx);
    }

    protected final void registerTarget(BComplex clx) {
        this.registerTarget(this.targetParent, clx);
    }

    protected final void unregisterTarget(BComplex clx) {
        this.unregisterTarget(this.targetParent, clx);
    }

    protected final void registerTarget(BComponent newTargetParent, BComplex clx) {
        String slotName = clx.getName();
        TargetInfo targetInfo = TargetInfo.make(newTargetParent, slotName, BTypeSpec.make((Type)this.getType()));
        BSimplePairList list = (BSimplePairList)newTargetParent.get(targetNameList);
        BSimplePairList newList = BSimplePairList.make((BSimple)BString.make((String)slotName), (BSimple)BTypeSpec.make((Type)this.getType()));
        if (list == null) {
            newTargetParent.add(targetNameList, (BValue)newList, 69);
        } else {
            newTargetParent.set(targetNameList, (BValue)BSimplePairList.union(list, newList));
        }
        this.targets.add((Object)targetInfo);
    }

    protected final void unregisterTarget(BComponent newTargetParent, BComplex clx) {
        this.targets.remove((Object)TargetInfo.make(newTargetParent, clx.getName(), BTypeSpec.make((Type)this.getType())));
    }

    TargetInfo[] getRegisteredTargetInfos() {
        return (TargetInfo[])this.targets.trim();
    }

    protected static final String getUniqueName(BComponent newTargetParent, String name) {
        return ((ComponentSlotMap)newTargetParent.fw(1)).generateUniqueSlotName(name);
    }

    protected static final void updateTargetDisplayName(BComponent newTargetParent, String name, BComplex clx) {
        BNameMap targetMap;
        BComponent parentComp = (BComponent)clx.getParent();
        BNameMap map = (BNameMap)parentComp.get("displayNames");
        BFormat displayName = null;
        if (map != null) {
            displayName = map.get(clx.getName());
        }
        if ((targetMap = (BNameMap)newTargetParent.get("displayNames")) != null) {
            targetMap = displayName != null ? BNameMap.make((BNameMap)targetMap, (String)name, (BFormat)displayName) : BNameMap.remove((BNameMap)targetMap, (String)name);
            if (targetMap.isNull()) {
                newTargetParent.remove("displayNames");
            } else {
                newTargetParent.set("displayNames", (BValue)targetMap);
            }
        } else if (displayName != null) {
            newTargetParent.add("displayNames", (BValue)BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)name, (BFormat)displayName), 261);
        }
    }

    public static BBoolean hasSupervisorStation(BObject target, BString arg) {
        BNiagaraExportTag tag = (BNiagaraExportTag)target;
        String[] names = tag.getSupervisorStation().getNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(arg.getString())) continue;
            return BBoolean.TRUE;
        }
        return BBoolean.FALSE;
    }

    public String getDeviceFolderPath() {
        return this.getFolderPath(BDevice.TYPE, deviceFolderIncludeTypes);
    }

    public String getNetworkFolderPath() {
        return this.getFolderPath(BDeviceNetwork.TYPE, networkFolderIncludeTypes);
    }

    private String getFolderPath(Type endType, Type[] includeTypes) {
        Array pathArray = new Array(String.class);
        if (this.createFolderPathToComp((BComponent)this.getParent(), (Array<String>)pathArray, endType, includeTypes)) {
            return TextUtil.join((String[])((String[])pathArray.reverse().trim()), (char)'/');
        }
        return "";
    }

    private boolean createFolderPathToComp(BComponent comp, Array<String> pathArray, Type endType, Type[] includeTypes) {
        if (comp == null) {
            return false;
        }
        Type t = comp.getType();
        if (t.is(endType)) {
            return true;
        }
        for (int i = 0; i < includeTypes.length; ++i) {
            if (!t.is(includeTypes[i])) continue;
            pathArray.add((Object)comp.getName());
            break;
        }
        return this.createFolderPathToComp((BComponent)comp.getParent(), pathArray, endType, includeTypes);
    }

    static class TargetInfo {
        private BComponent targetComp;
        private String name;
        private BTypeSpec typeSpec;
        private int hashCode = -1;

        TargetInfo() {
        }

        static TargetInfo make(BComponent targetComp, String name, BTypeSpec type) {
            TargetInfo info = new TargetInfo();
            info.targetComp = targetComp;
            info.name = name;
            info.typeSpec = type;
            return info;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TargetInfo)) {
                return false;
            }
            TargetInfo inf = (TargetInfo)obj;
            if (!inf.targetComp.getSlotPathOrd().equals((Object)this.targetComp.getSlotPathOrd())) {
                return false;
            }
            if (!inf.name.equals(this.name)) {
                return false;
            }
            return inf.typeSpec.equals((Object)this.typeSpec);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = new String(this.targetComp.getSlotPathOrd().toString() + this.name + this.typeSpec.getTypeInfo().toString()).hashCode();
            }
            return this.hashCode;
        }

        String toPathString() {
            return this.targetComp.toPathString() + "/" + this.name;
        }

        BComponent getTargetComp() {
            return this.targetComp;
        }

        String getName() {
            return this.name;
        }

        BTypeSpec getTypeSpec() {
            return this.typeSpec;
        }
    }
}

