/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.exporttags.BSubordinateExportTagNetworkExt;
import com.tridium.exporttags.BSubordinateJoinJob;
import com.tridium.exporttags.util.BJoinInfo;
import com.tridium.exporttags.util.BStationInformation;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.ExportTagUtil;
import com.tridium.exporttags.util.OrdVariableProcessor;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.nd.BNiagaraStation;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="lastJoin", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="stationDisplayName", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="defaultUser", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:UserNamePickerFE\"")}), @NiagaraProperty(name="defaultUserPassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="defaultIpAddress", type="BFormat", defaultValue="BFormat.DEFAULT"), @NiagaraProperty(name="defaultPort", type="BFormat", defaultValue="BFormat.make(\"%foxService.foxPort.publicServerPort%\")"), @NiagaraProperty(name="defaultUseFoxs", type="boolean", defaultValue="false"), @NiagaraProperty(name="defaultFoxsPort", type="BFormat", defaultValue="BFormat.make(\"%foxService.foxsPort.publicServerPort%\")"), @NiagaraProperty(name="defaultFoxOverWebsocket", type="BFoxClientWebsocketBehavior", defaultValue="BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails", flags=4), @NiagaraProperty(name="defaultFoxOverWebsocketPort", type="BFormat", defaultValue="BFormat.make(\"%webService.httpsPort.publicServerPort%\")", flags=4), @NiagaraProperty(name="stationFile", type="BOrd", defaultValue="BOrd.make(\"file:^joinProfiles$(defaultStationFileName).bog\")", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:OrdVariableFE\""), @Facet(value="BFacets.make(\"showLink\", BBoolean.TRUE)")}), @NiagaraProperty(name="stationInfo", type="BStationInformation", defaultValue="new BStationInformation()")})
@NiagaraActions(value={@NiagaraAction(name="join", returnType="BOrd", flags=8), @NiagaraAction(name="joinCompleted", flags=4)})
public final class BJoinProfile
extends BComponent
implements BIStatus,
BIMixIn {
    @Generated
    public static final Property status = BJoinProfile.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property enabled = BJoinProfile.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lastJoin = BJoinProfile.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property stationDisplayName = BJoinProfile.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property defaultUser = BJoinProfile.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:UserNamePickerFE"));
    @Generated
    public static final Property defaultUserPassword = BJoinProfile.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property defaultIpAddress = BJoinProfile.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    @Generated
    public static final Property defaultPort = BJoinProfile.newProperty((int)0, (BValue)BFormat.make((String)"%foxService.foxPort.publicServerPort%"), null);
    @Generated
    public static final Property defaultUseFoxs = BJoinProfile.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property defaultFoxsPort = BJoinProfile.newProperty((int)0, (BValue)BFormat.make((String)"%foxService.foxsPort.publicServerPort%"), null);
    @Generated
    public static final Property defaultFoxOverWebsocket = BJoinProfile.newProperty((int)4, (BValue)BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails, null);
    @Generated
    public static final Property defaultFoxOverWebsocketPort = BJoinProfile.newProperty((int)4, (BValue)BFormat.make((String)"%webService.httpsPort.publicServerPort%"), null);
    @Generated
    public static final Property stationFile = BJoinProfile.newProperty((int)0, (BValue)BOrd.make((String)"file:^joinProfiles$(defaultStationFileName).bog"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"), (BFacets)BFacets.make((String)"showLink", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Property stationInfo = BJoinProfile.newProperty((int)0, (BValue)new BStationInformation(), null);
    @Generated
    public static final Action join = BJoinProfile.newAction((int)8, null);
    @Generated
    public static final Action joinCompleted = BJoinProfile.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJoinProfile.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"sync.png"), (BIcon)BIcon.std((String)"badges/add.png"));

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BAbsTime getLastJoin() {
        return (BAbsTime)this.get(lastJoin);
    }

    @Generated
    public void setLastJoin(BAbsTime v) {
        this.set(lastJoin, (BValue)v, null);
    }

    @Generated
    public BFormat getStationDisplayName() {
        return (BFormat)this.get(stationDisplayName);
    }

    @Generated
    public void setStationDisplayName(BFormat v) {
        this.set(stationDisplayName, (BValue)v, null);
    }

    @Generated
    public String getDefaultUser() {
        return this.getString(defaultUser);
    }

    @Generated
    public void setDefaultUser(String v) {
        this.setString(defaultUser, v, null);
    }

    @Generated
    public BPassword getDefaultUserPassword() {
        return (BPassword)this.get(defaultUserPassword);
    }

    @Generated
    public void setDefaultUserPassword(BPassword v) {
        this.set(defaultUserPassword, (BValue)v, null);
    }

    @Generated
    public BFormat getDefaultIpAddress() {
        return (BFormat)this.get(defaultIpAddress);
    }

    @Generated
    public void setDefaultIpAddress(BFormat v) {
        this.set(defaultIpAddress, (BValue)v, null);
    }

    @Generated
    public BFormat getDefaultPort() {
        return (BFormat)this.get(defaultPort);
    }

    @Generated
    public void setDefaultPort(BFormat v) {
        this.set(defaultPort, (BValue)v, null);
    }

    @Generated
    public boolean getDefaultUseFoxs() {
        return this.getBoolean(defaultUseFoxs);
    }

    @Generated
    public void setDefaultUseFoxs(boolean v) {
        this.setBoolean(defaultUseFoxs, v, null);
    }

    @Generated
    public BFormat getDefaultFoxsPort() {
        return (BFormat)this.get(defaultFoxsPort);
    }

    @Generated
    public void setDefaultFoxsPort(BFormat v) {
        this.set(defaultFoxsPort, (BValue)v, null);
    }

    @Generated
    public BFoxClientWebsocketBehavior getDefaultFoxOverWebsocket() {
        return (BFoxClientWebsocketBehavior)this.get(defaultFoxOverWebsocket);
    }

    @Generated
    public void setDefaultFoxOverWebsocket(BFoxClientWebsocketBehavior v) {
        this.set(defaultFoxOverWebsocket, (BValue)v, null);
    }

    @Generated
    public BFormat getDefaultFoxOverWebsocketPort() {
        return (BFormat)this.get(defaultFoxOverWebsocketPort);
    }

    @Generated
    public void setDefaultFoxOverWebsocketPort(BFormat v) {
        this.set(defaultFoxOverWebsocketPort, (BValue)v, null);
    }

    @Generated
    public BOrd getStationFile() {
        return (BOrd)this.get(stationFile);
    }

    @Generated
    public void setStationFile(BOrd v) {
        this.set(stationFile, (BValue)v, null);
    }

    @Generated
    public BStationInformation getStationInfo() {
        return (BStationInformation)this.get(stationInfo);
    }

    @Generated
    public void setStationInfo(BStationInformation v) {
        this.set(stationInfo, (BValue)v, null);
    }

    @Generated
    public BOrd join() {
        return (BOrd)this.invoke(join, null, null);
    }

    @Generated
    public void joinCompleted() {
        this.invoke(joinCompleted, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.updateStatus();
        this.checkStationFileOrd();
        if (!Flags.isUserDefined1((BComplex)this, (Slot)defaultFoxOverWebsocket)) {
            this.setFlags((Slot)defaultFoxOverWebsocket, this.getFlags((Slot)defaultFoxOverWebsocket) & 0xFFFFFFFB | 0x10000000);
        }
        if (!Flags.isUserDefined1((BComplex)this, (Slot)defaultFoxOverWebsocketPort)) {
            this.setFlags((Slot)defaultFoxOverWebsocketPort, this.getFlags((Slot)defaultFoxOverWebsocketPort) & 0xFFFFFFFB | 0x10000000);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == enabled) {
            this.updateStatus();
            this.checkStationFileOrd();
        } else {
            super.changed(property, context);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraStation;
    }

    public BIcon getIcon() {
        return icon;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == stationFile) {
            try {
                BString str = BString.make((String)("defaultStationFileName;/" + this.getDefaultStationFileName()));
                return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"ordVariables", (BIDataValue)str);
            }
            catch (Exception e) {
                ExportTagUtil.log.error("Generating Station File facets", (Throwable)e);
            }
        }
        return super.getSlotFacets(slot);
    }

    BJoinInfo getJoinInfo(BOrd stationFolderPath, Context cx) throws Exception {
        BJoinInfo info = new BJoinInfo();
        BOrd stationFileOrd = this.getProcessedStationFileOrd();
        if (stationFileOrd.isNull()) {
            throw new ExportTagException("noStationFileSelected");
        }
        OrdVariableProcessor p2 = new OrdVariableProcessor(new StationInfoHandler(this.getStationInfo()));
        info.setStationFolderPath(p2.process(stationFolderPath));
        info.setStationDisplayName(this.getStationDisplayName().format((Object)this));
        info.setSupervisorStation(this.getSupervisorStation().getSlotPathOrd());
        info.setStationFile(stationFileOrd);
        return info;
    }

    public BNiagaraStation getSupervisorStation() {
        return (BNiagaraStation)this.getParent();
    }

    private void checkStationFileOrd() {
        block8: {
            if (this.getStatus().isDisabled()) {
                return;
            }
            try {
                BOrd fileOrd = this.getProcessedStationFileOrd();
                boolean exist = false;
                try {
                    fileOrd.get((BObject)this);
                    exist = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exist) break block8;
                OrdQuery[] queries = fileOrd.parse();
                for (int i = 0; i < queries.length; ++i) {
                    if (!(queries[i] instanceof FilePath)) continue;
                    BIFile baseFile = (BIFile)BOrd.make((String)"file:^").get((BObject)this);
                    BFileSpace space = baseFile.getFileSpace();
                    try {
                        BUnrestrictedFolder parent = new BUnrestrictedFolder();
                        parent.add("niagaraStation", (BValue)new BNiagaraStation());
                        BIFile file = space.makeFile((FilePath)queries[i]);
                        ValueDocEncoder encoder = new ValueDocEncoder(file.getOutputStream());
                        encoder.setZipped(true);
                        encoder.encodeDocument((BValue)parent);
                        encoder.close();
                    }
                    catch (IOException e) {
                        ExportTagUtil.log.error("Creating default Station BOG file", (Throwable)e);
                    }
                    break;
                }
            }
            catch (Exception e) {
                ExportTagUtil.log.error("Could not create Station BOG file for Profile: " + this.toPathString(), (Throwable)e);
            }
        }
    }

    void updateStatus() {
        BSubordinateExportTagNetworkExt ext = (BSubordinateExportTagNetworkExt)Sys.getService((Type)BSubordinateExportTagNetworkExt.TYPE);
        BStatus st = ext.getStatus();
        st = BStatus.makeDisabled((BStatus)st, (!this.getEnabled() ? 1 : 0) != 0);
        this.setStatus(st);
    }

    public BOrd getProcessedStationFileOrd() throws Exception {
        return new OrdVariableProcessor(new OrdVariableProcessor.Replace("defaultStationFileName", "/" + this.getDefaultStationFileName())).process(this.getStationFile());
    }

    private String getDefaultStationFileName() {
        return this.getSupervisorStation().getName() + "_profile";
    }

    public BOrd doJoin(Context cx) throws Exception {
        if (this.getStatus().isDisabled()) {
            return BOrd.NULL;
        }
        BSubordinateExportTagNetworkExt ext = (BSubordinateExportTagNetworkExt)Sys.getService((Type)BSubordinateExportTagNetworkExt.TYPE);
        return new BSubordinateJoinJob(ext, this).submit(cx);
    }

    public void doJoinCompleted(Context cx) throws Exception {
        this.setLastJoin(BAbsTime.now());
    }

    public String getDisplayNameInParent(Context cx) {
        Lexicon lex = Lexicon.make((BModule)this.getType().getModule(), (Context)cx);
        return lex.get("joinProfile");
    }

    private static class StationInfoHandler
    implements OrdVariableProcessor.IVarHandler {
        private BStationInformation info;
        private BValue value = null;
        private String var = "";

        private StationInfoHandler(BStationInformation info) {
            this.info = info;
        }

        @Override
        public boolean accept(String var) {
            this.value = this.info.get(var);
            if (this.value != null) {
                this.var = var;
                return true;
            }
            return false;
        }

        @Override
        public BFacets get() {
            String s = SlotPath.escape((String)this.value.toString());
            if (s.length() > 0) {
                s = "/" + s;
            }
            return BFacets.make((String)this.var, (BIDataValue)BString.make((String)s));
        }
    }
}

