/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.api;

import com.tridium.portal.api.PortalApi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class XMessage {
    public String uri;
    public XElem envelope;
    public XElem body;

    public XMessage(String uri) {
        this.uri = uri;
        this.body = new XElem("body");
        this.envelope = new XElem("envelope");
        this.envelope.addAttr("version", PortalApi.VERSION.toString());
        this.envelope.addAttr("fromHostId", PortalApi.MY_HOST_ID);
        this.envelope.addContent((XContent)this.body);
    }

    public byte[] toBytes() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XWriter xout = new XWriter((OutputStream)bout);
        this.envelope.write(xout);
        xout.close();
        return bout.toByteArray();
    }

    public XMessage fromBytes(byte[] content) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        this.envelope = XParser.make((InputStream)in).parse();
        this.body = this.envelope.elem("body");
        return this;
    }

    public String toString() {
        return this.uri;
    }

    public void dump() {
        System.out.println("--- XMessage: " + this.uri);
        this.envelope.dump();
    }
}

