/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.event;

import com.tridium.event.BNiagaraEventDeviceExt;
import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nd.BNiagaraStation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.baja.event.BEvent;
import javax.baja.event.BEventService;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
public class BEventChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BEventChannel.class);
    private final Queue queue = new Queue();
    public static final String CHANNEL_NAME = "Event";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEventChannel() {
        super(CHANNEL_NAME);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (BEventService.log.isLoggable(Level.FINE)) {
            BEventService.log.fine("Request received '" + command + "'");
        }
        if (command.equals("event")) {
            return this.event(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Throwable {
        String command = circuit.command;
        if (BEventService.log.isLoggable(Level.FINE)) {
            BEventService.log.fine("Circuit open '" + command + "'");
        }
        if (!command.equals("eventStream")) {
            throw new InvalidCommandException(command);
        }
        this.event(circuit);
    }

    public synchronized void sendEvent(BEvent event) {
        this.sendEvent(event, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendEvent(BEvent event, boolean queueOnFailure) {
        BEventService.log.fine("Sending event.");
        try {
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).engageNoRetry("eventChannel", 5000L);
            this.sendAsync(this.makeRequest(event));
            this.getDeviceExt().setLastSendTime(BAbsTime.now());
        }
        catch (Exception e) {
            if (BEventService.log.isLoggable(Level.FINE)) {
                BEventService.log.log(Level.SEVERE, "Unable to send event.", e);
            }
            if (queueOnFailure) {
                this.queue.enqueue((Object)event);
            }
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
        }
        finally {
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).disengage("eventChannel");
        }
    }

    public synchronized void sendEvents(BEvent[] events) throws Exception {
        this.sendEvents(events, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendEvents(BEvent[] events, boolean queueOnFailure) throws Exception {
        BEventService.log.fine("Sending events.");
        try {
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).engageNoRetry("eventChannel", 5000L);
            this.sendAsync(this.makeRequest(events));
            this.getDeviceExt().setLastSendTime(BAbsTime.now());
        }
        catch (Exception e) {
            if (BEventService.log.isLoggable(Level.FINE)) {
                BEventService.log.log(Level.SEVERE, "Unable to send events.", e);
            }
            this.queue.enqueue((Object)events);
            this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
            this.getDeviceExt().setLastSendFailureCause(e.toString());
        }
        finally {
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).disengage("eventChannel");
        }
    }

    private FoxResponse event(FoxRequest request) {
        FoxTuple[] tuples = request.list("event");
        if (BEventService.log.isLoggable(Level.FINE)) {
            BEventService.log.fine("Received " + tuples.length + " event(s).");
        }
        this.processEvents(tuples);
        return new FoxResponse(request);
    }

    public synchronized void flush() {
        if (this.queue.isEmpty()) {
            return;
        }
        if (BEventService.log.isLoggable(Level.FINE)) {
            BEventService.log.fine("Flushing " + this.queue.size() + " queued events.");
        }
        FoxCircuit circuit = null;
        try {
            circuit = this.openCircuit("eventStream");
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).engageNoRetry("eventChannelStream", 5000L);
            try {
                while (!this.queue.isEmpty()) {
                    BEventService.log.fine("Flushing event.");
                    FoxRequest request = this.makeRequest((BEvent)((Object)this.queue.dequeue()));
                    if (this.queue.isEmpty()) {
                        request.add("last", true);
                        circuit.writeMessage((FoxMessage)request);
                        break;
                    }
                    circuit.writeMessage((FoxMessage)request);
                }
                this.getDeviceExt().setLastSendTime(BAbsTime.now());
            }
            catch (Exception e) {
                this.getDeviceExt().setLastSendFailureTime(BAbsTime.make());
                this.getDeviceExt().setLastSendFailureCause(e.toString());
            }
            circuit.close();
        }
        catch (Exception e) {
            BEventService.log.log(Level.SEVERE, "Unable to flush events.", e);
        }
        finally {
            ((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).disengage("eventChannelStream");
            if (circuit != null && circuit.isOpen()) {
                circuit.close();
            }
        }
        BEventService.log.fine("Circuit closed.");
    }

    private void event(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage message;
            do {
                message = circuit.readMessage();
                FoxTuple[] tuples = message.list("event");
                if (BEventService.log.isLoggable(Level.FINE)) {
                    BEventService.log.fine("Received " + tuples.length + " event(s).");
                }
                this.processEvents(tuples);
            } while (!message.getBoolean("last", false));
        }
        catch (Exception e) {
            BEventService.log.log(Level.SEVERE, "Error streaming events.", e);
        }
        circuit.close();
        BEventService.log.fine("Circuit closed.");
    }

    private FoxRequest makeRequest(BEvent event) {
        FoxRequest msg = this.makeRequest("event");
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)stream);
            encoder.encodeDocument((BValue)event);
            encoder.close();
            msg.add("event", stream.toByteArray());
        }
        catch (Exception e) {
            BEventService.log.log(Level.SEVERE, "Unable to encode event", e);
        }
        return msg;
    }

    private FoxRequest makeRequest(BEvent[] events) {
        FoxRequest msg = this.makeRequest("event");
        for (BEvent event : events) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)stream);
                encoder.encodeDocument((BValue)event);
                encoder.close();
                msg.add("event", stream.toByteArray());
            }
            catch (Exception e) {
                BEventService.log.log(Level.SEVERE, "Unable to encode event", e);
            }
        }
        return msg;
    }

    private void processEvents(FoxTuple[] tuples) {
        for (FoxTuple tuple : tuples) {
            try {
                ByteArrayInputStream input1 = new ByteArrayInputStream(((FoxBlob)tuple).data);
                ValueDocDecoder decoder = new ValueDocDecoder((InputStream)input1);
                BEvent event = (BEvent)decoder.decodeDocument();
                decoder.close();
                event.setSource(BOrdList.add((BOrdList)event.getSource(), (BOrd)this.getDeviceExt().getSlotPathOrd()));
                BEventService.get().process(event);
            }
            catch (Exception e) {
                BEventService.log.log(Level.SEVERE, "Unable to procese event(s).", e);
            }
        }
    }

    private BNiagaraEventDeviceExt getDeviceExt() {
        try {
            return ((BNiagaraEventDeviceExt[])((BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(NullPointerException::new)).getChildren(BNiagaraEventDeviceExt.class))[0];
        }
        catch (Exception e) {
            BEventService.log.log(Level.SEVERE, "Unable to find BNiagaraEventDeviceExt.", e);
            return null;
        }
    }
}

