/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report.grid;

import com.tridium.report.grid.GridCompUtil;
import javax.baja.agent.AgentList;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.report.grid.BGrid;
import javax.baja.report.grid.GridModel;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="query", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"bql:BqlQueryEditor\"))")})
public class BBqlGrid
extends BGrid {
    @Generated
    public static final Property query = BBqlGrid.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"bql:BqlQueryEditor")));
    @Generated
    public static final Type TYPE = Sys.loadType(BBqlGrid.class);
    private static final BIcon icon = BIcon.make((String)"module://report/icons/bqlGrid.png");

    @Generated
    public BOrd getQuery() {
        return (BOrd)this.get(query);
    }

    @Generated
    public void setQuery(BOrd v) {
        this.set(query, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public GridModel resolve(BObject base, Context cx) {
        BOrd query = this.getQuery();
        if (query.isNull()) {
            Model m = new Model();
            m.cols = new String[0];
            m.targets = new OrdTarget[0];
            return m;
        }
        OrdQuery[] parts = query.parse();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].getScheme() != "bql") continue;
            String body = parts[i].getBody();
            if (body.startsWith("select *")) {
                throw new IllegalArgumentException("You must explicitly specify columns for your query (do not use '*').");
            }
            body = "select ordInSession," + body.substring("select ".length());
            parts[i] = BqlQuery.make((String)body);
        }
        query = BOrd.make((OrdQuery[])parts);
        if (base instanceof BINavNode) {
            query = BOrd.make((BOrd)((BINavNode)base).getNavOrd(), (BOrd)query).normalize().relativizeToSession();
        }
        BIRandomAccessTable table = Tables.slurp((BITable)((BITable)query.resolve(base).get()));
        ColumnList cols = table.getColumns();
        Model model = new Model();
        model.cx = cx;
        model.cols = new String[cols.size() - 1];
        model.names = new String[model.cols.length];
        model.formats = new BFormat[model.cols.length];
        for (int i = 1; i < cols.size(); ++i) {
            model.cols[i - 1] = cols.get(i).getName();
            model.names[i - 1] = cols.get(i).getDisplayName(cx);
            model.formats[i - 1] = BFormat.make((String)("%" + cols.get(i).getName() + "%"));
        }
        BOrd[] ords = new BOrd[table.size()];
        for (int i = 0; i < table.size(); ++i) {
            ords[i] = BOrd.make((String)table.get(i).cell(cols.get(0)).toString());
        }
        BatchResolve br = new BatchResolve(ords);
        try {
            model.targets = br.resolve(base, cx).getTargets();
        }
        catch (UnresolvedException e) {
            model.targets = new OrdTarget[ords.length];
            for (int i = 0; i < model.targets.length; ++i) {
                model.targets[i] = br.isResolved(i) ? br.getTarget(i) : null;
            }
        }
        catch (SyntaxException se) {
            throw new LocalizableRuntimeException("report", "Report.gridTable.bql.resolveError", (Throwable)se);
        }
        return model;
    }

    public AgentList getAgents(Context cx) {
        return GridCompUtil.reorderAgents(super.getAgents(cx));
    }

    public BIcon getIcon() {
        return icon;
    }

    private class Model
    extends GridModel {
        Context cx;
        String[] cols;
        String[] names;
        BFormat[] formats;
        OrdTarget[] targets;

        private Model() {
        }

        @Override
        public int getRowCount() {
            if (this.targets.length == 0) {
                return 0;
            }
            if (this.cols.length == 0) {
                return 0;
            }
            return this.targets.length;
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.names[col];
        }

        @Override
        public BFormat getColumnFormat(int col) {
            return this.formats[col];
        }

        @Override
        public OrdTarget getTargetAt(int row, int col) {
            return this.targets[row];
        }

        @Override
        public BObject getObjectAt(int row, int col) {
            OrdTarget target = this.getTargetAt(row, col);
            return target == null ? null : target.get();
        }
    }
}

