/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;

public class BObjectArrayCursor<T extends BObject>
implements IterableCursor<T> {
    private Context cx;
    private T[] objs;
    private int index;

    public BObjectArrayCursor(T[] objs, Context cx) {
        this.objs = objs;
        this.cx = cx;
        this.index = -1;
    }

    @Override
    public void close() {
        this.index = this.objs.length;
    }

    @Override
    public Context getContext() {
        return this.cx;
    }

    @Override
    public T get() {
        return this.objs[this.index];
    }

    @Override
    public boolean next() {
        if (this.index != this.objs.length) {
            ++this.index;
        }
        return this.index < this.objs.length;
    }

    public boolean nextComponent() {
        while (this.next()) {
            if (!((BObject)this.get()).isComponent()) continue;
            return true;
        }
        return false;
    }

    public boolean next(Class<?> cls) {
        while (this.next()) {
            if (!cls.isInstance(this.get())) continue;
            return true;
        }
        return false;
    }
}

