/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BNameList
extends BSimple {
    public static final BNameList NULL;
    public static final BNameList DEFAULT;
    public static final Type TYPE;
    private String string;
    private String[] names;
    private int hashCode = -1;

    public static BNameList make(String name) {
        return BNameList.make(new String[]{name});
    }

    public static BNameList make(String[] names) {
        if (names.length == 0) {
            return NULL;
        }
        String[] safe = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = safe[i] = names[i];
            SlotPath.verifyValidName(name);
        }
        return (BNameList)new BNameList(safe).intern();
    }

    public static BNameList union(BNameList a, BNameList b) {
        int i;
        if (a.isNull()) {
            return b;
        }
        if (b.isNull()) {
            return a;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] an = a.names;
        String[] bn = b.names;
        for (i = 0; i < an.length; ++i) {
            map.put(an[i], an[i]);
        }
        for (i = 0; i < bn.length; ++i) {
            map.put(bn[i], bn[i]);
        }
        String[] names = map.values().toArray(new String[0]);
        return (BNameList)new BNameList(names).intern();
    }

    public static BNameList intersection(BNameList a, BNameList b) {
        if (a.isNull()) {
            return NULL;
        }
        if (b.isNull()) {
            return NULL;
        }
        ArrayList<String> v = new ArrayList<String>();
        String[] an = a.names;
        for (int i = 0; i < an.length; ++i) {
            if (!b.contains(an[i])) continue;
            v.add(an[i]);
        }
        String[] names = v.toArray(new String[0]);
        return (BNameList)new BNameList(names).intern();
    }

    public static BNameList difference(BNameList a, BNameList b) {
        if (a.isNull()) {
            return NULL;
        }
        if (b.isNull()) {
            return a;
        }
        HashSet<String> bSet = new HashSet<String>(b.names.length);
        for (int i = 0; i < b.names.length; ++i) {
            bSet.add(b.names[i]);
        }
        ArrayList<String> diff = new ArrayList<String>();
        for (int i = 0; i < a.names.length; ++i) {
            if (bSet.contains(a.names[i])) continue;
            diff.add(a.names[i]);
        }
        return (BNameList)new BNameList(diff.toArray(new String[0])).intern();
    }

    private BNameList(String[] names) {
        this.names = names;
    }

    public String[] getNames() {
        String[] copy = new String[this.names.length];
        System.arraycopy(this.names, 0, copy, 0, copy.length);
        return copy;
    }

    public boolean contains(String name) {
        String[] names = this.names;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNull() {
        return this.names.length == 0;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BNameList) {
            BNameList x = (BNameList)obj;
            if (this.names.length != x.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (x.contains(this.names[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return this.encodeToString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.names.length; ++i) {
                if (i > 0) {
                    s.append(';');
                }
                s.append(this.names[i]);
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s, ";");
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                SlotPath.verifyValidName(name);
                v.add(name);
            }
            BNameList list = (BNameList)new BNameList(v.toArray(new String[0])).intern();
            list.string = s;
            return list;
        }
        catch (IllegalNameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Invalid BNameList: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BNameList(new String[0]);
        TYPE = Sys.loadType(BNameList.class);
    }
}

