/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BAllowConcurrentSessionsMergeMode;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BAutoLogoffSettingsMergeMode;
import javax.baja.user.BExpirationMergeMode;
import javax.baja.user.BRolesMergeMode;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypeProperty;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="rolesMergeMode", type="BRolesMergeMode", defaultValue="BRolesMergeMode.union"), @NiagaraProperty(name="expirationMergeMode", type="BExpirationMergeMode", defaultValue="BExpirationMergeMode.preferEarliest"), @NiagaraProperty(name="allowConcurrentSessionsMergeMode", type="BAllowConcurrentSessionsMergeMode", defaultValue="BAllowConcurrentSessionsMergeMode.preferFalse"), @NiagaraProperty(name="autoLogoffSettingsMergeMode", type="BAutoLogoffSettingsMergeMode", defaultValue="BAutoLogoffSettingsMergeMode.preferShortest")})
public final class BUserPrototypeMergePolicy
extends BComponent {
    @Generated
    public static final Property enabled = BUserPrototypeMergePolicy.newProperty(0, false, null);
    @Generated
    public static final Property rolesMergeMode = BUserPrototypeMergePolicy.newProperty(0, BRolesMergeMode.union, null);
    @Generated
    public static final Property expirationMergeMode = BUserPrototypeMergePolicy.newProperty(0, BExpirationMergeMode.preferEarliest, null);
    @Generated
    public static final Property allowConcurrentSessionsMergeMode = BUserPrototypeMergePolicy.newProperty(0, BAllowConcurrentSessionsMergeMode.preferFalse, null);
    @Generated
    public static final Property autoLogoffSettingsMergeMode = BUserPrototypeMergePolicy.newProperty(0, BAutoLogoffSettingsMergeMode.preferShortest, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUserPrototypeMergePolicy.class);
    private static final Logger LOG = Logger.getLogger("baja.user");

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRolesMergeMode getRolesMergeMode() {
        return (BRolesMergeMode)this.get(rolesMergeMode);
    }

    @Generated
    public void setRolesMergeMode(BRolesMergeMode v) {
        this.set(rolesMergeMode, (BValue)v, null);
    }

    @Generated
    public BExpirationMergeMode getExpirationMergeMode() {
        return (BExpirationMergeMode)this.get(expirationMergeMode);
    }

    @Generated
    public void setExpirationMergeMode(BExpirationMergeMode v) {
        this.set(expirationMergeMode, (BValue)v, null);
    }

    @Generated
    public BAllowConcurrentSessionsMergeMode getAllowConcurrentSessionsMergeMode() {
        return (BAllowConcurrentSessionsMergeMode)this.get(allowConcurrentSessionsMergeMode);
    }

    @Generated
    public void setAllowConcurrentSessionsMergeMode(BAllowConcurrentSessionsMergeMode v) {
        this.set(allowConcurrentSessionsMergeMode, (BValue)v, null);
    }

    @Generated
    public BAutoLogoffSettingsMergeMode getAutoLogoffSettingsMergeMode() {
        return (BAutoLogoffSettingsMergeMode)this.get(autoLogoffSettingsMergeMode);
    }

    @Generated
    public void setAutoLogoffSettingsMergeMode(BAutoLogoffSettingsMergeMode v) {
        this.set(autoLogoffSettingsMergeMode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUserPrototype mergePrototypes(BComponent mainPrototype, BComponent ... prototypes) {
        if (!this.isRunning()) {
            LOG.warning("Merge attempted on non-running UserPrototypeMergePolicy");
            throw new NotRunningException("Merge policy cannot merge prototypes outside of a running station");
        }
        if (!this.getEnabled()) {
            LOG.warning("Merge attempted on disabled UserPrototypeMergePolicy");
            throw new IllegalStateException("Merge policy is disabled. Cannot merge user prototypes");
        }
        BUserPrototype mergedPrototype = BUserPrototypeMergePolicy.getUserPrototype(mainPrototype);
        BAbsTime mergedExpiration = BUserPrototypeMergePolicy.getPrototypeExpiration(mergedPrototype);
        boolean mergedAllowConcurrentSessions = BUserPrototypeMergePolicy.getPrototypeAllowedConcurrentSessions(mergedPrototype);
        BAutoLogoffSettings mergedAutoLogoffSettings = BUserPrototypeMergePolicy.getPrototypeAutoLogoffSettings(mergedPrototype);
        Set<String> mergedRoles = BUser.splitRoles(((BString)mergedPrototype.getRoles().getValue()).getString());
        for (BComponent prototype : prototypes) {
            if (!(prototype instanceof BUser) && !(prototype instanceof BUserPrototype)) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Invalid type " + prototype.getType().getTypeName() + "in prototypes list. Ignoring.");
                continue;
            }
            mergedExpiration = this.getExpirationMergeMode().getMergedValue(mergedExpiration, BUserPrototypeMergePolicy.getPrototypeExpiration(prototype));
            mergedAllowConcurrentSessions = this.getAllowConcurrentSessionsMergeMode().getMergedValue(mergedAllowConcurrentSessions, BUserPrototypeMergePolicy.getPrototypeAllowedConcurrentSessions(prototype));
            mergedAutoLogoffSettings = this.getAutoLogoffSettingsMergeMode().getMergedValue(mergedAutoLogoffSettings, BUserPrototypeMergePolicy.getPrototypeAutoLogoffSettings(prototype));
            mergedRoles = this.getRolesMergeMode().getMergedValue(mergedRoles, BUserPrototypeMergePolicy.getPrototypeRoles(prototype));
        }
        mergedPrototype.setExpiration(new BUserPrototypeProperty(mergedExpiration));
        mergedPrototype.setAllowConcurrentSessions(new BUserPrototypeProperty(BBoolean.make(mergedAllowConcurrentSessions)));
        mergedPrototype.setAutoLogoffSettings(new BUserPrototypeProperty(mergedAutoLogoffSettings.newCopy()));
        mergedPrototype.setRoles(new BUserPrototypeProperty(BString.make(String.join((CharSequence)",", mergedRoles))));
        return mergedPrototype;
    }

    public static String getMergedPrototypeName(List<BComponent> prototypes) {
        StringJoiner mergedPrototypeName = new StringJoiner("_", "merged_", "");
        prototypes.forEach(proto -> mergedPrototypeName.add(proto.getName()));
        return mergedPrototypeName.toString();
    }

    private static BUserPrototype getUserPrototype(BComponent prototype) {
        if (prototype instanceof BUserPrototype) {
            return (BUserPrototype)prototype.newCopy();
        }
        if (!(prototype instanceof BUser)) {
            throw new IllegalArgumentException("Invalid prototype type. Must be a BUser or BUserPrototype");
        }
        BUser templatePrototype = (BUser)prototype;
        BUserPrototype userPrototype = new BUserPrototype();
        userPrototype.setFullName(new BUserPrototypeProperty(BString.make(templatePrototype.getFullName())));
        userPrototype.setEnabled(new BUserPrototypeProperty(BBoolean.make(templatePrototype.getEnabled())));
        userPrototype.setExpiration(new BUserPrototypeProperty(templatePrototype.getExpiration()));
        userPrototype.setLanguage(new BUserPrototypeProperty(BString.make(templatePrototype.getLanguage())));
        userPrototype.setEmail(new BUserPrototypeProperty(BString.make(templatePrototype.getEmail())));
        userPrototype.setFacets(new BUserPrototypeProperty(templatePrototype.getFacets()));
        userPrototype.setNavFile(new BUserPrototypeProperty(templatePrototype.getNavFile()));
        userPrototype.setCellPhoneNumber(new BUserPrototypeProperty(BString.make(templatePrototype.getCellPhoneNumber())));
        userPrototype.setRoles(new BUserPrototypeProperty(BString.make(templatePrototype.getRoles())));
        userPrototype.setAllowConcurrentSessions(new BUserPrototypeProperty(BBoolean.make(templatePrototype.getAllowConcurrentSessions())));
        userPrototype.setAutoLogoffSettings(new BUserPrototypeProperty(templatePrototype.getAutoLogoffSettings().newCopy()));
        return userPrototype;
    }

    private static BAbsTime getPrototypeExpiration(BComponent prototype) {
        if (prototype instanceof BUser) {
            return ((BUser)prototype).getExpiration();
        }
        return (BAbsTime)((BUserPrototype)prototype).getExpiration().getValue();
    }

    private static boolean getPrototypeAllowedConcurrentSessions(BComponent prototype) {
        if (prototype instanceof BUser) {
            return ((BUser)prototype).getAllowConcurrentSessions();
        }
        return ((BBoolean)((BUserPrototype)prototype).getAllowConcurrentSessions().getValue()).getBoolean();
    }

    private static BAutoLogoffSettings getPrototypeAutoLogoffSettings(BComponent prototype) {
        if (prototype instanceof BUser) {
            return ((BUser)prototype).getAutoLogoffSettings();
        }
        return (BAutoLogoffSettings)((BUserPrototype)prototype).getAutoLogoffSettings().getValue();
    }

    private static Set<String> getPrototypeRoles(BComponent prototype) {
        String roles = prototype instanceof BUser ? ((BUser)prototype).getRoles() : ((BString)((BUserPrototype)prototype).getRoles().getValue()).getString();
        return BUser.splitRoles(roles);
    }
}

