/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.baja.data.BIDataValue;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public class TagSet
implements Tags {
    private final Map<Id, Object> tags = new HashMap<Id, Object>();

    @Override
    public Optional<BIDataValue> get(Id id) {
        Object val = this.tags.get(id);
        if (val instanceof BIDataValue) {
            return Optional.of((BIDataValue)val);
        }
        if (val instanceof Collection) {
            return Optional.of(((Collection)val).iterator().next());
        }
        return Optional.empty();
    }

    @Override
    public boolean isMulti(Id id) {
        return this.contains(id) && this.tags.get(id) instanceof Collection;
    }

    @Override
    public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(values);
        this.tags.put(id, new HashSet<BIDataValue>(values));
        return true;
    }

    @Override
    public boolean set(Tag tag) {
        Objects.requireNonNull(tag);
        this.tags.put(tag.getId(), tag.getValue());
        return true;
    }

    @Override
    public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
        if (!this.tags.containsKey(id)) {
            return this.setMulti(id, values);
        }
        return this.getAsMulti(id).addAll(values);
    }

    private Set<BIDataValue> getAsMulti(Id id) {
        Object v = this.tags.get(id);
        Objects.requireNonNull(v);
        if (v instanceof Set) {
            return (Set)v;
        }
        throw new IllegalArgumentException(String.format("%s is not multi-value", id));
    }

    @Override
    public boolean remove(Id id, BIDataValue value) {
        if (!this.isMulti(id)) {
            return this.tags.remove(id) != null;
        }
        Set<BIDataValue> values = this.getAsMulti(id);
        if (values.remove(value)) {
            if (values.isEmpty()) {
                this.tags.remove(id);
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<Tag> filter(Predicate<Tag> f) {
        ArrayList<Tag> matches = new ArrayList<Tag>();
        for (Map.Entry<Id, Object> entry : this.tags.entrySet()) {
            Id id = entry.getKey();
            Object ov = entry.getValue();
            Set<BIDataValue> values = ov instanceof BIDataValue ? Collections.singleton((BIDataValue)ov) : (Set<BIDataValue>)ov;
            for (BIDataValue dv : values) {
                Tag t = new Tag(id, dv);
                if (!f.test(t)) continue;
                matches.add(t);
            }
        }
        return matches;
    }
}

