/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.collection.FilteredIterator;
import javax.baja.data.BIDataValue;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.SmartTagDictionary;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.Tags;

public class ImpliedTags
implements Tags {
    private TagDictionaryService service;
    private Entity entity;
    private Map<Id, Tag> loaded = new HashMap<Id, Tag>();

    public ImpliedTags(TagDictionaryService service, Entity entity) {
        this.service = service;
        this.entity = entity;
    }

    @Override
    public boolean isMulti(Id id) {
        Optional<BIDataValue> o = this.get(id);
        return o.isPresent() && o.get() instanceof Collection;
    }

    @Override
    public boolean set(Tag tag) {
        return false;
    }

    @Override
    public boolean set(Id id, BIDataValue value) {
        return false;
    }

    @Override
    public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
        return false;
    }

    @Override
    public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
        return false;
    }

    @Override
    public boolean addMulti(Tag tag) {
        return false;
    }

    @Override
    public boolean addMulti(Id id, BIDataValue value) {
        return false;
    }

    @Override
    public boolean merge(Collection<Tag> tags) {
        return false;
    }

    @Override
    public boolean remove(Id id, BIDataValue value) {
        return false;
    }

    @Override
    public boolean removeAll(Id id) {
        return false;
    }

    @Override
    public boolean remove(Tag tag) {
        return false;
    }

    @Override
    public Collection<Tag> filter(Predicate<Tag> condition) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        FilteredIterator<Tag> filtered = new FilteredIterator<Tag>(condition, this.iterator());
        while (filtered.hasNext()) {
            result.add((Tag)filtered.next());
        }
        return result;
    }

    @Override
    public Collection<Tag> getAll() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : this) {
            result.add(tag);
        }
        return result;
    }

    @Override
    public Optional<BIDataValue> get(Id id) {
        Tag tag = this.loaded.get(id);
        if (tag != null) {
            return Optional.of(tag.getValue());
        }
        Optional<Tag> otag = this.service.getImpliedTag(id, this.entity);
        if (otag.isPresent()) {
            this.loaded.put(id, otag.get());
            return Optional.of(otag.get().getValue());
        }
        return Optional.empty();
    }

    @Override
    public Collection<BIDataValue> getValues(Id id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Tag> getInDictionary(String dictionary) {
        Optional<SmartTagDictionary> otd = this.service.getSmartTagDictionary(dictionary);
        if (otd.isPresent()) {
            return otd.get().getAllImpliedTags(this.entity);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.service.getImpliedTags(this.entity).iterator();
    }
}

