/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.Objects;
import javax.baja.sys.Context;

@FunctionalInterface
public interface Localizable {
    public String toString(Context var1);

    public static Localizable fromLiteral(String nonLocalizedLiteral) {
        return context -> nonLocalizedLiteral;
    }

    public static Localizable concatenate(String separator, Iterable<Localizable> localizables) {
        Objects.requireNonNull(separator);
        return context -> {
            StringBuilder result = new StringBuilder();
            for (Localizable localizable : localizables) {
                if (result.length() > 0) {
                    result.append(separator);
                }
                result.append(localizable.toString(context));
            }
            return result.toString();
        };
    }
}

