/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.Set;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BIUnlinkableSource;
import javax.baja.sys.BIUnlinkableTarget;
import javax.baja.sys.BLink;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public final class LinkCheck {
    static final LinkCheck VALID = new LinkCheck(true);
    private static final Version CONVERSION_LINK_VERSION = new Version(new int[]{3, 6, 13});
    private boolean valid;
    private String invalidReason;

    public static LinkCheck makeValid() {
        return VALID;
    }

    public static LinkCheck makeInvalid(String invalidReason) {
        return new LinkCheck(invalidReason);
    }

    static LinkCheck make(BComponent source, Slot sourceSlot, BComponent target, Slot targetSlot, Context cx) {
        if (LinkCheck.isInvalidSlotForLink(target, targetSlot, BIUnlinkableTarget.TYPE, cx)) {
            return LinkCheck.invalid("linkcheck.invalidLinkTarget", cx);
        }
        if (LinkCheck.isInvalidSlotForLink(source, sourceSlot, BIUnlinkableSource.TYPE, cx)) {
            return LinkCheck.invalid("linkcheck.invalidLinkSource", cx);
        }
        if (LinkCheck.isDuplicate(source, sourceSlot, target, targetSlot)) {
            return LinkCheck.invalid("linkcheck.duplicate", cx);
        }
        if ((target.getFlags(targetSlot) & 0x4000) != 0) {
            return LinkCheck.invalid("linkcheck.meta", cx);
        }
        if (sourceSlot.isAction()) {
            if (targetSlot.isAction()) {
                return LinkCheck.make(source, sourceSlot.asAction(), target, targetSlot.asAction(), cx);
            }
            if (targetSlot.isTopic()) {
                return LinkCheck.make(source, sourceSlot.asAction(), target, targetSlot.asTopic(), cx);
            }
            if (targetSlot.isProperty()) {
                return LinkCheck.make(source, sourceSlot.asAction(), target, targetSlot.asProperty(), cx);
            }
            throw new IllegalStateException();
        }
        if (sourceSlot.isTopic()) {
            if (targetSlot.isAction()) {
                return LinkCheck.make(source, sourceSlot.asTopic(), target, targetSlot.asAction(), cx);
            }
            if (targetSlot.isTopic()) {
                return LinkCheck.make(source, sourceSlot.asTopic(), target, targetSlot.asTopic(), cx);
            }
            if (targetSlot.isProperty()) {
                return LinkCheck.make(source, sourceSlot.asTopic(), target, targetSlot.asProperty(), cx);
            }
            throw new IllegalStateException();
        }
        if (sourceSlot.isProperty()) {
            if (targetSlot.isAction()) {
                return LinkCheck.make(source, sourceSlot.asProperty(), target, targetSlot.asAction(), cx);
            }
            if (targetSlot.isTopic()) {
                return LinkCheck.make(source, sourceSlot.asProperty(), target, targetSlot.asTopic(), cx);
            }
            if (targetSlot.isProperty()) {
                return LinkCheck.make(source, sourceSlot.asProperty(), target, targetSlot.asProperty(), cx);
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    private static boolean isDuplicate(BComponent source, Slot sourceSlot, BComponent target, Slot targetSlot) {
        BLink[] links = target.getLinks(targetSlot);
        for (int i = 0; i < links.length; ++i) {
            BLink link = links[i];
            if (!(link.isDirect() ? link.getSourceComponent() == source && link.getSourceSlot() == sourceSlot : link.getSourceOrd().equals(source.getHandleOrd()) && link.getSourceSlotName().equals(sourceSlot.getName()))) continue;
            return true;
        }
        return false;
    }

    private static LinkCheck make(BComponent source, Property sourceSlot, BComponent target, Property targetSlot, Context cx) {
        if (Flags.isReadonly(target, targetSlot)) {
            return LinkCheck.invalid("linkcheck.propReadonly", cx);
        }
        if (sourceSlot.getType().is(BComponent.TYPE) && !sourceSlot.getType().is(BVector.TYPE)) {
            return LinkCheck.invalid("linkcheck.propComponent", cx);
        }
        if (target.isLinkTarget(targetSlot) && !Flags.isFanIn(target, targetSlot)) {
            return LinkCheck.invalid("linkcheck.propAlreadyLinked", cx);
        }
        return LinkCheck.checkType(source, sourceSlot, sourceSlot.getType(), targetSlot, targetSlot.getType(), cx);
    }

    private static LinkCheck make(BComponent source, Property sourceSlot, BComponent target, Action targetSlot, Context cx) {
        Type param = targetSlot.getParameterType();
        if (param == null) {
            return VALID;
        }
        return LinkCheck.checkType(source, sourceSlot, sourceSlot.getType(), targetSlot, param, cx);
    }

    private static LinkCheck make(BComponent source, Property sourceSlot, BComponent target, Topic targetSlot, Context cx) {
        return LinkCheck.invalid("linkcheck.propToTopic", cx);
    }

    private static LinkCheck make(BComponent source, Action sourceSlot, BComponent target, Property targetSlot, Context cx) {
        return LinkCheck.invalid("linkcheck.actionToProp", cx);
    }

    private static LinkCheck make(BComponent source, Action sourceSlot, BComponent target, Action targetSlot, Context cx) {
        if (LinkCheck.isCompositeAction(sourceSlot)) {
            return VALID;
        }
        Type sourceParam = sourceSlot.getParameterType();
        Type targetParam = targetSlot.getParameterType();
        if (targetParam == null) {
            return VALID;
        }
        if (sourceParam == null) {
            return LinkCheck.invalid("linkcheck.actionToActionNoArg", cx);
        }
        return LinkCheck.checkType(source, sourceSlot, sourceParam, targetSlot, targetParam, cx);
    }

    private static LinkCheck make(BComponent source, Action sourceSlot, BComponent target, Topic targetSlot, Context cx) {
        if (LinkCheck.isCompositeTopic(targetSlot)) {
            return VALID;
        }
        Type sourceEvent = sourceSlot.getParameterType();
        Type targetEvent = targetSlot.getEventType();
        if (targetEvent == null) {
            return VALID;
        }
        if (sourceEvent == null) {
            return LinkCheck.invalid("linkcheck.actionToTopicNoEvent", cx);
        }
        return LinkCheck.checkType(source, sourceSlot, sourceEvent, targetSlot, targetEvent, cx);
    }

    private static LinkCheck make(BComponent source, Topic sourceSlot, BComponent target, Property targetSlot, Context cx) {
        return LinkCheck.invalid("linkcheck.topicToProp", cx);
    }

    private static LinkCheck make(BComponent source, Topic sourceSlot, BComponent target, Action targetSlot, Context cx) {
        Type event = sourceSlot.getEventType();
        Type param = targetSlot.getParameterType();
        if (param == null) {
            return VALID;
        }
        if (event == null) {
            return LinkCheck.invalid("linkcheck.topicToActionNoEvent", cx);
        }
        return LinkCheck.checkType(source, sourceSlot, event, targetSlot, param, cx);
    }

    private static LinkCheck make(BComponent source, Topic sourceSlot, BComponent target, Topic targetSlot, Context cx) {
        if (LinkCheck.isCompositeTopic(targetSlot)) {
            return VALID;
        }
        Type sourceEvent = sourceSlot.getEventType();
        Type targetEvent = targetSlot.getEventType();
        if (targetEvent == null) {
            return VALID;
        }
        if (sourceEvent == null) {
            return LinkCheck.invalid("linkcheck.topicToTopicNoEvent", cx);
        }
        return LinkCheck.checkType(source, sourceSlot, sourceEvent, targetSlot, targetEvent, cx);
    }

    private static LinkCheck checkType(BComponent sourceComponent, Slot sourceSlot, Type sourceType, Slot targetSlot, Type targetType, Context cx) {
        BLink link;
        if (sourceType.is(targetType)) {
            return VALID;
        }
        Version version = (Version)sourceComponent.fw(404, "baja", "rt", null, null);
        if (version != null && version.compareTo(CONVERSION_LINK_VERSION) != -1 && (link = sourceComponent.makeLink(sourceComponent, sourceSlot, targetSlot, cx)) != null && link instanceof BConversionLink) {
            Registry reg = Sys.getRegistry();
            TypeInfo[] adapters = reg.getAdapters(sourceType.getTypeInfo(), targetType.getTypeInfo());
            for (int i = 0; i < adapters.length; ++i) {
                if (!reg.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
                return VALID;
            }
        }
        Lexicon lex = Lexicon.make(Sys.getBajaModule(), cx.getLanguage());
        Object[] args = new Object[]{sourceType, targetType};
        return LinkCheck.makeInvalid(lex.getText("linkcheck.mismatchedTypes", args));
    }

    private static LinkCheck invalid(String lexiconKey, Context cx) {
        Lexicon lex = Lexicon.make(Sys.getBajaModule(), cx);
        return LinkCheck.makeInvalid(lex.getText(lexiconKey));
    }

    private static boolean isCompositeAction(Action a) {
        if (a instanceof Property) {
            return ((Property)((Object)a)).getDefaultValue() instanceof BCompositeAction;
        }
        return false;
    }

    private static boolean isCompositeTopic(Topic t) {
        if (t instanceof Property) {
            return ((Property)((Object)t)).getDefaultValue() instanceof BCompositeTopic;
        }
        return false;
    }

    static boolean isInvalidSlotForLink(BComplex complex, Slot slot, Type unlinkableType, Context cx) {
        Property prop;
        Type propType;
        if (complex instanceof BIUnlinkableSlotsContainer) {
            Set<Slot> unlinkableSlots;
            BIUnlinkableSlotsContainer container = (BIUnlinkableSlotsContainer)((Object)complex);
            Set<Slot> set = unlinkableSlots = BIUnlinkableTarget.TYPE.equals(unlinkableType) ? container.getUnlinkableTargetSlots(cx) : container.getUnlinkableSourceSlots(cx);
            if (unlinkableSlots != null && unlinkableSlots.contains(slot)) {
                return true;
            }
        }
        return slot.isProperty() && ((propType = (prop = slot.asProperty()).getType()).is(unlinkableType) || propType.is(BComplex.TYPE) && LinkCheck.containsInvalidSlotForLink(complex.get(prop).asComplex(), unlinkableType, cx));
    }

    private static boolean containsInvalidSlotForLink(BComplex complex, Type unlinkableType, Context cx) {
        try (SlotCursor<Slot> slots = complex.getSlots();){
            while (slots.next()) {
                if (!LinkCheck.isInvalidSlotForLink(complex, slots.slot(), unlinkableType, cx)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private LinkCheck(String invalidReason) {
        this.valid = false;
        this.invalidReason = invalidReason;
    }

    private LinkCheck(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }
}

