/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BObject
implements BIObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BObject.class);
    private static final BIcon icon = BIcon.std("object.png");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BObject() {
    }

    public final boolean isValue() {
        return this instanceof BValue;
    }

    public final boolean isSimple() {
        return this instanceof BSimple;
    }

    public final boolean isComplex() {
        return this instanceof BComplex;
    }

    public final boolean isStruct() {
        return this instanceof BStruct;
    }

    public final boolean isComponent() {
        return this instanceof BComponent;
    }

    @Override
    public final <T extends BIObject> T as(Class<T> cls) {
        return (T)this;
    }

    public final BObject asObject() {
        return this;
    }

    public final BValue asValue() {
        return (BValue)this;
    }

    public final BSimple asSimple() {
        return (BSimple)this;
    }

    public final BComplex asComplex() {
        return (BComplex)this;
    }

    public final BStruct asStruct() {
        return (BStruct)this;
    }

    public final BComponent asComponent() {
        return (BComponent)this;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equivalent(Object obj) {
        return this.equals(obj);
    }

    public boolean isNull() {
        return false;
    }

    @Override
    public BIDataValue toDataValue() {
        return BString.make(this.toString());
    }

    public final AgentList getAgents() {
        return this.getAgents(null);
    }

    public AgentList getAgents(Context cx) {
        return Sys.getRegistry().getAgents(this.getType().getTypeInfo());
    }

    public Lexicon getLexicon() {
        return this.getType().getModule().getLexicon();
    }

    public String getTypeDisplayName(Context context) {
        return this.getType().getDisplayName(context);
    }

    public BIcon getIcon() {
        return icon;
    }

    public final String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Context context) {
        if (this.getType() != null) {
            return this.getTypeDisplayName(context);
        }
        return this.getClass().getName();
    }

    public String toDebugString() {
        StringBuilder s = new StringBuilder();
        if (this.getType() != null) {
            s.append(this.getType().toString());
        } else {
            s.append(this.getClass().getName());
        }
        int id = System.identityHashCode(this);
        s.append(':').append(Integer.toString(id, 36));
        if (this.isComponent()) {
            s.append('[');
            BComponent c = this.as(BComponent.class);
            if (c.getComponentSpace() != null) {
                s.append("h:").append(c.getHandle()).append(" \"").append(c.toPathString()).append('\"');
            } else {
                s.append("unmounted");
            }
            s.append(']');
        }
        return s.toString();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("Object", 2);
        out.prop((Object)"type", this.getType());
        out.prop((Object)"class", this.getClass().getName());
        out.prop((Object)"toString", this.toString());
        out.prop((Object)"toDebugString", this.toDebugString());
        out.endProps();
    }

    public final Object fw(int x) {
        return this.fw(x, null, null, null, null);
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        return null;
    }
}

