/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public final class BDate
extends BSimple
implements BIDate,
BIComparable {
    public static final BDate DEFAULT;
    public static final BDate NULL;
    private final int year;
    private final BMonth month;
    private final int day;
    private int hashCode = -1;
    public static final Type TYPE;

    public static BDate make() {
        return BDate.make(BAbsTime.now());
    }

    public static BDate today() {
        return BDate.make(BAbsTime.now());
    }

    public static BDate make(BAbsTime absTime) {
        return new BDate(absTime.getYear(), absTime.getMonth(), absTime.getDay());
    }

    public static BDate make(BAbsTime absTime, BTimeZone zone) {
        BAbsTime at = BAbsTime.make(absTime, zone);
        return new BDate(at.getYear(), at.getMonth(), at.getDay());
    }

    public static BDate make(int year, BMonth month, int day) {
        return new BDate(year, month, day);
    }

    public static BDate makeDayOfYear(int year, int dayOfYear) {
        int daysInYear = BAbsTime.getDaysInYear(year);
        if (dayOfYear > daysInYear) {
            throw new IllegalArgumentException(dayOfYear + " > " + daysInYear);
        }
        if (dayOfYear < 1) {
            throw new IllegalArgumentException(dayOfYear + " < 1");
        }
        BMonth month = BMonth.january;
        int daysInMonth = BAbsTime.getDaysInMonth(year, month);
        while (dayOfYear > daysInMonth) {
            dayOfYear -= daysInMonth;
            month = month.next();
            daysInMonth = BAbsTime.getDaysInMonth(year, month);
        }
        return BDate.make(year, month, dayOfYear);
    }

    public static BDate make(String s) throws IOException {
        return (BDate)DEFAULT.decodeFromString(s);
    }

    private BDate(int year, BMonth month, int day) {
        if (day < 1 || day > BAbsTime.getDaysInMonth(year, month)) {
            throw new IllegalArgumentException("day '" + day + "' is invalid, in year '" + year + "', month '" + month + "'.");
        }
        this.year = year;
        this.month = month;
        this.day = day;
    }

    @Override
    public int compareTo(Object obj) {
        BDate d = (BDate)obj;
        if (this.year != d.year) {
            return this.year - d.year;
        }
        if (this.month.getMonthOfYear() != d.month.getMonthOfYear()) {
            return this.month.getMonthOfYear() - d.month.getMonthOfYear();
        }
        if (this.day != d.day) {
            return this.day - d.day;
        }
        return 0;
    }

    public boolean isBefore(BDate x) {
        return this.compareTo(x) < 0;
    }

    public boolean isAfter(BDate x) {
        return this.compareTo(x) > 0;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            Logger.getLogger("sys").log(Level.WARNING, "Could not create hashCode for '" + this + "'.", e);
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BDate) {
            BDate d = (BDate)obj;
            return this.year == d.year && this.month.getMonthOfYear() == d.month.getMonthOfYear() && this.day == d.day;
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return this.encodeToString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.year);
        out.writeInt(this.month.getMonthOfYear());
        out.writeInt(this.day);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return new BDate(in.readInt(), BMonth.make(in.readInt() - 1), in.readInt());
    }

    @Override
    public String encodeToString() {
        StringBuilder s = new StringBuilder(32);
        s.append(this.year).append('-');
        int mon = this.month.getOrdinal() + 1;
        if (mon < 10) {
            s.append('0');
        }
        s.append(mon).append('-');
        if (this.day < 10) {
            s.append('0');
        }
        s.append(this.day);
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        if (s.length() != 10) {
            throw new BajaRuntimeException("Invalid date '" + s + "'");
        }
        char[] c = s.toCharArray();
        int year = (c[0] - 48) * 1000 + (c[1] - 48) * 100 + (c[2] - 48) * 10 + (c[3] - 48) * 1;
        if (c[4] != '-') {
            throw new BajaRuntimeException("Invalid date '" + s + "'");
        }
        int mon = (c[5] - 48) * 10 + (c[6] - 48) * 1;
        if (c[7] != '-') {
            throw new BajaRuntimeException("Invalid date '" + s + "'");
        }
        int day = (c[8] - 48) * 10 + (c[9] - 48) * 1;
        return new BDate(year, BMonth.make(mon - 1), day);
    }

    @Override
    public boolean isNull() {
        return this.equals(NULL);
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public BMonth getMonth() {
        return this.month;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public BWeekday getWeekday() {
        return BAbsTime.getWeekday(this.year, this.month, this.day);
    }

    @Override
    public int getDayOfYear() {
        int dayOfYear = 0;
        for (BMonth m = BMonth.january; m != this.month; m = m.next()) {
            dayOfYear += BAbsTime.getDaysInMonth(this.year, m);
        }
        return dayOfYear += this.day;
    }

    @Override
    public boolean isLeapDay() {
        return this.month == BMonth.february && this.day == 29;
    }

    public BDate add(int days) {
        int d;
        if (days == 0) {
            return this;
        }
        int y = this.year;
        if (days > 0) {
            while (d > BAbsTime.getDaysInYear(y)) {
                d -= BAbsTime.getDaysInYear(y);
                ++y;
            }
        } else {
            for (d = this.getDayOfYear() + days; d < 1; d += BAbsTime.getDaysInYear(--y)) {
            }
        }
        return BDate.makeDayOfYear(y, d);
    }

    public BDate subtract(int days) {
        return this.add(-days);
    }

    public int delta(BDate d2) {
        int n = this.compareTo(d2);
        if (n == 0) {
            return 0;
        }
        BDate d1 = this;
        int sign = 1;
        if (n > 0) {
            d1 = d2;
            d2 = this;
            sign = -1;
        }
        int y1 = d1.getYear();
        int y2 = d2.getYear();
        int z1 = d1.getDayOfYear();
        int z2 = d2.getDayOfYear();
        if (y1 == y2) {
            return sign * (z2 - z1);
        }
        int gap = 0;
        for (int i = y1 + 1; i < y2; ++i) {
            gap += BAbsTime.getDaysInYear(i);
        }
        return sign * (gap + z2 + (BAbsTime.getDaysInYear(y1) - z1));
    }

    public BDate nextDay() {
        return this.add(1);
    }

    public BDate prevDay() {
        return this.add(-1);
    }

    public BDate nextMonth() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (month == 11) {
            month = 0;
            ++year;
        } else if (day == BAbsTime.getDaysInMonth(year, BMonth.make(month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(++month));
        } else if (day > BAbsTime.getDaysInMonth(year, BMonth.make(++month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(month));
        }
        return BDate.make(year, BMonth.make(month), day);
    }

    public BDate prevMonth() {
        int year = this.getYear();
        int month = this.getMonth().getOrdinal();
        int day = this.getDay();
        if (month == 0) {
            month = 11;
            --year;
        } else if (day == BAbsTime.getDaysInMonth(year, BMonth.make(month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(--month));
        } else if (day > BAbsTime.getDaysInMonth(year, BMonth.make(--month))) {
            day = BAbsTime.getDaysInMonth(year, BMonth.make(month));
        }
        return BDate.make(year, BMonth.make(month), day);
    }

    public BDate nextYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return BDate.make(this.getYear() + 1, this.getMonth(), day);
    }

    public BDate prevYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return BDate.make(this.getYear() - 1, this.getMonth(), day);
    }

    public BDate next(BWeekday weekday) {
        BDate t = this.nextDay();
        while (t.getWeekday() != weekday) {
            t = t.nextDay();
        }
        return t;
    }

    public BDate prev(BWeekday weekday) {
        BDate t = this.prevDay();
        while (t.getWeekday() != weekday) {
            t = t.prevDay();
        }
        return t;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BDate(1970, BMonth.january, 1);
        TYPE = Sys.loadType(BDate.class);
    }
}

