/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.tag.ComponentRelations;
import com.tridium.sys.tag.ComponentTags;
import com.tridium.util.PxUtil;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.Tags;
import javax.baja.tag.util.ImpliedRelations;
import javax.baja.tag.util.ImpliedTags;
import javax.baja.tag.util.SmartRelationSet;
import javax.baja.tag.util.SmartTagSet;
import javax.baja.util.BConverter;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BServiceContainer;
import javax.baja.util.IFuture;

@NiagaraType
public class BComponent
extends BComplex
implements BISpaceNode,
BIProtected,
BICategorizable,
BIPropertyContainer,
BIEntity {
    @Generated
    public static final Type TYPE = Sys.loadType(BComponent.class);
    private static boolean moveMultiSheet = AccessController.doPrivileged(() -> System.getProperty("niagara.moveMultiSheet", "false")).equals("true");
    private static boolean hideWebWiresheet = AccessController.doPrivileged(() -> System.getProperty("niagara.hideWebWiresheet", "false")).equals("true");
    private static boolean hideWebCategoryBrowser = AccessController.doPrivileged(() -> System.getProperty("niagara.hideWebCategoryBrowser", "false")).equals("true");
    private static final BIcon icon = BIcon.std("object.png");
    private static final Logger LOG = Logger.getLogger("baja");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 404: {
                BISession session = this.getSession();
                if (session instanceof BObject) {
                    return ((BObject)((Object)session)).fw(x, a, b, c, d);
                }
                return null;
            }
            case 33: {
                return ((ComponentSlotMap)this.slotMap).isSubscribed((Subscriber)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public TagDictionaryService getTagDictionaryService() {
        BComponent root;
        BServiceContainer[] services;
        BComponentSpace space = this.getComponentSpace();
        if (space == null) {
            return null;
        }
        TagDictionaryService tdService = space.getTagDictionaryService();
        if (tdService != null) {
            BStatus bStatus = BStatus.ok;
            try {
                bStatus = (BStatus)((BComponent)((Object)tdService)).get("status");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bStatus.isValid()) {
                return tdService;
            }
        }
        if ((services = (root = space.getRootComponent()).getChildren(BServiceContainer.class)) == null || services.length == 0) {
            return null;
        }
        TagDictionaryService[] tagServices = services[0].getChildren(TagDictionaryService.class);
        if (tagServices == null || tagServices.length == 0) {
            return null;
        }
        if (tagServices[0] instanceof BComponent) {
            BStatus sValue = BStatus.ok;
            try {
                sValue = (BStatus)((BComponent)((Object)tagServices[0])).get("status");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!sValue.isValid()) {
                return null;
            }
        }
        space.setTagDictionaryService(tagServices[0]);
        return tagServices[0];
    }

    @Override
    public Tags tags() {
        TagDictionaryService service = this.getTagDictionaryService();
        if (service != null) {
            return new SmartTagSet(new ImpliedTags(service, this), new ComponentTags(this));
        }
        return new ComponentTags(this);
    }

    @Override
    public Relations relations() {
        TagDictionaryService service = this.getTagDictionaryService();
        if (service != null) {
            return new SmartRelationSet(new ImpliedRelations(service, this), new ComponentRelations(this));
        }
        return new ComponentRelations(this);
    }

    @Override
    public Optional<BOrd> getOrdToEntity() {
        return Optional.ofNullable(this.getAbsoluteOrd());
    }

    public Object getHandle() {
        return this.slotMap.getHandle();
    }

    public SlotPath getSlotPath() {
        return this.slotMap.getSlotPath();
    }

    public void clearHandles() {
        BComponent[] kids;
        if (this.isMounted()) {
            throw new IllegalStateException("Component is mounted");
        }
        ((ComponentSlotMap)this.slotMap).setHandle(null);
        for (BComponent kid : kids = this.getChildComponents()) {
            kid.clearHandles();
        }
    }

    public final boolean isRunning() {
        return this.slotMap.isRunning();
    }

    public final void start() {
        this.slotMap.start();
    }

    public final void stop() {
        this.slotMap.stop();
    }

    public void started() throws Exception {
    }

    public void descendantsStarted() throws Exception {
    }

    public void stopped() throws Exception {
    }

    public void descendantsStopped() throws Exception {
    }

    public void stationStarted() throws Exception {
    }

    public void atSteadyState() throws Exception {
    }

    public void clockChanged(BRelTime shift) throws Exception {
    }

    public final boolean isSubscribed() {
        return this.slotMap.isSubscribed();
    }

    public final Subscriber[] getSubscribers() {
        return this.slotMap.getSubscribers();
    }

    public void subscribed() {
    }

    public void unsubscribed() {
    }

    public final boolean isPermanentlySubscribed() {
        return this.slotMap.isPermanentlySubscribed();
    }

    protected final void setPermanentlySubscribed(boolean subscribed) {
        this.slotMap.setPermanentlySubscribed(subscribed);
    }

    public final long getLeaseExpiration() {
        return Nre.getLeaseManager().getLeaseExpiration(this);
    }

    @Override
    public final void lease() {
        this.lease(0, this.getDefaultLeaseTime());
    }

    public final void lease(int depth) {
        this.lease(depth, this.getDefaultLeaseTime());
    }

    @Override
    public final void lease(int depth, long millis) {
        Nre.getLeaseManager().lease(this, depth, millis);
    }

    public static void lease(BComponent[] components, int depth) {
        BComponentSpace space;
        BComponent first;
        long leaseTime = 60000L;
        if (components != null && components.length > 0 && (first = components[0]) != null && (space = first.getComponentSpace()) != null) {
            leaseTime = space.getDefaultLeaseTime();
        }
        BComponent.lease(components, depth, leaseTime);
    }

    public static void lease(BComponent[] components, int depth, long millis) {
        Nre.getLeaseManager().lease(components, depth, millis);
    }

    private long getDefaultLeaseTime() {
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            return space.getDefaultLeaseTime();
        }
        return 60000L;
    }

    @Override
    public final BSpace getSpace() {
        return this.getComponentSpace();
    }

    public final BComponentSpace getComponentSpace() {
        return this.slotMap == null ? null : this.slotMap.getSpace();
    }

    public boolean isComponentReadonly() {
        BComponentSpace space = this.getComponentSpace();
        if (space == null) {
            return false;
        }
        return space.isSpaceReadonly();
    }

    @Override
    public BOrd getOrdInSession() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make(base, this.getOrdInSpace());
    }

    @Override
    public BOrd getOrdInSpace() {
        return this.getHandleOrd();
    }

    public BOrd getHandleOrd() {
        Object handle = this.getHandle();
        if (handle == null) {
            return null;
        }
        return BOrd.make("h:" + handle);
    }

    public BOrd getSlotPathOrd() {
        SlotPath path = this.getSlotPath();
        if (path == null) {
            return null;
        }
        return BOrd.make(path);
    }

    @Override
    public final boolean isPendingMove() {
        return this.slotMap.isPendingMove();
    }

    @Override
    public void setPendingMove(boolean pendingMove) {
        this.slotMap.setPendingMove(pendingMove);
    }

    public String toPathString() {
        SlotPath path = this.getSlotPath();
        if (path == null) {
            return "?" + this.getType() + "?";
        }
        return path.getBody();
    }

    public String toDisplayPathString(Context cx) {
        SlotPath path = this.getSlotPath();
        if (path == null) {
            return "?" + this.getType() + "?";
        }
        return path.toDisplayString();
    }

    @Override
    public String getNavName() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.getRootComponent() == this) {
            return space.getNavName();
        }
        return null;
    }

    @Override
    public String getNavDisplayName(Context cx) {
        return this.getDisplayName(cx);
    }

    @Override
    public BINavNode getNavParent() {
        BComponent parent = (BComponent)this.getParent();
        if (parent != null) {
            return parent;
        }
        return this.getComponentSpace();
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        BValue child = this.get(navName);
        if (child instanceof BINavNode) {
            return (BINavNode)((Object)child);
        }
        return null;
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        BINavNode child = this.getNavChild(navName);
        if (child != null) {
            return child;
        }
        throw new UnresolvedException(navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.loadSlots();
        BComponent[] temp = new BComponent[this.getSlotCount()];
        SlotCursor<Property> c = this.getProperties();
        int count = 0;
        while (c.nextComponent()) {
            BComponent kid = (BComponent)c.get();
            if (Flags.isHidden(this, c.property()) || !kid.isNavChild()) continue;
            temp[count++] = kid;
        }
        BINavNode[] result = new BComponent[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public boolean isNavChild() {
        return true;
    }

    @Override
    public String getNavDescription(Context cx) {
        return this.getType().toString();
    }

    @Override
    public BOrd getNavOrd() {
        BComponentSpace space = this.getComponentSpace();
        if (space == null) {
            return null;
        }
        BOrd spaceOrd = space.getAbsoluteOrd();
        if (spaceOrd == null) {
            return null;
        }
        SlotPath path = this.getSlotPath();
        if (path == null) {
            return null;
        }
        return BOrd.make(spaceOrd, path);
    }

    @Override
    public BIcon getNavIcon() {
        return this.getIcon();
    }

    @Override
    public final Property add(String name, BValue value, int flags, BFacets facets, Context context) {
        return this.slotMap.add(name, flags, value, value.getSlotMap(), facets, context, null);
    }

    public final Property add(String name, BValue value, int flags, Context context) {
        return this.slotMap.add(name, flags, value, value.getSlotMap(), null, context, null);
    }

    public final Property add(String name, BValue value, int flags) {
        return this.slotMap.add(name, flags, value, value.getSlotMap(), null, null, null);
    }

    public final Property add(String name, BValue value, Context context) {
        return this.slotMap.add(name, 0, value, value.getSlotMap(), null, context, null);
    }

    public final Property add(String name, BValue value) {
        return this.slotMap.add(name, 0, value, value.getSlotMap(), null, null, null);
    }

    @Override
    public final void remove(String name, Context context) {
        Property property = this.getProperty(name);
        if (property == null) {
            throw new NoSuchSlotException(name);
        }
        this.remove(property, context);
    }

    @Override
    public final void remove(Property slot, Context context) {
        this.slotMap.remove(slot, context);
    }

    public final void remove(String name) {
        this.remove(name, null);
    }

    public final void remove(Property slot) {
        this.slotMap.remove(slot, null);
    }

    public final void remove(BComplex child) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Not my child");
        }
        this.slotMap.remove(child.getPropertyInParent(), null);
    }

    @Override
    public final void removeAll(Context context) {
        Property[] props;
        for (Property prop : props = this.slotMap.getPropertiesArray()) {
            if (prop.isFrozen()) continue;
            this.remove(prop, context);
        }
    }

    public final void removeAll() {
        this.removeAll(null);
    }

    @Override
    public final void rename(Property slot, String newName, Context context) {
        this.slotMap.rename(slot, newName, context);
    }

    public final void rename(Property slot, String newName) {
        this.slotMap.rename(slot, newName, null);
    }

    public BFormat getDisplayNameFormat(Property slot) {
        BNameMap nameMap = (BNameMap)this.get("displayNames");
        if (nameMap == null) {
            return null;
        }
        return nameMap.get(slot.getName());
    }

    public final void setDisplayName(Property slot, BFormat newName, Context context) {
        BNameMap nameMap = (BNameMap)this.get("displayNames");
        HashMap<String, BFormat> newMap = new HashMap<String, BFormat>();
        if (nameMap != null) {
            String[] keys;
            for (String key : keys = nameMap.list()) {
                newMap.put(key, nameMap.get(key));
            }
        }
        if (newName == null || newName.getFormat().isEmpty()) {
            newMap.remove(slot.getName());
        } else {
            newMap.put(slot.getName(), newName);
        }
        if (newMap.isEmpty()) {
            if (nameMap != null) {
                this.remove("displayNames", context);
            }
        } else {
            boolean toAdd = nameMap == null;
            nameMap = BNameMap.make(newMap);
            if (toAdd) {
                this.add("displayNames", nameMap, 4, context);
            } else {
                this.set("displayNames", (BValue)nameMap, context);
            }
        }
    }

    @Override
    public final void reorder(Property[] dynamicProperties, Context context) {
        this.slotMap.reorder(dynamicProperties, context);
    }

    public final void reorder(Property[] dynamicProperties) {
        this.slotMap.reorder(dynamicProperties, null);
    }

    @Override
    public final void reorderToTop(Property dynamicProperty, Context context) {
        this.slotMap.reorderToTop(dynamicProperty, context);
    }

    public final void reorderToTop(Property dynamicProperty) {
        this.slotMap.reorderToTop(dynamicProperty, null);
    }

    @Override
    public final void reorderToBottom(Property dynamicProperty, Context context) {
        this.slotMap.reorderToBottom(dynamicProperty, context);
    }

    public final void reorderToBottom(Property dynamicProperty) {
        this.slotMap.reorderToBottom(dynamicProperty, null);
    }

    public BValue getActionParameterDefault(Action action) {
        return action.getParameterDefault();
    }

    public final BValue invoke(Action action, BValue argument, Context context) throws ActionInvokeException {
        return this.slotMap.invoke(action, argument, context);
    }

    public final BValue invoke(Action action, BValue argument) throws ActionInvokeException {
        return this.slotMap.invoke(action, argument, null);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        Nre.getEngineManager().enqueueAction(this, action, argument);
        return null;
    }

    public void doInvoke(Action action, BValue argument, Context cx) throws ActionInvokeException {
        EngineUtil.doInvoke(this, action, argument, cx);
    }

    public final void fire(Topic topic, BValue event, Context context) {
        this.slotMap.fire(topic, event, context);
    }

    public final void fire(Topic topic, BValue event) {
        this.slotMap.fire(topic, event, null);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
    }

    public void checkRemove(Property property, Context context) {
    }

    public void checkRename(Property property, String newName, Context context) {
    }

    public void checkReorder(Property[] properties, Context context) {
    }

    public void checkSetFlags(Slot slot, int flags, Context context) {
    }

    public void checkSetFacets(Slot slot, BFacets facets, Context context) {
    }

    public boolean isParentLegal(BComponent parent) {
        return true;
    }

    public boolean isChildLegal(BComponent child) {
        return true;
    }

    public void changed(Property property, Context context) {
    }

    public void added(Property property, Context context) {
    }

    public void removed(Property property, BValue oldValue, Context context) {
    }

    public void renamed(Property property, String oldName, Context context) {
    }

    public void reordered(Context context) {
    }

    public void flagsChanged(Slot slot, Context context) {
    }

    public void facetsChanged(Slot slot, Context context) {
    }

    public void recategorized(Context context) {
    }

    public void childParented(Property property, BValue newChild, Context context) {
    }

    public void childUnparented(Property property, BValue oldChild, Context context) {
    }

    public void knobAdded(Knob knob, Context context) {
    }

    public void knobRemoved(Knob knob, Context context) {
    }

    public void relationKnobAdded(RelationKnob knob, Context context) {
    }

    public void relationKnobRemoved(RelationKnob knob, Context context) {
    }

    public void batchChanged(Property[] properties, Context context) {
    }

    public synchronized BComponent[] getChildComponents() {
        BComponent[] temp = new BComponent[this.getSlotCount()];
        SlotCursor<Property> c = this.getProperties();
        int count = 0;
        while (c.nextComponent()) {
            temp[count++] = (BComponent)c.get();
        }
        BComponent[] result = new BComponent[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized <T> T[] getChildren(Class<T> cls) {
        ArrayList<BValue> result = new ArrayList<BValue>();
        SlotCursor<Property> c = this.getProperties();
        while (c.next(cls)) {
            result.add(c.get());
        }
        return result.toArray((Object[])Array.newInstance(cls, result.size()));
    }

    public BValue getMixIn(Type type) {
        return this.get(type.toString().replace(':', '_'));
    }

    public final LinkCheck checkLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        LinkCheck check = LinkCheck.make(source, sourceSlot, this, targetSlot, cx);
        if (check.isValid()) {
            check = this.doCheckLink(source, sourceSlot, targetSlot, cx);
        }
        return check;
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        return LinkCheck.makeValid();
    }

    public BLink makeLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        BOrd srcOrd = source.getHandleOrd();
        Type sourceType = null;
        if (sourceSlot.isAction()) {
            sourceType = sourceSlot.asAction().getParameterType();
        } else if (sourceSlot.isTopic()) {
            sourceType = sourceSlot.asTopic().getEventType();
        } else if (sourceSlot.isProperty()) {
            sourceType = sourceSlot.asProperty().getType();
        }
        Type targetType = null;
        if (targetSlot.isAction()) {
            targetType = targetSlot.asAction().getParameterType();
        } else if (targetSlot.isTopic()) {
            targetType = targetSlot.asTopic().getEventType();
        } else if (targetSlot.isProperty()) {
            targetType = targetSlot.asProperty().getType();
        }
        if (sourceType != null && targetType != null && !sourceType.is(targetType)) {
            Registry registry = Sys.getRegistry();
            TypeInfo[] adapters = registry.getAdapters(sourceType.getTypeInfo(), targetType.getTypeInfo());
            for (int i = adapters.length - 1; i >= 0; --i) {
                if (!registry.isAgent(adapters[i], BConversionLink.TYPE.getTypeInfo())) continue;
                return new BConversionLink(srcOrd, sourceSlot.getName(), targetSlot.getName(), true, (BConverter)adapters[i].getInstance());
            }
        }
        return new BLink(srcOrd, sourceSlot.getName(), targetSlot.getName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLink[] getLinks() {
        this.loadSlots();
        BComponent bComponent = this;
        synchronized (bComponent) {
            BLink[] temp = new BLink[this.getSlotCount()];
            int count = 0;
            SlotCursor<Property> c = this.slotMap.getProperties();
            while (c.nextObject()) {
                BValue child = c.get();
                if (!(child instanceof BLink)) continue;
                temp[count++] = (BLink)child;
            }
            BLink[] result = new BLink[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLink[] getLinks(Slot slot) {
        this.loadSlots();
        BComponent bComponent = this;
        synchronized (bComponent) {
            String name = slot.getName();
            BLink[] temp = new BLink[this.getSlotCount()];
            int count = 0;
            SlotCursor<Property> c = this.slotMap.getProperties();
            while (c.nextObject()) {
                BLink link;
                BValue child = c.get();
                if (!(child instanceof BLink) || !(link = (BLink)child).getTargetSlotName().equals(name)) continue;
                temp[count++] = (BLink)child;
            }
            BLink[] result = new BLink[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
    }

    public synchronized int getKnobCount() {
        return this.slotMap.getKnobCount();
    }

    public synchronized Knob[] getKnobs() {
        return this.slotMap.getKnobs();
    }

    public synchronized Knob[] getKnobs(Slot slot) {
        return this.slotMap.getKnobs(slot);
    }

    public boolean isLinkTarget(Slot slot) {
        return this.getLinks(slot).length > 0;
    }

    public BLink linkTo(BComponent source, Slot sourceSlot, Slot targetSlot) {
        return this.linkTo(null, source, sourceSlot, targetSlot);
    }

    public BLink linkTo(String propertyName, BComponent source, Slot sourceSlot, Slot targetSlot) {
        BLink link = new BLink(source, sourceSlot, targetSlot);
        this.add(propertyName, (BValue)link, 2);
        link.activate();
        return link;
    }

    public BRelation makeRelation(Id id, BComponent endpoint, Context cx) {
        BOrd srcOrd = endpoint.getHandleOrd();
        return new BRelation(id, srcOrd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BRelation[] getComponentRelations() {
        this.loadSlots();
        BComponent bComponent = this;
        synchronized (bComponent) {
            BRelation[] temp = new BRelation[this.getSlotCount()];
            int count = 0;
            SlotCursor<Property> c = this.slotMap.getProperties();
            while (c.nextObject()) {
                BValue child = c.get();
                if (!(child instanceof BRelation)) continue;
                temp[count++] = (BRelation)child;
            }
            BRelation[] result = new BRelation[count];
            System.arraycopy(temp, 0, result, 0, count);
            return result;
        }
    }

    public synchronized int getRelationKnobCount() {
        try {
            return this.slotMap.getRelationKnobCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public synchronized RelationKnob[] getRelationKnobs() {
        return this.slotMap.getRelationKnobs();
    }

    public synchronized RelationKnob getRelationKnob(Id id) {
        return this.slotMap.getRelationKnob(id.getQName());
    }

    public boolean isRelationTarget() {
        return this.getComponentRelations().length > 0;
    }

    public BRelation relateTo(Id id, BComponent endpoint) {
        return this.relateTo(null, id, endpoint);
    }

    public BRelation relateTo(String propertyName, Id id, BComponent endpoint) {
        BRelation relation = new BRelation(id, endpoint);
        this.add(propertyName, (BValue)relation, 2);
        relation.activateRelation();
        return relation;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        return this.slotMap.getAppliedCategoryMask();
    }

    @Override
    public BCategoryMask getCategoryMask() {
        return this.slotMap.getCategoryMask();
    }

    public void setCategoryMask(BCategoryMask mask, Context cx) {
        this.slotMap.setCategoryMask(mask, cx);
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        BPermissions permissions = this.slotMap.getCachedPermissions();
        if (permissions == null) {
            permissions = cx != null && cx.getUser() != null ? cx.getUser().getPermissionsFor(this) : BPermissions.all;
        }
        return permissions;
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        if (cx.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = cx.getSlotInComponent();
        BPermissions permissions = cx.getPermissionsForTarget();
        if (slot == null) {
            return permissions.has(1);
        }
        if (Flags.isOperator(this, slot)) {
            return permissions.has(1);
        }
        return permissions.has(16);
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        if (cx.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = cx.getSlotInComponent();
        BPermissions permissions = cx.getPermissionsForTarget();
        if (slot == null) {
            return permissions.has(2);
        }
        if (Flags.isReadonly(this, slot)) {
            return false;
        }
        if (Flags.isOperator(this, slot)) {
            return permissions.has(2);
        }
        return permissions.has(32);
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        if (cx.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = cx.getSlotInComponent();
        BPermissions permissions = cx.getPermissionsForTarget();
        if (slot == null) {
            return permissions.has(4);
        }
        if (Flags.isOperator(this, slot)) {
            return permissions.has(4);
        }
        return permissions.has(64);
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        int prop = list.indexOf("workbench:PropertySheet");
        int ws = list.indexOf("wiresheet:WireSheet");
        if (prop >= 0) {
            int ms;
            if (ws >= 0) {
                if (this instanceof BFolder) {
                    if (prop < ws) {
                        list.swap(prop, ws);
                        prop = ws;
                    }
                } else if (ws < prop) {
                    list.swap(prop, ws);
                    prop = ws;
                }
            }
            if (moveMultiSheet && (ms = list.indexOf("webEditors:MultiSheet")) >= 0) {
                list.remove(ms);
                list.add(prop, "webEditors:MultiSheet");
            }
        }
        if (hideWebWiresheet) {
            list.remove("wiresheet:WebWiresheet");
        } else {
            int ws2 = list.indexOf("wiresheet:WireSheet");
            list.add(ws2 + 1, "wiresheet:WebWiresheet");
        }
        list.toBottom("wbutil:CategorySheet");
        if (hideWebCategoryBrowser) {
            list.remove("webEditors:UxCategoryBrowser");
        } else {
            list.toBottom("webEditors:UxCategoryBrowser");
        }
        list.toBottom("workbench:SlotSheet");
        list.toBottom("workbench:LinkSheet");
        list.toBottom("tagdictionary:RelationManager");
        list.toBottom("workbench:RelationSheet");
        list.toBottom("pxEditor:PxEditor");
        if (PxUtil.HIDE_UX_BUILDER) {
            list.remove("uxBuilder:UxBuilder");
        } else {
            list.toBottom("uxBuilder:UxBuilder");
        }
        for (int i = 0; i < list.size(); ++i) {
            AgentInfo agentInfo = list.get(i);
            if (!agentInfo.getAgentType().is(BAbstractPxView.TYPE)) continue;
            list.toTop(agentInfo);
        }
        Property[] props = this.getPropertiesArray();
        for (int i = props.length - 1; i >= 0; --i) {
            BValue value;
            if (props[i].getTypeAccess() != 7 || !((value = this.get(props[i])) instanceof AgentInfo)) continue;
            list.add((AgentInfo)((Object)value));
        }
        PxUtil.explode(list);
        return list;
    }

    @Override
    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }

    protected static Action newAction(int flags, BValue parameterDefault, BFacets facets) {
        if (facets == null) {
            facets = BFacets.NULL;
        }
        return new NAction(flags, parameterDefault, facets);
    }

    protected static Action newAction(int flags, BValue parameterDefault) {
        return BComponent.newAction(flags, parameterDefault, null);
    }

    protected static Action newAction(int flags, BFacets facets) {
        return BComponent.newAction(flags, null, facets);
    }

    protected static Action newAction(int flags) {
        return BComponent.newAction(flags, null, null);
    }

    protected static Topic newTopic(int flags, BFacets facets) {
        if (facets == null) {
            facets = BFacets.NULL;
        }
        return new NTopic(flags, facets);
    }

    protected static Topic newTopic(int flags) {
        return BComponent.newTopic(flags, null);
    }

    @Override
    protected void spyRelations(SpyWriter out) {
        BComponent comp = this;
        TagDictionaryService service = this.getTagDictionaryService();
        BRelation[] directRelations = comp.getComponentRelations();
        if (service != null) {
            ArrayList<DataPolicy> dataPolicies;
            block22: {
                RelationKnob[] rKnobs;
                ImpliedRelations impliedRelations = new ImpliedRelations(service, this);
                boolean first = true;
                for (Relation relation : impliedRelations) {
                    if (first) {
                        out.trTitle("Relations Implied", 2);
                        first = false;
                    }
                    String dir = IN;
                    if (relation.isOutbound()) {
                        dir = OUT;
                    }
                    dir = dir + ((BISpaceNode)((Object)relation.getEndpoint())).getNavOrd();
                    out.prop((Object)relation.getId(), dir);
                }
                first = true;
                for (BRelation relation : directRelations) {
                    if (!relation.isOutbound()) continue;
                    if (first) {
                        out.trTitle("Relations Direct", 2);
                        first = false;
                    }
                    String dir = OUT;
                    try {
                        out.prop((Object)relation.getId(), dir + ((BISpaceNode)((Object)relation.getEndpoint())).getNavOrd());
                    }
                    catch (Exception e) {
                        out.prop((Object)relation.getId(), dir + "Unresolved: " + relation.getEndpointOrd());
                    }
                }
                for (RelationKnob rKnob : rKnobs = comp.getRelationKnobs()) {
                    BRelation relation = null;
                    String dir = null;
                    try {
                        boolean isProxy = ((NRelationKnob)rKnob).isProxy();
                        if (isProxy) {
                            BComponent relationParent = (BComponent)rKnob.getRelationOrd().resolve(comp.getComponentSpace()).get();
                            for (BRelation bRelation : relationParent.getComponentRelations()) {
                                if (!bRelation.getId().getQName().equals(rKnob.getRelationId())) continue;
                                relation = bRelation;
                                break;
                            }
                            if (relation == null) {
                                continue;
                            }
                        } else {
                            relation = rKnob.getRelation();
                        }
                        dir = relation.isOutbound() ? OUT : IN;
                        out.prop((Object)relation.getId(), dir + ((BISpaceNode)((Object)relation.getEndpoint())).getNavOrd());
                    }
                    catch (Exception e) {
                        if (relation != null) {
                            out.prop((Object)relation.getId(), dir + "Unresolved: " + relation.getEndpointOrd());
                            continue;
                        }
                        out.prop((Object)rKnob.getRelationOrd(), "Unresolved: " + rKnob.getRelationOrd());
                    }
                }
                ComponentTags directTags = new ComponentTags(this);
                dataPolicies = new ArrayList<DataPolicy>();
                for (Object directTag : directTags) {
                    Optional<DataPolicy> dataPolicyForTag = service.getDataPolicyForTag(((Tag)directTag).getId());
                    if (!dataPolicyForTag.isPresent()) continue;
                    dataPolicies.add(dataPolicyForTag.get());
                }
                try {
                    Collection<DataPolicy> tgPolicies = DataPolicy.getDataPolicy(this);
                    for (DataPolicy tgPolicy : tgPolicies) {
                        dataPolicies.add(tgPolicy);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block22;
                    LOG.log(Level.FINE, "Failed to fetch the data policy for " + comp.toPathString() + " while generating spy page", e);
                }
            }
            if (!dataPolicies.isEmpty()) {
                out.trTitle("DataPolicy", 2);
                for (DataPolicy dataPolicy : dataPolicies) {
                    if (!(dataPolicy instanceof BComponent)) continue;
                    BComponent dpComp = (BComponent)((Object)dataPolicy);
                    out.prop((Object)dpComp.getName(), dpComp.getSlotPath());
                }
            }
        }
    }

    @Override
    protected void spyTags(SpyWriter out) {
        BComponent comp = this;
        TagDictionaryService service = this.getTagDictionaryService();
        ComponentTags directTags = new ComponentTags(this);
        Object impliedTags = null;
        if (service != null) {
            boolean first = true;
            for (Tag tag : service.getImpliedTags(this)) {
                if (first) {
                    out.trTitle("Tags Implied", 2);
                    first = false;
                }
                out.prop((Object)tag.getId(), tag.getValue());
            }
            first = true;
            for (Tag tag : directTags) {
                if (first) {
                    out.trTitle("Tags Direct", 2);
                    first = false;
                }
                out.prop((Object)tag.getId(), tag.getValue());
            }
        }
    }
}

