/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NProperty;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Knob;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.TypeIntrospectionException;
import javax.baja.util.BFacetsMap;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

@NiagaraType
public abstract class BComplex
extends BValue {
    @Generated
    public static final Type TYPE = Sys.loadType(BComplex.class);
    private static CopyHints copyHintsDefault = new CopyHints();
    private static CopyHints copyHintsExact = new CopyHints();
    protected static String IN;
    protected static String OUT;
    ComplexSlotMap slotMap;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    BComplex() {
        ComplexType type = (ComplexType)this.getType();
        if (type.getTypeClass() != this.getClass() && !this.getClass().getName().startsWith("auto.") && this.getClass().getEnclosingClass() == null) {
            throw new TypeIntrospectionException(this.getClass(), "Class does override the getType() method");
        }
        this.slotMap = type.newSlotMap();
        this.slotMap.init(type, this);
    }

    public final String getName() {
        return this.slotMap.getName();
    }

    public final String getDisplayName(Context c) {
        return this.slotMap.getDisplayName(c);
    }

    public String getDisplayName(Slot slot, Context cx) {
        BValue val;
        BNameMap map;
        BFormat format;
        BValue displayNames = this.get("displayNames");
        if (displayNames instanceof BNameMap && (format = (map = (BNameMap)displayNames).get(slot.getName())) != null) {
            return format.format(null, cx);
        }
        if (slot.isDynamic() && (val = this.get((Property)slot)) instanceof BIMixIn) {
            return ((BIMixIn)((Object)val)).getDisplayNameInParent(cx);
        }
        return slot.getDefaultDisplayName(cx);
    }

    public final BComplex getParent() {
        return this.slotMap.getParent();
    }

    public final Property getPropertyInParent() {
        return this.slotMap.getPropertyInParent();
    }

    public final BComponent getParentComponent() {
        BComplex p = this;
        while (!p.isComponent()) {
            if ((p = p.getParent()) != null) continue;
            return null;
        }
        return p.asComponent();
    }

    public final Property getPropertyInParentComponent() {
        if (this.isComponent() || this.getParent() == null) {
            return null;
        }
        BComplex p = this;
        while (!p.getParent().isComponent()) {
            if ((p = p.getParent()).getParent() != null) continue;
            return null;
        }
        return p.getPropertyInParent();
    }

    public boolean isDescendentOf(BComponent ancestor) {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized BValue newCopy() {
        return this.slotMap.newCopy(copyHintsDefault, BComplex.copySerialNum());
    }

    @Override
    public final synchronized BValue newCopy(boolean exact) {
        return this.slotMap.newCopy(exact ? copyHintsExact : copyHintsDefault, BComplex.copySerialNum());
    }

    @Override
    public final synchronized BValue newCopy(CopyHints hints) {
        return this.slotMap.newCopy(hints, BComplex.copySerialNum());
    }

    public final void copyFrom(BComplex object, Context context) {
        this.slotMap.copyFrom(object.slotMap, context);
    }

    public final void copyFrom(BComplex object) {
        this.slotMap.copyFrom(object.slotMap, Context.copying);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public synchronized boolean equivalent(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.slotMap.equivalent(((BComplex)obj).slotMap);
    }

    public final void setFacets(Slot slot, BFacets facets) {
        this.setFacets(slot, facets, null);
    }

    public final void setFacets(Slot slot, BFacets facets, Context context) {
        if (slot.isFrozen()) {
            BComplex p = this;
            BComponent parent = null;
            StringBuilder path = new StringBuilder();
            while (!p.isComponent()) {
                path.insert(0, '/');
                path.insert(0, p.getName());
                if ((p = p.getParent()) != null) continue;
            }
            if (p != null) {
                parent = p.asComponent();
            }
            if (parent != null && parent instanceof BComponent) {
                BFacetsMap facetsMap = (BFacetsMap)parent.get("slotFacets_");
                HashMap<String, BFacets> newMap = new HashMap<String, BFacets>();
                if (facetsMap != null) {
                    String[] keys;
                    for (String key : keys = facetsMap.list()) {
                        newMap.put(key, facetsMap.get(key));
                    }
                }
                if (facets.isNull()) {
                    newMap.remove(path.toString() + slot.getName());
                } else {
                    newMap.put(path.toString() + slot.getName(), BFacets.makeRemove(facets, slot.getFacets().list()));
                }
                if (newMap.isEmpty()) {
                    if (facetsMap != null) {
                        parent.remove("slotFacets_", context);
                    }
                } else {
                    boolean toAdd = facetsMap == null;
                    facetsMap = BFacetsMap.make(newMap);
                    if (toAdd) {
                        parent.add("slotFacets_", facetsMap, 4, context);
                    } else {
                        parent.set("slotFacets_", (BValue)facetsMap, context);
                    }
                }
            }
        } else {
            this.slotMap.setFacets(slot, facets, context);
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.isFrozen()) {
            BFacets facets;
            BFacetsMap facetsMap;
            BComplex p = this;
            StringBuilder path = null;
            while (!p.isComponent()) {
                if (path == null) {
                    path = new StringBuilder();
                }
                path.insert(0, '/');
                path.insert(0, p.getName());
                if ((p = p.getParent()) != null) continue;
            }
            if (p != null && (facetsMap = (BFacetsMap)p.get("slotFacets_")) != null && (facets = facetsMap.get(path == null ? slot.getName() : path.toString() + slot.getName())) != null) {
                return BFacets.make(facets, slot.getFacets());
            }
        }
        return slot.getFacets();
    }

    public String propertyValueToString(Property prop, Context cx) {
        BFacets facets = this.getSlotFacets(prop);
        if (cx == null) {
            cx = facets;
        } else if (!facets.isNull()) {
            cx = new BasicContext(cx, facets);
        }
        return this.get(prop).toString(cx);
    }

    public final BComplex loadSlots() {
        this.slotMap.loadSlots();
        return this;
    }

    public final Slot getSlot(String name) {
        return this.slotMap.getSlot(name);
    }

    public final Property getProperty(String name) {
        return (Property)this.slotMap.getSlot(name);
    }

    public final Action getAction(String name) {
        return (Action)this.slotMap.getSlot(name);
    }

    public final Topic getTopic(String name) {
        return (Topic)this.slotMap.getSlot(name);
    }

    public final int getSlotCount() {
        return this.slotMap.getSlotCount();
    }

    public final int getSlotCount(Class<?> cls) {
        int count = 0;
        SlotCursor<Property> c = this.getProperties();
        while (c.next(cls)) {
            ++count;
        }
        return count;
    }

    public final Slot[] getSlotsArray() {
        return this.slotMap.getSlotsArray();
    }

    public final SlotCursor<Slot> getSlots() {
        return this.slotMap.getSlots();
    }

    public final Property[] getPropertiesArray() {
        return this.slotMap.getPropertiesArray();
    }

    public final Property[] getFrozenPropertiesArray() {
        return this.slotMap.getFrozenPropertiesArray();
    }

    public final Property[] getDynamicPropertiesArray() {
        return this.slotMap.getDynamicPropertiesArray();
    }

    public int getPropertyCount() {
        return this.slotMap.getPropertyCount();
    }

    public final SlotCursor<Property> getProperties() {
        return this.slotMap.getProperties();
    }

    public final Action[] getActionsArray() {
        return this.slotMap.getActionsArray();
    }

    public final SlotCursor<Action> getActions() {
        return this.slotMap.getActions();
    }

    public final Topic[] getTopicsArray() {
        return this.slotMap.getTopicsArray();
    }

    public final SlotCursor<Topic> getTopics() {
        return this.slotMap.getTopics();
    }

    public final BValue get(Property property) {
        return this.slotMap.get(property);
    }

    public final boolean getBoolean(Property property) {
        return this.slotMap.getBoolean(property);
    }

    public final int getInt(Property property) {
        return this.slotMap.getInt(property);
    }

    public final long getLong(Property property) {
        return this.slotMap.getLong(property);
    }

    public final float getFloat(Property property) {
        return this.slotMap.getFloat(property);
    }

    public final double getDouble(Property property) {
        return this.slotMap.getDouble(property);
    }

    public final String getString(Property property) {
        return this.slotMap.getString(property);
    }

    public final BValue get(String propertyName) {
        return this.slotMap.get(propertyName);
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return null;
    }

    public final void set(Property[] properties, BValue[] values, Context context) {
        this.slotMap.set(properties, values, context);
    }

    public final void set(Property property, BValue value, Context context) {
        BValue oldValue = this.get(property);
        ComplexSlotMap oldMap = oldValue == null ? null : oldValue.getSlotMap();
        this.slotMap.set(property, oldValue, oldMap, value, value.getSlotMap(), context);
    }

    public final void set(Property property, BValue value) {
        this.set(property, value, null);
    }

    public final void setBoolean(Property property, boolean value, Context context) {
        this.slotMap.setBoolean(property, value, context);
    }

    public final void setInt(Property property, int value, Context context) {
        this.slotMap.setInt(property, value, context);
    }

    public final void setLong(Property property, long value, Context context) {
        this.slotMap.setLong(property, value, context);
    }

    public final void setFloat(Property property, float value, Context context) {
        this.slotMap.setFloat(property, value, context);
    }

    public final void setDouble(Property property, double value, Context context) {
        this.slotMap.setDouble(property, value, context);
    }

    public final void setString(Property property, String value, Context context) {
        this.slotMap.setString(property, value, context);
    }

    public final void setBoolean(Property property, boolean value) {
        this.slotMap.setBoolean(property, value, null);
    }

    public final void setInt(Property property, int value) {
        this.slotMap.setInt(property, value, null);
    }

    public final void setLong(Property property, long value) {
        this.slotMap.setLong(property, value, null);
    }

    public final void setFloat(Property property, float value) {
        this.slotMap.setFloat(property, value, null);
    }

    public final void setDouble(Property property, double value) {
        this.slotMap.setDouble(property, value, null);
    }

    public final void setString(Property property, String value) {
        this.slotMap.setString(property, value, null);
    }

    public final void set(String propertyName, BValue value) {
        Property prop = this.getProperty(propertyName);
        if (prop == null) {
            throw new NoSuchSlotException(propertyName);
        }
        this.set(prop, value);
    }

    public final void set(String name, BValue value, Context context) {
        Property p = this.getProperty(name);
        if (p == null) {
            throw new NoSuchSlotException("No such slot: " + name);
        }
        this.set(p, value, context);
    }

    public final int getFlags(Slot slot) {
        return this.slotMap.getFlags(slot);
    }

    public final void setFlags(Slot slot, int flags) {
        this.slotMap.setFlags(slot, flags, null);
    }

    public final void setFlags(Slot slot, int flags, Context context) {
        this.slotMap.setFlags(slot, flags, context);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        this.spyProperties(out);
        this.spyActions(out);
        this.spyTopics(out);
        this.spyKnobs(out);
        this.spySubscribers(out);
        this.spySpaceNode(out);
        this.spyTags(out);
        this.spyRelations(out);
        this.spyDebug(out);
        out.endProps();
    }

    void spyProperties(SpyWriter out) {
        this.loadSlots();
        BComponent comp = (BComponent)this;
        BPermissions perm = comp.getPermissions(out.getContext());
        SlotCursor<Property> c = this.getProperties();
        boolean firstProp = true;
        while (c.next()) {
            Property p = c.property();
            BValue v = c.get();
            boolean canSpy = false;
            if (!perm.hasAdminRead() && perm.hasOperatorRead()) {
                if ((v.isSimple() || v.isStruct()) && Flags.isOperator(this, c.slot())) {
                    canSpy = true;
                } else if (v.isComponent() && ((BComponent)v).getPermissions(out.getContext()).hasOperatorRead()) {
                    canSpy = true;
                }
            } else if (perm.hasAdminRead()) {
                canSpy = true;
            }
            if (!canSpy) continue;
            if (firstProp) {
                out.trTitle("Properties", 2);
                firstProp = false;
            }
            String name = p.getName();
            this.spySlot(out, name, this.getFlags(p), v);
        }
    }

    void spyActions(SpyWriter out) {
        Action[] actions = this.getActionsArray();
        if (actions.length == 0) {
            return;
        }
        boolean firstAction = true;
        BComponent comp = (BComponent)this;
        BPermissions perm = comp.getPermissions(out.getContext());
        for (Action action : actions) {
            if (!perm.hasAdminRead() && (perm.hasAdminRead() || !perm.hasOperatorRead() || !Flags.isOperator(this, action))) continue;
            if (firstAction) {
                out.trTitle("Actions", 2);
                firstAction = false;
            }
            this.spySlot(out, action.getName(), this.getFlags(action), action);
        }
    }

    void spyTopics(SpyWriter out) {
        Topic[] topics = this.getTopicsArray();
        if (topics.length == 0) {
            return;
        }
        boolean firstTopic = true;
        BComponent comp = (BComponent)this;
        BPermissions perm = comp.getPermissions(out.getContext());
        for (Topic topic : topics) {
            if (!perm.hasAdminRead() && (perm.hasAdminRead() || !perm.hasOperatorRead() || !Flags.isOperator(this, topic))) continue;
            if (firstTopic) {
                out.trTitle("Topics", 2);
                firstTopic = false;
            }
            this.spySlot(out, topic.getName(), this.getFlags(topic), topic);
        }
    }

    void spySlot(SpyWriter out, String name, int flags, Object value) {
        Slot slot = this.getSlot(name);
        if (slot.isProperty()) {
            name = "<a href='" + out.href(SlotPath.escape(name)) + "'>" + name + "</a>";
        }
        out.w("<tr><td align='left' nowrap='true'><b>").w(name).w("</b>");
        if (flags == 0) {
            out.w("{0}");
        } else {
            out.w(" {").w(Flags.encodeToString(flags)).w("}");
        }
        out.w("</td><td align='left' nowrap='true'>").safe(value.toString()).w("</td></tr>\n");
    }

    void spyKnobs(SpyWriter out) {
        RelationKnob[] rknobs;
        if (!this.isComponent()) {
            return;
        }
        Knob[] knobs = this.asComponent().getKnobs();
        if (knobs.length > 0) {
            out.trTitle("Knobs", 2);
            for (Knob knob : knobs) {
                out.prop((Object)knob.getSourceSlotName(), knob.getLink());
            }
        }
        if ((rknobs = this.asComponent().getRelationKnobs()).length == 0) {
            return;
        }
        out.trTitle("RelationKnobs", 2);
        for (RelationKnob rknob : rknobs) {
            if (rknob == null) break;
            BRelation relation = null;
            if (((NRelationKnob)rknob).isProxy()) {
                BComponent relationParent = (BComponent)rknob.getRelationOrd().resolve(this.asComponent().getComponentSpace()).get();
                for (BRelation bRelation : relationParent.getComponentRelations()) {
                    if (!bRelation.getId().getQName().equals(rknob.getRelationId())) continue;
                    relation = bRelation;
                    break;
                }
                if (relation == null) {
                    continue;
                }
            } else if (this.asComponent().isRunning()) {
                relation = rknob.getRelation();
            }
            if (relation == null) continue;
            try {
                SlotPath slotPath = relation.getParent().asComponent().getSlotPath();
                BOrd targetOrd = rknob.getRelationOrd();
                out.prop((Object)rknob.getRelationId(), IN + slotPath);
            }
            catch (Exception e) {
                out.prop((Object)rknob.getRelationId(), e);
            }
        }
    }

    void spySubscribers(SpyWriter out) {
        if (!this.isComponent()) {
            return;
        }
        Subscriber[] subs = this.asComponent().getSubscribers();
        if (subs.length == 0) {
            return;
        }
        out.trTitle("Subscribers", 2);
        for (Subscriber sub : subs) {
            out.w("<tr><td colspan='2'>").safe(sub).w("</td></tr>");
        }
    }

    void spySpaceNode(SpyWriter out) {
        if (!this.isComponent()) {
            return;
        }
        BComponent c = (BComponent)this;
        out.trTitle("SpaceNode", 2);
        out.prop((Object)"isMounted", c.isMounted());
        out.prop((Object)"handle", c.getHandle());
        out.prop((Object)"slotPath", c.getSlotPath());
        out.prop((Object)"host", c.getHost());
        out.prop((Object)"session", c.getSession());
        out.prop((Object)"space", c.getSpace());
        out.prop((Object)"absoluteOrd", c.getAbsoluteOrd());
        out.prop((Object)"ordInHost", c.getOrdInHost());
        out.prop((Object)"ordInSession", c.getOrdInSession());
        out.prop((Object)"ordInSpace", c.getOrdInSpace());
        out.prop((Object)"handleOrd", c.getHandleOrd());
        out.prop((Object)"slotPathOrd", c.getSlotPathOrd());
        out.prop((Object)"navOrd", c.getNavOrd());
    }

    protected void spyRelations(SpyWriter out) {
    }

    protected void spyTags(SpyWriter out) {
    }

    void spyDebug(SpyWriter out) {
        out.trTitle("Debug", 2);
        out.prop((Object)"debugString", this.toDebugString());
        out.prop((Object)"type", this.getType());
        out.prop((Object)"parent", this.getParent());
        out.prop((Object)"propertyInParent", this.getPropertyInParent());
        if (this.isComponent()) {
            BComponent comp = (BComponent)this;
            out.prop((Object)"running", comp.isRunning());
            out.prop((Object)"subscribed", comp.isSubscribed());
            out.prop((Object)"permanentlySubscribed", comp.isPermanentlySubscribed());
            out.prop((Object)"knobCount", comp.getKnobCount());
            out.prop((Object)"relationKnobCount", comp.getRelationKnobCount());
            out.prop((Object)"permissions", comp.getPermissions(out.getContext()));
            out.prop((Object)"slotsLoaded", ((ComponentSlotMap)this.slotMap).isBrokerPropsLoaded());
            out.prop((Object)"categoryMask", comp.getCategoryMask());
            out.prop((Object)"appliedCategoryMask", comp.getAppliedCategoryMask());
            out.prop((Object)"deepOrCategoryMask", ((ComponentSlotMap)this.slotMap).getDeepOrCategoryMask());
        }
    }

    protected static Property newProperty(int flags, BValue defaultValue, BFacets facets) {
        if (defaultValue == null) {
            throw new NullPointerException("Null defaultValue");
        }
        if (facets == null) {
            facets = BFacets.NULL;
        }
        return new NProperty(flags, defaultValue, facets);
    }

    protected static Property newProperty(int flags, boolean defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BBoolean.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, int defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BInteger.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, long defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BLong.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, float defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BFloat.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, double defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BDouble.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, String defaultValue, BFacets facets) {
        return BComplex.newProperty(flags, BString.make(defaultValue), facets);
    }

    protected static Property newProperty(int flags, BValue defaultValue) {
        return BComplex.newProperty(flags, defaultValue, null);
    }

    protected static Property newProperty(int flags, boolean defaultValue) {
        return BComplex.newProperty(flags, BBoolean.make(defaultValue), null);
    }

    protected static Property newProperty(int flags, int defaultValue) {
        return BComplex.newProperty(flags, BInteger.make(defaultValue), null);
    }

    protected static Property newProperty(int flags, long defaultValue) {
        return BComplex.newProperty(flags, BLong.make(defaultValue), null);
    }

    protected static Property newProperty(int flags, float defaultValue) {
        return BComplex.newProperty(flags, BFloat.make(defaultValue), null);
    }

    protected static Property newProperty(int flags, double defaultValue) {
        return BComplex.newProperty(flags, BDouble.make(defaultValue), null);
    }

    protected static Property newProperty(int flags, String defaultValue) {
        return BComplex.newProperty(flags, BString.make(defaultValue), null);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 1: {
                return this.slotMap;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    final ComplexSlotMap getSlotMap() {
        return this.slotMap;
    }

    static {
        BComplex.copyHintsDefault.defaultOnClone = true;
        BComplex.copyHintsExact.defaultOnClone = false;
        IN = "(In) ";
        OUT = "(Out) ";
    }
}

