/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BBoolean
extends BEnum
implements BIBoolean,
BIDataValue {
    public static final BBoolean TRUE = new BBoolean(true);
    public static final BBoolean FALSE;
    public static final BBoolean DEFAULT;
    public static final Type TYPE;
    private boolean value;
    BDynamicEnum asDynamic;

    public static BBoolean make(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static BBoolean make(String s) {
        return BBoolean.decode(s) ? TRUE : FALSE;
    }

    private BBoolean(boolean v) {
        this.value = v;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public BFacets getBooleanFacets() {
        return BFacets.NULL;
    }

    public BBoolean not() {
        return BBoolean.make(!this.value);
    }

    public BBoolean and(BBoolean other) {
        return BBoolean.make(this.value && other.value);
    }

    public BBoolean or(BBoolean other) {
        return BBoolean.make(this.value || other.value);
    }

    @Override
    public int getOrdinal() {
        return this.value ? 1 : 0;
    }

    @Override
    public String getTag() {
        return this.value ? "true" : "false";
    }

    @Override
    public String getDisplayTag(Context cx) {
        return this.getTag();
    }

    @Override
    public BEnumRange getRange() {
        return BEnumRange.BOOLEAN_RANGE;
    }

    @Override
    public boolean isActive() {
        return this.value;
    }

    @Override
    public int hashCode() {
        if (this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString(Context context) {
        return BBoolean.toString(this.value, context);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(this.value);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return in.readBoolean() ? TRUE : FALSE;
    }

    @Override
    public String encodeToString() throws IOException {
        return BBoolean.encode(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BBoolean.make(s);
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    public static String encode(boolean value) {
        return value ? "true" : "false";
    }

    public static boolean decode(String s) {
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean: " + s);
    }

    public static String toString(boolean value, Context context) {
        if (context != null) {
            if (value) {
                BObject text = context.getFacet("trueText");
                if (text != null) {
                    return BFormat.format(text.toString(), null, context);
                }
            } else {
                BObject text = context.getFacet("falseText");
                if (text != null) {
                    return BFormat.format(text.toString(), null, context);
                }
            }
        }
        return Lexicon.make("baja", context).getText(value ? "true" : "false");
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = FALSE = new BBoolean(false);
        TYPE = Sys.loadType(BBoolean.class);
    }
}

