/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import com.tridium.sys.engine.ProxyKnob;
import com.tridium.sys.engine.ProxyRelationKnob;
import com.tridium.sys.schema.ComponentSlotMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;

public class SyncDecoder
extends ValueDocDecoder {
    Map<BComponent, List<IElement>> knobs;
    Map<BComponent, List<IElement>> rknobs;

    public SyncDecoder(ValueDocDecoder.IDecoderPlugin plugin) throws Exception {
        super(plugin);
    }

    public SyncDecoder(InputStream in) throws Exception {
        super(in);
    }

    public SyncDecoder(ValueDocDecoder.IDecoderPlugin plugin, Context cx) throws Exception {
        super(plugin, cx);
    }

    public SyncDecoder(InputStream in, Context cx) throws Exception {
        super(in, cx);
    }

    @Override
    protected void decodingComponent(BComponent c) throws Exception {
        IElement elem = this.elem();
        String elemName = elem.name();
        if (elemName.equals("load")) {
            this.decodingLoadInfo(c, elem);
        }
        if (elemName.equals("nknob")) {
            this.decodingKnob(c, elem);
        }
        if (elemName.equals("nrknob")) {
            this.decodingRelationKnob(c, elem);
        }
        this.skip();
    }

    private void decodingLoadInfo(BComponent c, IElement elem) {
        if (this.knobs == null) {
            this.knobs = new HashMap<BComponent, List<IElement>>();
        }
        this.knobs.put(c, new ArrayList(4));
        if (this.rknobs == null) {
            this.rknobs = new HashMap<BComponent, List<IElement>>();
        }
        this.rknobs.put(c, new ArrayList(4));
        String permissionsStr = elem.get("p", null);
        if (permissionsStr != null) {
            try {
                BPermissions permissions = BPermissions.make(permissionsStr);
                ((ComponentSlotMap)c.fw(1)).setCachedPermissions(permissions);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void decodingKnob(BComponent c, IElement elem) {
        if (this.knobs == null) {
            throw new IllegalStateException("unexpected <nknob> without <load>");
        }
        List<IElement> list = this.knobs.get(c);
        list.add(this.elem().copy());
    }

    private void decodingRelationKnob(BComponent c, IElement elem) {
        if (this.rknobs == null) {
            throw new IllegalStateException("unexpected <nrknob> without <load>");
        }
        List<IElement> list = this.rknobs.get(c);
        list.add(this.elem().copy());
    }

    protected Knob decodeKnob(BComponent component) throws Exception {
        return SyncDecoder.decodeKnob(component, this.elem());
    }

    static ProxyKnob decodeKnob(BComponent component, IElement elem) throws Exception {
        Slot sourceSlot = component.getSlot(elem.get("ss"));
        if (sourceSlot == null) {
            return null;
        }
        int id = elem.geti("id");
        BOrd targetOrd = BOrd.make(elem.get("to"));
        String targetSlot = elem.get("ts");
        return new ProxyKnob(id, component, sourceSlot, targetOrd, targetSlot);
    }

    protected RelationKnob decodeRelationKnob(BComponent component) throws Exception {
        return SyncDecoder.decodeRelationKnob(component, this.elem());
    }

    static ProxyRelationKnob decodeRelationKnob(BComponent component, IElement elem) throws Exception {
        int id = elem.geti("id");
        BOrd relationOrd = BOrd.make(elem.get("ro"));
        String rid = elem.get("ri");
        BFacets facets = BFacets.make(elem.get("rt"));
        return new ProxyRelationKnob(id, rid, facets, component, relationOrd);
    }
}

