/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class RemoveOp
extends SyncOp {
    String name;

    public RemoveOp(BComponent c, String name) {
        super(c);
        this.name = name;
    }

    public RemoveOp() {
    }

    @Override
    public int getId() {
        return 118;
    }

    public String getSlotName() {
        return this.name;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        Property prop = this.component.getProperty(this.name);
        if (prop != null) {
            this.component.remove(prop, context);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        out.attr("n", this.name).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        this.name = in.elem().get("n");
    }

    @Override
    public String toString() {
        return "Remove: " + this.componentToString() + "." + this.name;
    }
}

