/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Topic;

public class FireTopicOp
extends SyncOp {
    String name;
    BValue event;

    public FireTopicOp(BComponent c, String name, BValue event) {
        super(c);
        this.name = name;
        this.event = event;
    }

    public FireTopicOp() {
    }

    @Override
    public int getId() {
        return 116;
    }

    public String getSlotName() {
        return this.name;
    }

    public BValue getEvent() {
        return this.event;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        Topic topic = this.component.getTopic(this.name);
        if (topic != null) {
            this.component.fire(topic, this.event, Context.commit);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        BPermissions permissions;
        if (this.event != null && this.event.isComponent() && !(permissions = out.getPermissionsFor(this.event.asComponent())).hasOperatorRead()) {
            throw new SyncOp.SyncOpSecurityException("Missing op read permission on value");
        }
        super.encode(out);
        out.attr("n", this.name).endAttr().newLine();
        if (this.event != null) {
            out.key("b");
            out.encode(this.event);
        }
        out.end(String.valueOf((char)this.getId())).newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        this.name = in.elem().get("n");
        in.next();
        if (in.type() == 1 && in.elem().name().equals("p")) {
            this.event = in.decode();
        }
    }

    @Override
    public String toString() {
        return "FireTopic: " + this.componentToString() + "." + this.name + " -> " + this.event;
    }
}

