/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.crypto;

import com.tridium.sys.Nre;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class CertManagerFactory {
    private static Logger log = Logger.getLogger("crypto");
    private static ICryptoManager instance = null;
    private static final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCertManagerActive() {
        try {
            CertManagerFactory.getInstance();
            Object object = mutex;
            synchronized (object) {
                if (instance != null) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICryptoManager getInstance() throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                if (Nre.protectedStationHome != null) {
                    if (Sys.getStation() == null) throw new NotRunningException("station hasn't finished loading services, can't retrieve ICryptoManager instance");
                    if (Sys.getStation().isRunning() && (instance = (ICryptoManager)((Object)Sys.getService(Sys.getType("platCrypto:CertManagerService")))) == null) {
                        throw new ServiceNotFoundException("unable to find CertManagerService");
                    }
                } else if (Nre.bootEnv.isRemote()) {
                    Type type = Sys.getType("platCrypto:WbAppletCertManager");
                    instance = CertManagerFactory.make(type.getTypeClass());
                    if (instance == null) {
                        throw new ServiceNotFoundException("unable to find WbAppletCertManager instance");
                    }
                } else {
                    Type type = Sys.getType("platCrypto:WbCertManager");
                    instance = CertManagerFactory.make(type.getTypeClass());
                    if (instance == null) {
                        throw new ServiceNotFoundException("unable to find WbCertManager instance");
                    }
                }
            }
            return instance;
        }
    }

    private static ICryptoManager make(Class<?> cls) {
        try {
            Method mthd = cls.getMethod("make", new Class[0]);
            ICryptoManager instance = (ICryptoManager)mthd.invoke(cls, new Object[0]);
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.SEVERE, "unable to call make on " + cls.getName(), e);
            return null;
        }
    }
}

