/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

public class SecurityAuditEvent {
    public static final String LOGIN = "Login";
    public static final String LOGOUT = "Logout";
    public static final String LOGIN_FAILURE = "Login Failure";
    public static final String TIMEOUT = "Logout (Timeout)";
    public static final String CHANGED = "Changed";
    public static final String RECATEGORIZED = "Recategorized";
    public static final String SYSTEM_USER = "--system--";
    public static final String STARTUP = "Startup";
    public static final String SHUTDOWN = "Shutdown";
    public static final String INVOKED = "Invoked";
    private final DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");
    private final String operation;
    private final String userName;
    private final String message;
    private final BAbsTime timestamp;

    public SecurityAuditEvent(String operation, String userName, String message) {
        this.operation = operation;
        this.userName = userName;
        this.message = message;
        this.timestamp = Clock.time();
    }

    public String getOperation() {
        return this.operation;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getMessage() {
        return this.message;
    }

    public BAbsTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("[%s][%s][%s][%s]", this.format.format(new Date(this.timestamp.getMillis())), this.userName, this.operation, this.message);
    }
}

