/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.Pbkdf2;
import com.tridium.nre.security.KeyDerivationAlgorithmBundle;
import com.tridium.nre.security.SecretChars;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public final class BPbkdf2HmacSha256PasswordEncoder
extends BAbstractPasswordEncoder
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BPbkdf2HmacSha256PasswordEncoder.class);
    private String salt;
    private String key;
    private int iterationCount;
    public static final KeyDerivationAlgorithmBundle ALGORITHM_BUNDLE = NiagaraStationAlgorithmBundle.getInstance();
    public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
    private static final int ITERATION_COUNT = 100000;
    private static final int SALT_LENGTH = 16;
    private static final byte[] FAKE_SALT_PREPEND_BYTES = new byte[16];

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encode(SecretChars password) throws Exception {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        this.salt = ByteArrayUtil.toHexString((byte[])salt);
        this.iterationCount = 100000;
        byte[] key = Pbkdf2.deriveKey((byte[])salt, (int)this.iterationCount, (char[])password.get(), (KeyDerivationAlgorithmBundle)ALGORITHM_BUNDLE);
        this.key = TextUtil.bytesToHexString((byte[])key);
    }

    @Override
    public void parse(String key) throws IllegalArgumentException {
        String[] data = ALGORITHM_BUNDLE.decode(key);
        this.salt = data[0];
        this.iterationCount = Integer.parseInt(data[1]);
        this.key = data[2];
    }

    @Override
    public String getValue() {
        String[] data = new String[ALGORITHM_BUNDLE.getDataElementCount()];
        data[0] = this.salt;
        data[1] = String.valueOf(this.iterationCount);
        data[2] = this.key;
        return ALGORITHM_BUNDLE.encode(data);
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public boolean validate(SecretChars password) {
        try {
            byte[] key = Pbkdf2.deriveKey((byte[])ByteArrayUtil.hexStringToBytes((String)this.salt), (int)this.iterationCount, (char[])password.get(), (KeyDerivationAlgorithmBundle)ALGORITHM_BUNDLE);
            String tkey = TextUtil.bytesToHexString((byte[])key);
            return SecurityUtil.equals((String)tkey, (String)this.key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getEncodedValue() {
        return this.getValue();
    }

    public void encode(String password, String salt, int iterationCount) throws Exception {
        this.salt = salt;
        this.iterationCount = iterationCount;
        byte[] hexSalt = ByteArrayUtil.hexStringToBytes((String)salt);
        byte[] key = Pbkdf2.deriveKey((byte[])hexSalt, (int)iterationCount, (String)password, (KeyDerivationAlgorithmBundle)ALGORITHM_BUNDLE);
        this.key = TextUtil.bytesToHexString((byte[])key);
    }

    public String getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getKey() {
        return ByteArrayUtil.hexStringToBytes((String)this.key);
    }

    public static BPbkdf2HmacSha256PasswordEncoder makeFake(String userName) {
        byte[] key = new byte[ALGORITHM_BUNDLE.getKeyLength()];
        new SecureRandom().nextBytes(key);
        BPbkdf2HmacSha256PasswordEncoder fake = new BPbkdf2HmacSha256PasswordEncoder();
        fake.key = TextUtil.bytesToHexString((byte[])key);
        try {
            MessageDigest md = MessageDigest.getInstance("Sha-256");
            byte[] strBytes = userName.getBytes(StandardCharsets.UTF_8);
            byte[] combinedArray = ByteBuffer.allocate(16 + strBytes.length).put(FAKE_SALT_PREPEND_BYTES).put(strBytes).array();
            byte[] salt = md.digest(combinedArray);
            fake.salt = TextUtil.bytesToHexString((byte[])Arrays.copyOf(salt, 16));
            fake.iterationCount = 100000;
            return fake;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    static {
        new SecureRandom().nextBytes(FAKE_SALT_PREPEND_BYTES);
    }
}

