/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.SecretChars;
import com.tridium.user.BUserPasswordConfiguration;
import java.security.AccessController;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BUserPasswordChangeParams;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT", flags=256, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"wbutil:UserPasswordFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:UserPasswordEditor\"")}, override=true), @NiagaraProperty(name="passwordConfig", type="BUserPasswordConfiguration", defaultValue="new BUserPasswordConfiguration()")})
@NiagaraAction(name="updatePassword", parameterType="BUserPasswordChangeParams", defaultValue="new BUserPasswordChangeParams()", flags=256, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})
public class BPasswordAuthenticator
extends BPasswordCache
implements IPropertyValidator,
BIUnlinkable {
    @Generated
    public static final Property password = BPasswordAuthenticator.newProperty(256, BPassword.DEFAULT, BFacets.make(BFacets.make("fieldEditor", "wbutil:UserPasswordFE"), BFacets.make("uxFieldEditor", "webEditors:UserPasswordEditor")));
    @Generated
    public static final Property passwordConfig = BPasswordAuthenticator.newProperty(0, new BUserPasswordConfiguration(), null);
    @Generated
    public static final Action updatePassword = BPasswordAuthenticator.newAction(256, new BUserPasswordChangeParams(), BFacets.make("security", BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordAuthenticator.class);
    public static final Context pwConverted = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public String toString() {
            return "Context.pwConverted";
        }
    };
    private boolean passwordConverted = false;
    private Queue updatePasswordFailTimes;
    private static final BRelTime LOCKOUT_WINDOW_UPDATE_PASSWORD_FAIL = BRelTime.makeSeconds(AccessController.doPrivileged(() -> Integer.getInteger("niagara.updatePassword.lockoutWindowUpdatePasswordFail", 60)));
    private static final BRelTime LOCKOUT_PERIOD_UPDATE_PASSWORD_FAIL = BRelTime.makeSeconds(AccessController.doPrivileged(() -> Integer.getInteger("niagara.updatePassword.lockoutPeriodUpdatePasswordFail", 300)));
    private static final int MAX_BAD_ATTEMPT_CURRENT_PASSWORD = AccessController.doPrivileged(() -> Integer.getInteger("niagara.updatePassword.maxBadAttemptCurrentPassword", 5));
    private boolean isLockOut;
    private BAbsTime lockOutTime = BAbsTime.make();
    private static final Logger LOG = Logger.getLogger("user");
    public static final BPasswordAuthenticator DEFAULT = new BPasswordAuthenticator();

    @Generated
    public BUserPasswordConfiguration getPasswordConfig() {
        return (BUserPasswordConfiguration)this.get(passwordConfig);
    }

    @Generated
    public void setPasswordConfig(BUserPasswordConfiguration v) {
        this.set(passwordConfig, (BValue)v, null);
    }

    @Generated
    public void updatePassword(BUserPasswordChangeParams parameter) {
        this.invoke(updatePassword, parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPasswordAuthenticator() {
    }

    public BPasswordAuthenticator(BPassword value) {
        this.setPassword(value);
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                BComponentSpace space = this.getComponentSpace();
                if (space != null && !space.fireDirectCallbacks()) break;
                this.fwChanged((Property)a, (Context)b);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public void started() {
        if (this.isInUserService()) {
            this.convertToPbkdf2Password();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        BComplex parent;
        if (!this.isRunning()) {
            return;
        }
        if (property == passwordConfig && (parent = this.getParent()) instanceof BComponent) {
            parent.asComponent().changed(this.getPropertyInParent(), context);
        }
        if (property.getType() == BPassword.TYPE) {
            this.invalidUserSessions((BUser)this.getParent());
        }
    }

    private void fwChanged(Property prop, Context cx) {
        if (this.isInUserService() && password.equals(prop) && cx != pwConverted) {
            this.convertToPbkdf2Password();
        }
    }

    public void checkPassword(BPassword newPassword, Context context) {
        BComplex parent = this.getParent();
        if (parent instanceof BUser) {
            BUser user = (BUser)parent;
            user.lease(1);
            BAuthenticationScheme scheme = user.getAuthenticationScheme();
            if (scheme instanceof BPasswordAuthenticationScheme) {
                scheme.lease(1);
                BPasswordAuthenticator.checkPassword(user, (BPasswordAuthenticationScheme)scheme, this.getPasswordConfig(), newPassword, context);
            }
        }
    }

    public static void checkPassword(BUser user, BPasswordAuthenticationScheme scheme, BUserPasswordConfiguration config, BPassword newPassword, Context context) {
        if (!newPassword.getPasswordEncoder().isReversible()) {
            return;
        }
        try {
            BPasswordStrength strength = scheme.getGlobalPasswordConfiguration().getPasswordStrength();
            try (SecretChars passChars = AccessController.doPrivileged(newPassword::getSecretChars);){
                AtomicReference messageRef = new AtomicReference();
                if (!strength.isPasswordValid(passChars.get(), messageRef::set)) {
                    throw new LocalizableRuntimeException("baja", ((Localizable)messageRef.get()).toString(context));
                }
            }
            if (user != null && scheme.isDuplicatePassword(newPassword, user)) {
                throw new LocalizableRuntimeException("baja", "user.strongPassword.alreadyUsed");
            }
            if (config != null) {
                config.changeIntervalCheck(scheme.getGlobalPasswordConfiguration());
            }
        }
        catch (LocalizableRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotValidateException(e);
        }
    }

    private boolean isInUserService() {
        if (this.getParent() != null) {
            BComplex parent = this.getParent().getParent();
            return parent instanceof BUserService;
        }
        return false;
    }

    @Override
    public boolean canLogin() {
        return true;
    }

    @Override
    public boolean requiresCredentialsReset() {
        return this.getPasswordConfig().getForceResetAtNextLogin();
    }

    public boolean convertToPbkdf2Password() {
        BPassword oldPw = this.getPassword();
        if (oldPw.getPasswordEncoder().isReversible()) {
            this.getPasswordConfig().passwordModified();
            BPassword newPw = BPassword.make(AccessController.doPrivileged(oldPw::getValue), BAes256Pbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
            this.set("password", (BValue)newPw, pwConverted);
            this.passwordConverted = true;
            return true;
        }
        if (oldPw.getPasswordEncoder() instanceof BPbkdf2HmacSha256PasswordEncoder) {
            try {
                BAes256Pbkdf2HmacSha256PasswordEncoder aesPbkdf2Encoder = new BAes256Pbkdf2HmacSha256PasswordEncoder();
                aesPbkdf2Encoder.encode(oldPw.encodeToString());
                BPassword newPw = BPassword.make(aesPbkdf2Encoder);
                this.set("password", (BValue)newPw, pwConverted);
                this.passwordConverted = true;
                return true;
            }
            catch (Exception e) {
                BUser user = (BUser)this.getParent();
                LOG.log(Level.WARNING, String.format("Could not update password encoding for user: %s. User has been disabled. Cause is: %s", user.getUsername(), e.getMessage()), LOG.isLoggable(Level.FINE) ? e : null);
            }
        }
        return false;
    }

    public boolean isPasswordConverted() {
        return this.passwordConverted;
    }

    public final void doUpdatePassword(BUserPasswordChangeParams passwordChange, Context cx) {
        BPassword userPassword;
        if (this.isLockOut) {
            if (this.lockOutTime.compareTo(BAbsTime.now()) > 0) {
                throw new LocalizableRuntimeException("baja", "user.password.change.maxBadAttemptLockOut", new String[]{BInteger.make(MAX_BAD_ATTEMPT_CURRENT_PASSWORD).toString(cx), LOCKOUT_PERIOD_UPDATE_PASSWORD_FAIL.toString(cx)});
            }
            this.isLockOut = false;
            this.lockOutTime = BAbsTime.make();
        }
        if (!(userPassword = this.getPassword()).validate(passwordChange.getCurrentPassword())) {
            this.updatePasswordFailed();
            throw new LocalizableRuntimeException("baja", "user.password.change.currentPasswordNotMatching");
        }
        UpdatePasswordActionContext upCx = new UpdatePasswordActionContext(cx);
        this.set(BPasswordCache.password, (BValue)passwordChange.getNewPassword(), (Context)upCx);
        this.resetLockoutProperties();
    }

    private void resetLockoutProperties() {
        this.isLockOut = false;
        this.lockOutTime = BAbsTime.make();
        if (this.updatePasswordFailTimes != null) {
            this.updatePasswordFailTimes.dequeue();
        }
    }

    private void updatePasswordFailed() {
        this.updatePasswordFailTimes = this.getUpdatePasswordFailTimes();
        BAbsTime now = BAbsTime.now();
        this.updatePasswordFailTimes.enqueue(now);
        BAbsTime startOfWindow = now.subtract(LOCKOUT_WINDOW_UPDATE_PASSWORD_FAIL);
        while (((BAbsTime)this.updatePasswordFailTimes.peek()).isBefore(startOfWindow)) {
            this.updatePasswordFailTimes.dequeue();
        }
        if (this.updatePasswordFailTimes.size() >= MAX_BAD_ATTEMPT_CURRENT_PASSWORD) {
            this.isLockOut = true;
            this.lockOutTime = now.add(LOCKOUT_PERIOD_UPDATE_PASSWORD_FAIL);
        }
    }

    private Queue getUpdatePasswordFailTimes() {
        if (this.updatePasswordFailTimes == null) {
            this.updatePasswordFailTimes = new Queue();
        }
        return this.updatePasswordFailTimes;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
        if (Arrays.asList(validatable.getModifiedProperties()).contains(password)) {
            this.doValidateSet(context, (BPassword)validatable.getProposedValue(password));
        }
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (property.equals(password)) {
            this.doValidateSet(context, (BPassword)newValue);
        }
    }

    private void doValidateSet(Context context, BPassword password) {
        if (!(context instanceof UpdatePasswordActionContext) && !this.getPermissions(context).hasAdminWrite()) {
            throw new LocalizableRuntimeException("baja", "user.password.change.permission");
        }
        if (context != pwConverted) {
            this.checkPassword(password, context);
        }
    }

    private static class UpdatePasswordActionContext
    extends BasicContext {
        private UpdatePasswordActionContext(Context cx) {
            super(cx);
        }

        @Override
        public String toString() {
            return "UpdatePasswordActionContext";
        }
    }
}

