/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.auth.Pbkdf2;
import com.tridium.nre.security.AesPbkdf2AlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.KeyDerivationAlgorithmBundle;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public final class BAes256Pbkdf2HmacSha256PasswordEncoder
extends BAes256PasswordEncoder {
    @Generated
    public static final Type TYPE = Sys.loadType(BAes256Pbkdf2HmacSha256PasswordEncoder.class);
    public static final AesPbkdf2AlgorithmBundle ALGORITHM_BUNDLE = AesPbkdf2AlgorithmBundle.make((int)256);
    public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
    private static final int ITERATION_COUNT = 100000;
    private static final int SALT_LENGTH = 16;
    private static final int IV_LENGTH = 16;
    private static final byte[] HASHED_START = ("[" + BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE + "]").getBytes(StandardCharsets.UTF_8);
    private static final Map<String, String> AES_TO_AES_PBKDF2_VERSION_MAP;
    private final SecureRandom secureRandom = new SecureRandom();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    public static String getVersionFromAesEncoderVersion(String aesVersion) {
        String aesPbkdf2Version = AES_TO_AES_PBKDF2_VERSION_MAP.get(aesVersion);
        return aesPbkdf2Version == null ? ALGORITHM_BUNDLE.getAlgorithmVersion() : aesPbkdf2Version;
    }

    @Override
    public void encode(SecretBytes passwordBytes) throws Exception {
        if (BAes256Pbkdf2HmacSha256PasswordEncoder.isHashed(passwordBytes)) {
            super.encode(passwordBytes);
        } else {
            KeyDerivationAlgorithmBundle pbkdf2AlgorithmBundle = ALGORITHM_BUNDLE.getPbkdf2AlgorithmBundle();
            byte[] salt = new byte[16];
            this.secureRandom.nextBytes(salt);
            String salt1 = ByteArrayUtil.toHexString((byte[])salt);
            int iterationCount = 100000;
            try (SecretChars passwordChars = SecretChars.fromSecretBytes((SecretBytes)passwordBytes);){
                byte[] hashedPassword = Pbkdf2.deriveKey((byte[])salt, (int)iterationCount, (char[])passwordChars.get(), (KeyDerivationAlgorithmBundle)pbkdf2AlgorithmBundle);
                String hashData = pbkdf2AlgorithmBundle.encode(new String[]{salt1, String.valueOf(iterationCount), TextUtil.bytesToHexString((byte[])hashedPassword)});
                try (SecretBytes hashBytes = SecretBytes.fromString((String)hashData);){
                    super.encode(hashBytes);
                }
            }
        }
    }

    @Override
    public boolean validate(SecretBytes secret) throws Exception {
        BPbkdf2HmacSha256PasswordEncoder pbkdf2Encoder = new BPbkdf2HmacSha256PasswordEncoder();
        pbkdf2Encoder.parse(this.getValue());
        try (SecretChars secretChars = SecretChars.fromSecretBytes((SecretBytes)secret);){
            boolean bl = pbkdf2Encoder.validate(secretChars);
            return bl;
        }
    }

    @Override
    protected EncryptionAlgorithmBundle getAlgorithmBundle() {
        return ALGORITHM_BUNDLE;
    }

    private static boolean isHashed(SecretBytes passwordBytes) {
        return ByteArrayUtil.equals((byte[])HASHED_START, (byte[])Arrays.copyOf(passwordBytes.get(), HASHED_START.length));
    }

    public static BAes256Pbkdf2HmacSha256PasswordEncoder makeFake(String userName) {
        BPbkdf2HmacSha256PasswordEncoder fakePbkdf2 = BPbkdf2HmacSha256PasswordEncoder.makeFake(userName);
        BAes256Pbkdf2HmacSha256PasswordEncoder fakeAesPbkdf2 = new BAes256Pbkdf2HmacSha256PasswordEncoder();
        byte[] iv = new byte[16];
        fakeAesPbkdf2.secureRandom.nextBytes(iv);
        fakeAesPbkdf2.iv = TextUtil.bytesToHexString((byte[])iv);
        try {
            fakeAesPbkdf2.encode(fakePbkdf2.getEncodedValue());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
        return fakeAesPbkdf2;
    }

    public String getSalt() throws Exception {
        BPbkdf2HmacSha256PasswordEncoder pbkdf2Encoder = new BPbkdf2HmacSha256PasswordEncoder();
        pbkdf2Encoder.parse(this.getValue());
        return pbkdf2Encoder.getSalt();
    }

    public int getIterationCount() throws Exception {
        BPbkdf2HmacSha256PasswordEncoder pbkdf2Encoder = new BPbkdf2HmacSha256PasswordEncoder();
        pbkdf2Encoder.parse(this.getValue());
        return pbkdf2Encoder.getIterationCount();
    }

    public byte[] getKey() throws Exception {
        BPbkdf2HmacSha256PasswordEncoder pbkdf2Encoder = new BPbkdf2HmacSha256PasswordEncoder();
        pbkdf2Encoder.parse(this.getValue());
        return pbkdf2Encoder.getKey();
    }

    static {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        versionMap.put("2", "1");
        AES_TO_AES_PBKDF2_VERSION_MAP = Collections.unmodifiableMap(versionMap);
    }
}

