/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import java.util.Objects;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAes256PasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public class BAes256PasswordEncoder
extends BAbstractAes256PasswordEncoder
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAes256PasswordEncoder.class);
    public static final AesAlgorithmBundle ALGORITHM_BUNDLE = AesAlgorithmBundle.make((int)256);
    public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAes256PasswordEncoder() {
        this.keyAlias = "javax.baja.security.BAes256PasswordEncoder.key";
    }

    @Override
    public void parse(String key) throws Exception {
        try {
            String[] data = this.getAlgorithmBundle().decode(key);
            Objects.requireNonNull(data);
            this.iv = data[0];
            this.cipher = data[1];
        }
        catch (IllegalArgumentException iae) {
            this.encode(key);
        }
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public String getEncodedValue() {
        String[] data = new String[this.getAlgorithmBundle().getDataElementCount()];
        data[1] = this.cipher;
        data[0] = this.iv;
        return this.getAlgorithmBundle().encode(data);
    }

    @Override
    protected EncryptionAlgorithmBundle getAlgorithmBundle() {
        return ALGORITHM_BUNDLE;
    }
}

