/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.SecretChars;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BAbstractPasswordEncoder
extends BObject
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractPasswordEncoder.class);
    private static final Logger LOG = Logger.getLogger("baja");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void encode(String password) throws Exception {
        try (SecretChars chars = SecretChars.fromString((String)password);){
            this.encode(chars);
        }
    }

    public abstract void encode(SecretChars var1) throws Exception;

    public abstract void parse(String var1) throws Exception;

    public abstract String getValue() throws Exception;

    public SecretChars getSecretChars() throws Exception {
        return SecretChars.fromString((String)this.getValue());
    }

    public abstract String getEncodingType();

    public abstract boolean isReversible();

    public final boolean validate(String password) throws Exception {
        try (SecretChars chars = SecretChars.fromString((String)password);){
            boolean bl = this.validate(chars);
            return bl;
        }
    }

    public abstract boolean validate(SecretChars var1) throws Exception;

    public abstract String getEncodedValue();

    public static String getDefaultEncodingType(boolean isReversible) {
        return isReversible ? BAes256PasswordEncoder.ENCODING_TYPE : BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE;
    }

    public static BAbstractPasswordEncoder makeDefaultInstance(boolean isReversible) throws Exception {
        return BAbstractPasswordEncoder.make(BAbstractPasswordEncoder.getDefaultEncodingType(isReversible));
    }

    public static BAbstractPasswordEncoder make(String encodingType) throws Exception {
        encodingType = BAbstractPasswordEncoder.stripBrackets(encodingType);
        Type resolvedType = (Type)EncodingTypesHolder.encodingTypes.get(encodingType);
        if (resolvedType == null) {
            throw new IllegalArgumentException("unrecognized encoding type: " + encodingType);
        }
        BObject o = resolvedType.getInstance();
        return (BAbstractPasswordEncoder)o;
    }

    private static String stripBrackets(String encodingType) {
        if (encodingType.startsWith("[")) {
            return encodingType.substring(1, encodingType.length() - 1);
        }
        return encodingType;
    }

    private static final class EncodingTypesHolder {
        private static final Map<String, Type> encodingTypes = EncodingTypesHolder.createEncodingMap();

        private EncodingTypesHolder() {
        }

        private static Map<String, Type> createEncodingMap() {
            HashMap<String, Type> encodingMap = new HashMap<String, Type>();
            Lexicon lex = Lexicon.make("baja");
            TypeInfo agentType = null;
            AgentList agents = Sys.getRegistry().getAgents(Sys.getRegistry().getType("baja:Password"));
            agents = agents.filter(AgentFilter.is(TYPE));
            for (int i = 0; i < agents.size(); ++i) {
                try {
                    agentType = agents.get(i).getAgentType();
                    Type resolvedType = agentType.getTypeSpec().getResolvedType();
                    Class<?> c = resolvedType.getTypeClass();
                    String encodingType = (String)c.getField("ENCODING_TYPE").get(null);
                    encodingMap.put(encodingType, resolvedType);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    LOG.severe(lex.getText("password.encoder.noTypeField", agentType.getTypeName()));
                    continue;
                }
                catch (Exception e) {
                    LOG.severe(lex.getText("password.encoder.genericFailure", agentType == null ? "unknown agent type" : agentType.getTypeName(), e));
                }
            }
            return Collections.unmodifiableMap(encodingMap);
        }
    }
}

